/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.util.Properties;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.binding.AbstractCollectionElement;
import org.hibernate.metamodel.binding.AbstractPluralAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BasicCollectionElement;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityDiscriminator;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.SingularAttributeBinding;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.relational.Datatype;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Value;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

class HibernateTypeResolver {
    private final MetadataImplementor metadata;

    HibernateTypeResolver(MetadataImplementor metadataImplementor) {
        this.metadata = metadataImplementor;
    }

    void resolve() {
        for (EntityBinding entityBinding : this.metadata.getEntityBindings()) {
            if (entityBinding.getHierarchyDetails().getEntityDiscriminator() != null) {
                this.resolveDiscriminatorTypeInformation(entityBinding.getHierarchyDetails().getEntityDiscriminator());
            }
            for (AttributeBinding attributeBinding : entityBinding.attributeBindings()) {
                if (SingularAttributeBinding.class.isInstance(attributeBinding)) {
                    this.resolveSingularAttributeTypeInformation((SingularAttributeBinding)SingularAttributeBinding.class.cast(attributeBinding));
                    continue;
                }
                if (AbstractPluralAttributeBinding.class.isInstance(attributeBinding)) {
                    this.resolvePluralAttributeTypeInformation((AbstractPluralAttributeBinding)AbstractPluralAttributeBinding.class.cast(attributeBinding));
                    continue;
                }
                throw new AssertionFailure("Unknown type of AttributeBinding: " + attributeBinding.getClass().getName());
            }
        }
    }

    private void resolveDiscriminatorTypeInformation(EntityDiscriminator entityDiscriminator) {
        Type type = this.determineSingularTypeFromDescriptor(entityDiscriminator.getExplicitHibernateTypeDescriptor());
        if (type != null) {
            this.pushHibernateTypeInformationDownIfNeeded(entityDiscriminator.getExplicitHibernateTypeDescriptor(), entityDiscriminator.getBoundValue(), type);
        }
    }

    private Type determineSingularTypeFromDescriptor(HibernateTypeDescriptor hibernateTypeDescriptor) {
        if (hibernateTypeDescriptor.getResolvedTypeMapping() != null) {
            return hibernateTypeDescriptor.getResolvedTypeMapping();
        }
        String string = HibernateTypeResolver.determineTypeName(hibernateTypeDescriptor);
        Properties properties = HibernateTypeResolver.getTypeParameters(hibernateTypeDescriptor);
        return this.getHeuristicType(string, properties);
    }

    private static String determineTypeName(HibernateTypeDescriptor hibernateTypeDescriptor) {
        return hibernateTypeDescriptor.getExplicitTypeName() != null ? hibernateTypeDescriptor.getExplicitTypeName() : hibernateTypeDescriptor.getJavaTypeName();
    }

    private static Properties getTypeParameters(HibernateTypeDescriptor hibernateTypeDescriptor) {
        Properties properties = new Properties();
        if (hibernateTypeDescriptor.getTypeParameters() != null) {
            properties.putAll(hibernateTypeDescriptor.getTypeParameters());
        }
        return properties;
    }

    private void resolveSingularAttributeTypeInformation(SingularAttributeBinding singularAttributeBinding) {
        if (singularAttributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping() != null) {
            return;
        }
        Type type = this.determineSingularTypeFromDescriptor(singularAttributeBinding.getHibernateTypeDescriptor());
        if (type == null) {
            if (!singularAttributeBinding.getAttribute().isSingular()) {
                throw new AssertionFailure("SingularAttributeBinding object has a plural attribute: " + singularAttributeBinding.getAttribute().getName());
            }
            SingularAttribute singularAttribute = (SingularAttribute)singularAttributeBinding.getAttribute();
            if (singularAttribute.getSingularAttributeType() != null) {
                type = this.getHeuristicType(singularAttribute.getSingularAttributeType().getClassName(), new Properties());
            }
        }
        if (type != null) {
            this.pushHibernateTypeInformationDownIfNeeded(singularAttributeBinding, type);
        }
    }

    private void resolvePluralAttributeTypeInformation(AbstractPluralAttributeBinding abstractPluralAttributeBinding) {
        if (abstractPluralAttributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping() != null) {
            return;
        }
        String string = abstractPluralAttributeBinding.getHibernateTypeDescriptor().getExplicitTypeName();
        Type type = string != null ? this.metadata.getTypeResolver().getTypeFactory().customCollection(string, HibernateTypeResolver.getTypeParameters(abstractPluralAttributeBinding.getHibernateTypeDescriptor()), abstractPluralAttributeBinding.getAttribute().getName(), abstractPluralAttributeBinding.getReferencedPropertyName()) : this.determineDefaultCollectionInformation(abstractPluralAttributeBinding);
        if (type != null) {
            this.pushHibernateTypeInformationDownIfNeeded(abstractPluralAttributeBinding.getHibernateTypeDescriptor(), null, type);
        }
        this.resolveCollectionElementTypeInformation(abstractPluralAttributeBinding.getCollectionElement());
    }

    private Type determineDefaultCollectionInformation(AbstractPluralAttributeBinding abstractPluralAttributeBinding) {
        TypeFactory typeFactory = this.metadata.getTypeResolver().getTypeFactory();
        switch (abstractPluralAttributeBinding.getAttribute().getNature()) {
            case SET: {
                return typeFactory.set(abstractPluralAttributeBinding.getAttribute().getName(), abstractPluralAttributeBinding.getReferencedPropertyName());
            }
            case BAG: {
                return typeFactory.bag(abstractPluralAttributeBinding.getAttribute().getName(), abstractPluralAttributeBinding.getReferencedPropertyName());
            }
        }
        throw new UnsupportedOperationException("Collection type not supported yet:" + (Object)((Object)abstractPluralAttributeBinding.getAttribute().getNature()));
    }

    private void resolveCollectionElementTypeInformation(AbstractCollectionElement abstractCollectionElement) {
        switch (abstractCollectionElement.getCollectionElementNature()) {
            case BASIC: {
                this.resolveBasicCollectionElement((BasicCollectionElement)BasicCollectionElement.class.cast(abstractCollectionElement));
                break;
            }
            case COMPOSITE: 
            case ONE_TO_MANY: 
            case MANY_TO_MANY: 
            case MANY_TO_ANY: {
                throw new UnsupportedOperationException("Collection element nature not supported yet: " + (Object)((Object)abstractCollectionElement.getCollectionElementNature()));
            }
            default: {
                throw new AssertionFailure("Unknown collection element nature : " + (Object)((Object)abstractCollectionElement.getCollectionElementNature()));
            }
        }
    }

    private void resolveBasicCollectionElement(BasicCollectionElement basicCollectionElement) {
        Type type = this.determineSingularTypeFromDescriptor(basicCollectionElement.getHibernateTypeDescriptor());
        if (type != null) {
            this.pushHibernateTypeInformationDownIfNeeded(basicCollectionElement.getHibernateTypeDescriptor(), basicCollectionElement.getElementValue(), type);
        }
    }

    private Type getHeuristicType(String string, Properties properties) {
        if (string != null) {
            try {
                return this.metadata.getTypeResolver().heuristicType(string, properties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void pushHibernateTypeInformationDownIfNeeded(SingularAttributeBinding singularAttributeBinding, Type type) {
        HibernateTypeDescriptor hibernateTypeDescriptor = singularAttributeBinding.getHibernateTypeDescriptor();
        SingularAttribute singularAttribute = (SingularAttribute)SingularAttribute.class.cast(singularAttributeBinding.getAttribute());
        Value value = singularAttributeBinding.getValue();
        if (!singularAttribute.isTypeResolved() && hibernateTypeDescriptor.getJavaTypeName() != null) {
            singularAttribute.resolveType(this.metadata.makeJavaType(hibernateTypeDescriptor.getJavaTypeName()));
        }
        this.pushHibernateTypeInformationDownIfNeeded(hibernateTypeDescriptor, value, type);
    }

    private void pushHibernateTypeInformationDownIfNeeded(HibernateTypeDescriptor hibernateTypeDescriptor, Value value, Type type) {
        SimpleValue simpleValue;
        if (type == null) {
            return;
        }
        if (hibernateTypeDescriptor.getResolvedTypeMapping() == null) {
            hibernateTypeDescriptor.setResolvedTypeMapping(type);
        }
        if (hibernateTypeDescriptor.getJavaTypeName() == null) {
            hibernateTypeDescriptor.setJavaTypeName(type.getReturnedClass().getName());
        }
        if (SimpleValue.class.isInstance(value) && (simpleValue = (SimpleValue)value).getDatatype() == null) {
            simpleValue.setDatatype(new Datatype(type.sqlTypes(this.metadata)[0], type.getName(), type.getReturnedClass()));
        }
    }
}

