/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.SingularAssociationAttributeBinding;
import org.hibernate.metamodel.source.MetadataImplementor;

class AssociationResolver {
    private final MetadataImplementor metadata;

    AssociationResolver(MetadataImplementor metadataImplementor) {
        this.metadata = metadataImplementor;
    }

    void resolve() {
        for (EntityBinding entityBinding : this.metadata.getEntityBindings()) {
            for (SingularAssociationAttributeBinding singularAssociationAttributeBinding : entityBinding.getEntityReferencingAttributeBindings()) {
                this.resolve(singularAssociationAttributeBinding);
            }
        }
    }

    private void resolve(SingularAssociationAttributeBinding singularAssociationAttributeBinding) {
        AttributeBinding attributeBinding;
        if (singularAssociationAttributeBinding.getReferencedEntityName() == null) {
            throw new IllegalArgumentException("attributeBinding has null entityName: " + singularAssociationAttributeBinding.getAttribute().getName());
        }
        EntityBinding entityBinding = this.metadata.getEntityBinding(singularAssociationAttributeBinding.getReferencedEntityName());
        if (entityBinding == null) {
            throw new MappingException(String.format("Attribute [%s] refers to unknown entity: [%s]", singularAssociationAttributeBinding.getAttribute().getName(), singularAssociationAttributeBinding.getReferencedEntityName()));
        }
        AttributeBinding attributeBinding2 = attributeBinding = singularAssociationAttributeBinding.isPropertyReference() ? entityBinding.locateAttributeBinding(singularAssociationAttributeBinding.getReferencedAttributeName()) : entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding();
        if (attributeBinding == null) {
            throw new MappingException(String.format("Attribute [%s] refers to unknown attribute: [%s]", singularAssociationAttributeBinding.getAttribute().getName(), singularAssociationAttributeBinding.getReferencedEntityName()));
        }
        singularAssociationAttributeBinding.resolveReference(attributeBinding);
        attributeBinding.addEntityReferencingAttributeBinding(singularAssociationAttributeBinding);
    }
}

