/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import org.hibernate.EntityMode;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbCacheElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.binder.DiscriminatorSource;
import org.hibernate.metamodel.source.binder.IdentifierSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.RootEntitySource;
import org.hibernate.metamodel.source.binder.SimpleIdentifierSource;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;
import org.hibernate.metamodel.source.binder.TableSource;
import org.hibernate.metamodel.source.hbm.AbstractEntitySourceImpl;
import org.hibernate.metamodel.source.hbm.ColumnAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.ColumnSourceImpl;
import org.hibernate.metamodel.source.hbm.FormulaImpl;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.MappingDocument;
import org.hibernate.metamodel.source.hbm.SingularIdentifierAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.TimestampAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.VersionAttributeSourceImpl;

public class RootEntitySourceImpl
extends AbstractEntitySourceImpl
implements RootEntitySource {
    protected RootEntitySourceImpl(MappingDocument mappingDocument, JaxbHibernateMapping.JaxbClass jaxbClass) {
        super(mappingDocument, jaxbClass);
    }

    protected JaxbHibernateMapping.JaxbClass entityElement() {
        return (JaxbHibernateMapping.JaxbClass)super.entityElement();
    }

    public IdentifierSource getIdentifierSource() {
        if (this.entityElement().getId() != null) {
            return new SimpleIdentifierSource(){

                public SingularAttributeSource getIdentifierAttributeSource() {
                    return new SingularIdentifierAttributeSourceImpl(RootEntitySourceImpl.this.entityElement().getId(), RootEntitySourceImpl.this.sourceMappingDocument().getMappingLocalBindingContext());
                }

                public IdGenerator getIdentifierGeneratorDescriptor() {
                    if (RootEntitySourceImpl.this.entityElement().getId().getGenerator() != null) {
                        String string = RootEntitySourceImpl.this.entityElement().getId().getGenerator().getClazz();
                        IdGenerator idGenerator = RootEntitySourceImpl.this.sourceMappingDocument().getMappingLocalBindingContext().getMetadataImplementor().getIdGenerator(string);
                        if (idGenerator == null) {
                            idGenerator = new IdGenerator(RootEntitySourceImpl.this.getEntityName() + string, string, Helper.extractParameters(RootEntitySourceImpl.this.entityElement().getId().getGenerator().getParam()));
                        }
                        return idGenerator;
                    }
                    return null;
                }

                public IdentifierSource.Nature getNature() {
                    return IdentifierSource.Nature.SIMPLE;
                }
            };
        }
        return null;
    }

    public SingularAttributeSource getVersioningAttributeSource() {
        if (this.entityElement().getVersion() != null) {
            return new VersionAttributeSourceImpl(this.entityElement().getVersion(), this.sourceMappingDocument().getMappingLocalBindingContext());
        }
        if (this.entityElement().getTimestamp() != null) {
            return new TimestampAttributeSourceImpl(this.entityElement().getTimestamp(), this.sourceMappingDocument().getMappingLocalBindingContext());
        }
        return null;
    }

    public EntityMode getEntityMode() {
        return this.determineEntityMode();
    }

    public boolean isMutable() {
        return this.entityElement().isMutable();
    }

    public boolean isExplicitPolymorphism() {
        return "explicit".equals(this.entityElement().getPolymorphism());
    }

    public String getWhere() {
        return this.entityElement().getWhere();
    }

    public String getRowId() {
        return this.entityElement().getRowid();
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        String string = Helper.getStringValue(this.entityElement().getOptimisticLock(), "version");
        try {
            return OptimisticLockStyle.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            throw new MappingException("Unknown optimistic-lock value : " + string, this.sourceMappingDocument().getOrigin());
        }
    }

    public Caching getCaching() {
        JaxbCacheElement jaxbCacheElement = this.entityElement().getCache();
        if (jaxbCacheElement == null) {
            return null;
        }
        String string = jaxbCacheElement.getRegion() != null ? jaxbCacheElement.getRegion() : this.getEntityName();
        AccessType accessType = Enum.valueOf(AccessType.class, jaxbCacheElement.getUsage());
        boolean bl = !"non-lazy".equals(jaxbCacheElement.getInclude());
        return new Caching(string, accessType, bl);
    }

    public TableSource getPrimaryTable() {
        return new TableSource(){

            public String getExplicitSchemaName() {
                return RootEntitySourceImpl.this.entityElement().getSchema();
            }

            public String getExplicitCatalogName() {
                return RootEntitySourceImpl.this.entityElement().getCatalog();
            }

            public String getExplicitTableName() {
                return RootEntitySourceImpl.this.entityElement().getTable();
            }

            public String getLogicalName() {
                return null;
            }
        };
    }

    public String getDiscriminatorMatchValue() {
        return this.entityElement().getDiscriminatorValue();
    }

    public DiscriminatorSource getDiscriminatorSource() {
        final JaxbHibernateMapping.JaxbClass.JaxbDiscriminator jaxbDiscriminator = this.entityElement().getDiscriminator();
        if (jaxbDiscriminator == null) {
            return null;
        }
        return new DiscriminatorSource(){

            public RelationalValueSource getDiscriminatorRelationalValueSource() {
                if (StringHelper.isNotEmpty(jaxbDiscriminator.getColumnAttribute())) {
                    return new ColumnAttributeSourceImpl(null, jaxbDiscriminator.getColumnAttribute(), jaxbDiscriminator.isInsert(), jaxbDiscriminator.isInsert());
                }
                if (StringHelper.isNotEmpty(jaxbDiscriminator.getFormulaAttribute())) {
                    return new FormulaImpl(null, jaxbDiscriminator.getFormulaAttribute());
                }
                if (jaxbDiscriminator.getColumn() != null) {
                    return new ColumnSourceImpl(null, jaxbDiscriminator.getColumn(), jaxbDiscriminator.isInsert(), jaxbDiscriminator.isInsert());
                }
                if (StringHelper.isNotEmpty(jaxbDiscriminator.getFormula())) {
                    return new FormulaImpl(null, jaxbDiscriminator.getFormula());
                }
                throw new MappingException("could not determine source of discriminator mapping", RootEntitySourceImpl.this.getOrigin());
            }

            public String getExplicitHibernateTypeName() {
                return jaxbDiscriminator.getType();
            }

            public boolean isForced() {
                return jaxbDiscriminator.isForce();
            }

            public boolean isInserted() {
                return jaxbDiscriminator.isInsert();
            }
        };
    }
}

