/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.List;
import java.util.Map;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbPropertyElement;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;
import org.hibernate.metamodel.source.hbm.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyAttributeSourceImpl
implements SingularAttributeSource {
    private final JaxbPropertyElement propertyElement;
    private final ExplicitHibernateTypeSource typeSource;
    private final List<RelationalValueSource> valueSources;

    PropertyAttributeSourceImpl(final JaxbPropertyElement jaxbPropertyElement, LocalBindingContext localBindingContext) {
        this.propertyElement = jaxbPropertyElement;
        this.typeSource = new ExplicitHibernateTypeSource(){
            private final String name;
            private final Map<String, String> parameters;
            {
                this.name = jaxbPropertyElement.getTypeAttribute() != null ? jaxbPropertyElement.getTypeAttribute() : (jaxbPropertyElement.getType() != null ? jaxbPropertyElement.getType().getName() : null);
                this.parameters = jaxbPropertyElement.getType() != null ? Helper.extractParameters(jaxbPropertyElement.getType().getParam()) : null;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public Map<String, String> getParameters() {
                return this.parameters;
            }
        };
        this.valueSources = Helper.buildValueSources(new Helper.ValueSourcesAdapter(){

            public String getColumnAttribute() {
                return jaxbPropertyElement.getColumn();
            }

            public String getFormulaAttribute() {
                return jaxbPropertyElement.getFormula();
            }

            public List getColumnOrFormulaElements() {
                return jaxbPropertyElement.getColumnOrFormula();
            }

            public String getContainingTableName() {
                return null;
            }

            public boolean isIncludedInInsertByDefault() {
                return Helper.getBooleanValue(jaxbPropertyElement.isInsert(), true);
            }

            public boolean isIncludedInUpdateByDefault() {
                return Helper.getBooleanValue(jaxbPropertyElement.isUpdate(), true);
            }
        }, localBindingContext);
    }

    @Override
    public String getName() {
        return this.propertyElement.getName();
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return this.typeSource;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.propertyElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return Helper.getBooleanValue(this.propertyElement.isInsert(), true);
    }

    @Override
    public boolean isUpdatable() {
        return Helper.getBooleanValue(this.propertyElement.isUpdate(), true);
    }

    @Override
    public PropertyGeneration getGeneration() {
        return PropertyGeneration.parse(this.propertyElement.getGenerated());
    }

    @Override
    public boolean isLazy() {
        return Helper.getBooleanValue(this.propertyElement.isLazy(), false);
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return Helper.getBooleanValue(this.propertyElement.isOptimisticLock(), true);
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.BASIC;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return Helper.getBooleanValue(this.propertyElement.isInsert(), true);
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return Helper.getBooleanValue(this.propertyElement.isUpdate(), true);
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return !Helper.getBooleanValue(this.propertyElement.isNotNull(), false);
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return this.valueSources;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.propertyElement.getMeta());
    }
}

