/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.List;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbKeyElement;
import org.hibernate.metamodel.relational.ForeignKey;
import org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.hibernate.metamodel.source.binder.PluralAttributeKeySource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.hbm.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluralAttributeKeySourceImpl
implements PluralAttributeKeySource {
    private final JaxbKeyElement keyElement;
    private final List<RelationalValueSource> valueSources;

    public PluralAttributeKeySourceImpl(final JaxbKeyElement jaxbKeyElement, AttributeSourceContainer attributeSourceContainer) {
        this.keyElement = jaxbKeyElement;
        this.valueSources = Helper.buildValueSources(new Helper.ValueSourcesAdapter(){

            public String getContainingTableName() {
                return null;
            }

            public boolean isIncludedInInsertByDefault() {
                return true;
            }

            public boolean isIncludedInUpdateByDefault() {
                return Helper.getBooleanValue(jaxbKeyElement.isUpdate(), true);
            }

            public String getColumnAttribute() {
                return jaxbKeyElement.getColumnAttribute();
            }

            public String getFormulaAttribute() {
                return null;
            }

            public List getColumnOrFormulaElements() {
                return jaxbKeyElement.getColumn();
            }
        }, attributeSourceContainer.getLocalBindingContext());
    }

    @Override
    public List<RelationalValueSource> getValueSources() {
        return this.valueSources;
    }

    @Override
    public String getExplicitForeignKeyName() {
        return this.keyElement.getForeignKey();
    }

    @Override
    public ForeignKey.ReferentialAction getOnDeleteAction() {
        return "cascade".equals(this.keyElement.getOnDelete()) ? ForeignKey.ReferentialAction.CASCADE : ForeignKey.ReferentialAction.NO_ACTION;
    }

    @Override
    public String getReferencedEntityAttributeName() {
        return this.keyElement.getPropertyRef();
    }
}

