/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.List;
import org.hibernate.FetchMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbManyToOneElement;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.ToOneAttributeSource;
import org.hibernate.metamodel.source.hbm.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManyToOneAttributeSourceImpl
implements ToOneAttributeSource {
    private final JaxbManyToOneElement manyToOneElement;
    private final LocalBindingContext bindingContext;
    private final List<RelationalValueSource> valueSources;

    ManyToOneAttributeSourceImpl(final JaxbManyToOneElement jaxbManyToOneElement, LocalBindingContext localBindingContext) {
        this.manyToOneElement = jaxbManyToOneElement;
        this.bindingContext = localBindingContext;
        this.valueSources = Helper.buildValueSources(new Helper.ValueSourcesAdapter(){

            public String getColumnAttribute() {
                return jaxbManyToOneElement.getColumn();
            }

            public String getFormulaAttribute() {
                return jaxbManyToOneElement.getFormula();
            }

            public List getColumnOrFormulaElements() {
                return jaxbManyToOneElement.getColumnOrFormula();
            }

            public String getContainingTableName() {
                return null;
            }

            public boolean isIncludedInInsertByDefault() {
                return jaxbManyToOneElement.isInsert();
            }

            public boolean isIncludedInUpdateByDefault() {
                return jaxbManyToOneElement.isUpdate();
            }
        }, localBindingContext);
    }

    @Override
    public String getName() {
        return this.manyToOneElement.getName();
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return Helper.TO_ONE_ATTRIBUTE_TYPE_SOURCE;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.manyToOneElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return this.manyToOneElement.isInsert();
    }

    @Override
    public boolean isUpdatable() {
        return this.manyToOneElement.isUpdate();
    }

    @Override
    public PropertyGeneration getGeneration() {
        return PropertyGeneration.NEVER;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.manyToOneElement.isOptimisticLock();
    }

    @Override
    public Iterable<CascadeStyle> getCascadeStyles() {
        return Helper.interpretCascadeStyles(this.manyToOneElement.getCascade(), this.bindingContext);
    }

    @Override
    public FetchTiming getFetchTiming() {
        String string;
        String string2 = this.manyToOneElement.getFetch() != null ? this.manyToOneElement.getFetch().value() : null;
        String string3 = this.manyToOneElement.getLazy() != null ? this.manyToOneElement.getLazy().value() : null;
        String string4 = string = this.manyToOneElement.getOuterJoin() != null ? this.manyToOneElement.getOuterJoin().value() : null;
        if (string3 == null) {
            if ("join".equals(string2) || "true".equals(string)) {
                return FetchTiming.IMMEDIATE;
            }
            if ("false".equals(string)) {
                return FetchTiming.DELAYED;
            }
            return this.bindingContext.getMappingDefaults().areAssociationsLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
        }
        if ("extra".equals(string3)) {
            return FetchTiming.EXTRA_LAZY;
        }
        if ("true".equals(string3)) {
            return FetchTiming.DELAYED;
        }
        if ("false".equals(string3)) {
            return FetchTiming.IMMEDIATE;
        }
        throw new MappingException(String.format("Unexpected lazy selection [%s] on '%s'", string3, this.manyToOneElement.getName()), this.bindingContext.getOrigin());
    }

    @Override
    public FetchStyle getFetchStyle() {
        String string;
        String string2 = this.manyToOneElement.getFetch() != null ? this.manyToOneElement.getFetch().value() : null;
        String string3 = string = this.manyToOneElement.getOuterJoin() != null ? this.manyToOneElement.getOuterJoin().value() : null;
        if (string2 == null) {
            if (string == null) {
                return FetchStyle.SELECT;
            }
            if ("auto".equals(string)) {
                return this.bindingContext.getMappingDefaults().areAssociationsLazy() ? FetchStyle.SELECT : FetchStyle.JOIN;
            }
            return "true".equals(string) ? FetchStyle.JOIN : FetchStyle.SELECT;
        }
        return "join".equals(string2) ? FetchStyle.JOIN : FetchStyle.SELECT;
    }

    @Override
    public FetchMode getFetchMode() {
        return this.manyToOneElement.getFetch() == null ? FetchMode.DEFAULT : FetchMode.valueOf(this.manyToOneElement.getFetch().value());
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.MANY_TO_ONE;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return this.manyToOneElement.isInsert();
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return this.manyToOneElement.isUpdate();
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return !Helper.getBooleanValue(this.manyToOneElement.isNotNull(), false);
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return this.valueSources;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.manyToOneElement.getMeta());
    }

    @Override
    public String getReferencedEntityName() {
        return this.manyToOneElement.getClazz() != null ? this.manyToOneElement.getClazz() : this.manyToOneElement.getEntityName();
    }

    @Override
    public String getReferencedEntityAttributeName() {
        return this.manyToOneElement.getPropertyRef();
    }
}

