/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.internal.jaxb.mapping.hbm.EntityElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbJoinedSubclassElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbSubclassElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbUnionSubclassElement;
import org.hibernate.internal.jaxb.mapping.hbm.SubEntityElement;
import org.hibernate.metamodel.source.binder.SubclassEntityContainer;
import org.hibernate.metamodel.source.binder.SubclassEntitySource;
import org.hibernate.metamodel.source.hbm.AbstractEntitySourceImpl;
import org.hibernate.metamodel.source.hbm.EntityHierarchyImpl;
import org.hibernate.metamodel.source.hbm.MappingDocument;
import org.hibernate.metamodel.source.hbm.RootEntitySourceImpl;
import org.hibernate.metamodel.source.hbm.SubclassEntitySourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyBuilder {
    private final List<EntityHierarchyImpl> entityHierarchies = new ArrayList<EntityHierarchyImpl>();
    private final Map<String, SubclassEntityContainer> subEntityContainerMap = new HashMap<String, SubclassEntityContainer>();
    private final List<ExtendsQueueEntry> extendsQueue = new ArrayList<ExtendsQueueEntry>();
    private MappingDocument currentMappingDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMappingDocument(MappingDocument mappingDocument) {
        this.currentMappingDocument = mappingDocument;
        try {
            this.processCurrentMappingDocument();
        }
        finally {
            this.currentMappingDocument = null;
        }
    }

    private void processCurrentMappingDocument() {
        for (Object object : this.currentMappingDocument.getMappingRoot().getClazzOrSubclassOrJoinedSubclass()) {
            Object object2;
            Object object3;
            Object object4;
            EntityElement entityElement = (EntityElement)object;
            if (JaxbHibernateMapping.JaxbClass.class.isInstance(entityElement)) {
                object4 = (JaxbHibernateMapping.JaxbClass)entityElement;
                object3 = new RootEntitySourceImpl(this.currentMappingDocument, (JaxbHibernateMapping.JaxbClass)object4);
                object2 = new EntityHierarchyImpl((RootEntitySourceImpl)object3);
                this.entityHierarchies.add((EntityHierarchyImpl)object2);
                this.subEntityContainerMap.put(((AbstractEntitySourceImpl)object3).getEntityName(), (SubclassEntityContainer)object3);
                this.processSubElements(entityElement, (SubclassEntityContainer)object3);
                continue;
            }
            object4 = new SubclassEntitySourceImpl(this.currentMappingDocument, entityElement);
            object3 = ((AbstractEntitySourceImpl)object4).getEntityName();
            this.subEntityContainerMap.put((String)object3, (SubclassEntityContainer)object4);
            object2 = this.currentMappingDocument.getMappingLocalBindingContext().qualifyClassName(((SubEntityElement)entityElement).getExtends());
            this.processSubElements(entityElement, (SubclassEntityContainer)object4);
            SubclassEntityContainer subclassEntityContainer = this.subEntityContainerMap.get(object2);
            if (subclassEntityContainer != null) {
                subclassEntityContainer.add((SubclassEntitySource)object4);
                continue;
            }
            this.extendsQueue.add(new ExtendsQueueEntry((SubclassEntitySource)object4, (String)object2));
        }
    }

    public List<EntityHierarchyImpl> groupEntityHierarchies() {
        while (!this.extendsQueue.isEmpty()) {
            int n = 0;
            Iterator<ExtendsQueueEntry> iterator = this.extendsQueue.iterator();
            while (iterator.hasNext()) {
                ExtendsQueueEntry extendsQueueEntry = iterator.next();
                SubclassEntityContainer subclassEntityContainer = this.subEntityContainerMap.get(extendsQueueEntry.entityItExtends);
                if (subclassEntityContainer == null) continue;
                subclassEntityContainer.add(extendsQueueEntry.subClassEntitySource);
                iterator.remove();
                ++n;
            }
            if (n != 0) continue;
            throw new MappingException("Unable to process extends dependencies in hbm files");
        }
        return this.entityHierarchies;
    }

    private void processSubElements(EntityElement entityElement, SubclassEntityContainer subclassEntityContainer) {
        if (JaxbHibernateMapping.JaxbClass.class.isInstance(entityElement)) {
            JaxbHibernateMapping.JaxbClass jaxbClass = (JaxbHibernateMapping.JaxbClass)entityElement;
            this.processElements(jaxbClass.getJoinedSubclass(), subclassEntityContainer);
            this.processElements(jaxbClass.getSubclass(), subclassEntityContainer);
            this.processElements(jaxbClass.getUnionSubclass(), subclassEntityContainer);
        } else if (JaxbSubclassElement.class.isInstance(entityElement)) {
            JaxbSubclassElement jaxbSubclassElement = (JaxbSubclassElement)entityElement;
            this.processElements(jaxbSubclassElement.getSubclass(), subclassEntityContainer);
        } else if (JaxbJoinedSubclassElement.class.isInstance(entityElement)) {
            JaxbJoinedSubclassElement jaxbJoinedSubclassElement = (JaxbJoinedSubclassElement)entityElement;
            this.processElements(jaxbJoinedSubclassElement.getJoinedSubclass(), subclassEntityContainer);
        } else if (JaxbUnionSubclassElement.class.isInstance(entityElement)) {
            JaxbUnionSubclassElement jaxbUnionSubclassElement = (JaxbUnionSubclassElement)entityElement;
            this.processElements(jaxbUnionSubclassElement.getUnionSubclass(), subclassEntityContainer);
        }
    }

    private void processElements(List list, SubclassEntityContainer subclassEntityContainer) {
        for (Object e : list) {
            SubEntityElement subEntityElement = (SubEntityElement)e;
            SubclassEntitySourceImpl subclassEntitySourceImpl = new SubclassEntitySourceImpl(this.currentMappingDocument, subEntityElement);
            subclassEntityContainer.add(subclassEntitySourceImpl);
            String string = subclassEntitySourceImpl.getEntityName();
            this.subEntityContainerMap.put(string, subclassEntitySourceImpl);
        }
    }

    private static class ExtendsQueueEntry {
        private final SubclassEntitySource subClassEntitySource;
        private final String entityItExtends;

        private ExtendsQueueEntry(SubclassEntitySource subclassEntitySource, String string) {
            this.subClassEntitySource = subclassEntitySource;
            this.entityItExtends = string;
        }
    }
}

