/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.jaxb.Origin;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbFetchProfileElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbParamElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbQueryElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbSqlQueryElement;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.TypeDef;
import org.hibernate.metamodel.relational.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.relational.BasicAuxiliaryDatabaseObjectImpl;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.hbm.HbmBindingContext;
import org.hibernate.metamodel.source.hbm.MappingDocument;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMappingProcessor {
    private final MetadataImplementor metadata;
    private final MappingDocument mappingDocument;
    private ValueHolder<ClassLoaderService> classLoaderService = new ValueHolder<1>(new ValueHolder.DeferredInitializer<ClassLoaderService>(){

        @Override
        public ClassLoaderService initialize() {
            return HibernateMappingProcessor.this.metadata.getServiceRegistry().getService(ClassLoaderService.class);
        }
    });

    public HibernateMappingProcessor(MetadataImplementor metadataImplementor, MappingDocument mappingDocument) {
        this.metadata = metadataImplementor;
        this.mappingDocument = mappingDocument;
    }

    private JaxbHibernateMapping mappingRoot() {
        return this.mappingDocument.getMappingRoot();
    }

    private Origin origin() {
        return this.mappingDocument.getOrigin();
    }

    private HbmBindingContext bindingContext() {
        return this.mappingDocument.getMappingLocalBindingContext();
    }

    private <T> Class<T> classForName(String string) {
        return this.classLoaderService.getValue().classForName(this.bindingContext().qualifyClassName(string));
    }

    public void processIndependentMetadata() {
        this.processDatabaseObjectDefinitions();
        this.processTypeDefinitions();
    }

    private void processDatabaseObjectDefinitions() {
        if (this.mappingRoot().getDatabaseObject() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbDatabaseObject jaxbDatabaseObject : this.mappingRoot().getDatabaseObject()) {
            AuxiliaryDatabaseObject auxiliaryDatabaseObject;
            Object object;
            if (jaxbDatabaseObject.getDefinition() != null) {
                object = jaxbDatabaseObject.getDefinition().getClazz();
                try {
                    auxiliaryDatabaseObject = (AuxiliaryDatabaseObject)this.classForName((String)object).newInstance();
                }
                catch (ClassLoadingException classLoadingException) {
                    throw classLoadingException;
                }
                catch (Exception exception) {
                    throw new MappingException("could not instantiate custom database object class [" + (String)object + "]", this.origin());
                }
            } else {
                object = new HashSet();
                if (jaxbDatabaseObject.getDialectScope() != null) {
                    for (JaxbHibernateMapping.JaxbDatabaseObject.JaxbDialectScope jaxbDialectScope : jaxbDatabaseObject.getDialectScope()) {
                        object.add(jaxbDialectScope.getName());
                    }
                }
                auxiliaryDatabaseObject = new BasicAuxiliaryDatabaseObjectImpl(this.metadata.getDatabase().getDefaultSchema(), jaxbDatabaseObject.getCreate(), jaxbDatabaseObject.getDrop(), (Set<String>)object);
            }
            this.metadata.getDatabase().addAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
        }
    }

    private void processTypeDefinitions() {
        if (this.mappingRoot().getTypedef() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbTypedef jaxbTypedef : this.mappingRoot().getTypedef()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (JaxbParamElement jaxbParamElement : jaxbTypedef.getParam()) {
                hashMap.put(jaxbParamElement.getName(), jaxbParamElement.getValue());
            }
            this.metadata.addTypeDefinition(new TypeDef(jaxbTypedef.getName(), jaxbTypedef.getClazz(), hashMap));
        }
    }

    public void processTypeDependentMetadata() {
        this.processFilterDefinitions();
        this.processIdentifierGenerators();
    }

    private void processFilterDefinitions() {
        if (this.mappingRoot().getFilterDef() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbFilterDef jaxbFilterDef : this.mappingRoot().getFilterDef()) {
            String string = jaxbFilterDef.getName();
            HashMap<String, Type> hashMap = new HashMap<String, Type>();
            String string2 = null;
            for (Serializable serializable : jaxbFilterDef.getContent()) {
                if (serializable instanceof String) {
                    if (string2 != null) {
                        // empty if block
                    }
                    string2 = (String)((Object)serializable);
                    continue;
                }
                if (serializable instanceof JaxbHibernateMapping.JaxbFilterDef.JaxbFilterParam) {
                    JaxbHibernateMapping.JaxbFilterDef.JaxbFilterParam jaxbFilterParam = (JaxbHibernateMapping.JaxbFilterDef.JaxbFilterParam)JaxbHibernateMapping.JaxbFilterDef.JaxbFilterParam.class.cast(serializable);
                    hashMap.put(jaxbFilterParam.getName(), this.metadata.getTypeResolver().heuristicType(jaxbFilterParam.getType()));
                    continue;
                }
                throw new MappingException("Unrecognized nested filter content", this.origin());
            }
            if (string2 == null) {
                string2 = jaxbFilterDef.getCondition();
            }
            this.metadata.addFilterDefinition(new FilterDefinition(string, string2, hashMap));
        }
    }

    private void processIdentifierGenerators() {
        if (this.mappingRoot().getIdentifierGenerator() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbIdentifierGenerator jaxbIdentifierGenerator : this.mappingRoot().getIdentifierGenerator()) {
            this.metadata.registerIdentifierGenerator(jaxbIdentifierGenerator.getName(), jaxbIdentifierGenerator.getClazz());
        }
    }

    public void processMappingDependentMetadata() {
        this.processFetchProfiles();
        this.processImports();
        this.processResultSetMappings();
        this.processNamedQueries();
    }

    private void processFetchProfiles() {
        if (this.mappingRoot().getFetchProfile() == null) {
            return;
        }
        this.processFetchProfiles(this.mappingRoot().getFetchProfile(), null);
    }

    public void processFetchProfiles(List<JaxbFetchProfileElement> list, String string) {
        for (JaxbFetchProfileElement jaxbFetchProfileElement : list) {
            String string2 = jaxbFetchProfileElement.getName();
            HashSet<FetchProfile.Fetch> hashSet = new HashSet<FetchProfile.Fetch>();
            for (JaxbFetchProfileElement.JaxbFetch jaxbFetch : jaxbFetchProfileElement.getFetch()) {
                String string3;
                String string4 = string3 = jaxbFetch.getEntity() == null ? string : jaxbFetch.getEntity();
                if (string3 == null) {
                    throw new MappingException("could not determine entity for fetch-profile fetch [" + string2 + "]:[" + jaxbFetch.getAssociation() + "]", this.origin());
                }
                hashSet.add(new FetchProfile.Fetch(string3, jaxbFetch.getAssociation(), jaxbFetch.getStyle()));
            }
            this.metadata.addFetchProfile(new FetchProfile(string2, hashSet));
        }
    }

    private void processImports() {
        if (this.mappingRoot().getImport() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbImport jaxbImport : this.mappingRoot().getImport()) {
            String string = this.mappingDocument.getMappingLocalBindingContext().qualifyClassName(jaxbImport.getClazz());
            String string2 = jaxbImport.getRename();
            string2 = string2 == null ? StringHelper.unqualify(string) : string2;
            this.metadata.addImport(string, string2);
        }
    }

    private void processResultSetMappings() {
        if (this.mappingRoot().getResultset() == null) {
            return;
        }
    }

    private void processNamedQueries() {
        if (this.mappingRoot().getQueryOrSqlQuery() == null) {
            return;
        }
        for (Object object : this.mappingRoot().getQueryOrSqlQuery()) {
            if (JaxbQueryElement.class.isInstance(object) || JaxbSqlQueryElement.class.isInstance(object)) continue;
            throw new MappingException("unknown type of query: " + object.getClass().getName(), this.origin());
        }
    }
}

