/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.jaxb.mapping.hbm.CustomSqlElement;
import org.hibernate.internal.jaxb.mapping.hbm.EntityElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbColumnElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbJoinedSubclassElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbMetaElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbParamElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbSubclassElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbUnionSubclassElement;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.MetaAttribute;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.MetaAttributeContext;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.hbm.ColumnAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.ColumnSourceImpl;
import org.hibernate.metamodel.source.hbm.FormulaImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper {
    public static final ExplicitHibernateTypeSource TO_ONE_ATTRIBUTE_TYPE_SOURCE = new ExplicitHibernateTypeSource(){

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Map<String, String> getParameters() {
            return null;
        }
    };

    public static InheritanceType interpretInheritanceType(EntityElement entityElement) {
        if (JaxbSubclassElement.class.isInstance(entityElement)) {
            return InheritanceType.SINGLE_TABLE;
        }
        if (JaxbJoinedSubclassElement.class.isInstance(entityElement)) {
            return InheritanceType.JOINED;
        }
        if (JaxbUnionSubclassElement.class.isInstance(entityElement)) {
            return InheritanceType.TABLE_PER_CLASS;
        }
        return InheritanceType.NO_INHERITANCE;
    }

    public static CustomSQL buildCustomSql(CustomSqlElement customSqlElement) {
        if (customSqlElement == null) {
            return null;
        }
        ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = customSqlElement.getCheck() == null ? (customSqlElement.isCallable() ? ExecuteUpdateResultCheckStyle.NONE : ExecuteUpdateResultCheckStyle.COUNT) : ExecuteUpdateResultCheckStyle.fromExternalName(customSqlElement.getCheck().value());
        return new CustomSQL(customSqlElement.getValue(), customSqlElement.isCallable(), executeUpdateResultCheckStyle);
    }

    public static String determineEntityName(EntityElement entityElement, String string) {
        return entityElement.getEntityName() != null ? entityElement.getEntityName() : Helper.qualifyIfNeeded(entityElement.getName(), string);
    }

    public static String qualifyIfNeeded(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(46) < 0 && string2 != null) {
            return string2 + '.' + string;
        }
        return string;
    }

    public static String getPropertyAccessorName(String string, boolean bl, String string2) {
        return Helper.getStringValue(string, bl ? "embedded" : string2);
    }

    public static MetaAttributeContext extractMetaAttributeContext(List<JaxbMetaElement> list, boolean bl, MetaAttributeContext metaAttributeContext) {
        MetaAttributeContext metaAttributeContext2 = new MetaAttributeContext(metaAttributeContext);
        for (JaxbMetaElement jaxbMetaElement : list) {
            if (bl & !jaxbMetaElement.isInherit()) continue;
            String string = jaxbMetaElement.getAttribute();
            MetaAttribute metaAttribute = metaAttributeContext.getMetaAttribute(string);
            MetaAttribute metaAttribute2 = metaAttributeContext2.getLocalMetaAttribute(string);
            if (metaAttribute2 == null || metaAttribute2 == metaAttribute) {
                metaAttribute2 = new MetaAttribute(string);
                metaAttributeContext2.add(metaAttribute2);
            }
            metaAttribute2.addValue(jaxbMetaElement.getValue());
        }
        return metaAttributeContext2;
    }

    public static String getStringValue(String string, String string2) {
        return string == null ? string2 : string;
    }

    public static int getIntValue(String string, int n) {
        return string == null ? n : Integer.parseInt(string);
    }

    public static long getLongValue(String string, long l) {
        return string == null ? l : Long.parseLong(string);
    }

    public static boolean getBooleanValue(Boolean bl, boolean bl2) {
        return bl == null ? bl2 : bl;
    }

    public static Iterable<CascadeStyle> interpretCascadeStyles(String string, LocalBindingContext localBindingContext) {
        HashSet<CascadeStyle> hashSet = new HashSet<CascadeStyle>();
        if (StringHelper.isEmpty(string)) {
            string = localBindingContext.getMappingDefaults().getCascadeStyle();
        }
        for (String string2 : StringHelper.split(",", string)) {
            hashSet.add(CascadeStyle.getCascadeStyle(string2));
        }
        return hashSet;
    }

    public static Map<String, String> extractParameters(List<JaxbParamElement> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (JaxbParamElement jaxbParamElement : list) {
            hashMap.put(jaxbParamElement.getName(), jaxbParamElement.getValue());
        }
        return hashMap;
    }

    public static Iterable<MetaAttributeSource> buildMetaAttributeSources(List<JaxbMetaElement> list) {
        ArrayList<MetaAttributeSource> arrayList = new ArrayList<MetaAttributeSource>();
        if (list != null && !list.isEmpty()) {
            for (final JaxbMetaElement jaxbMetaElement : list) {
                arrayList.add(new MetaAttributeSource(){

                    public String getName() {
                        return jaxbMetaElement.getAttribute();
                    }

                    public String getValue() {
                        return jaxbMetaElement.getValue();
                    }

                    public boolean isInheritable() {
                        return jaxbMetaElement.isInherit();
                    }
                });
            }
        }
        return arrayList;
    }

    public static Schema.Name determineDatabaseSchemaName(String string, String string2, LocalBindingContext localBindingContext) {
        return new Schema.Name(Helper.resolveIdentifier(string, localBindingContext.getMappingDefaults().getSchemaName(), localBindingContext.isGloballyQuotedIdentifiers()), Helper.resolveIdentifier(string2, localBindingContext.getMappingDefaults().getCatalogName(), localBindingContext.isGloballyQuotedIdentifiers()));
    }

    public static Identifier resolveIdentifier(String string, String string2, boolean bl) {
        String string3;
        String string4 = string3 = StringHelper.isNotEmpty(string) ? string : string2;
        if (bl) {
            string3 = StringHelper.quote(string3);
        }
        return Identifier.toIdentifier(string3);
    }

    public static List<RelationalValueSource> buildValueSources(ValueSourcesAdapter valueSourcesAdapter, LocalBindingContext localBindingContext) {
        ArrayList<RelationalValueSource> arrayList = new ArrayList<RelationalValueSource>();
        if (StringHelper.isNotEmpty(valueSourcesAdapter.getColumnAttribute())) {
            if (valueSourcesAdapter.getColumnOrFormulaElements() != null && !valueSourcesAdapter.getColumnOrFormulaElements().isEmpty()) {
                throw new org.hibernate.metamodel.source.MappingException("column/formula attribute may not be used together with <column>/<formula> subelement", localBindingContext.getOrigin());
            }
            if (StringHelper.isNotEmpty(valueSourcesAdapter.getFormulaAttribute())) {
                throw new org.hibernate.metamodel.source.MappingException("column and formula attributes may not be used together", localBindingContext.getOrigin());
            }
            arrayList.add(new ColumnAttributeSourceImpl(valueSourcesAdapter.getContainingTableName(), valueSourcesAdapter.getColumnAttribute(), valueSourcesAdapter.isIncludedInInsertByDefault(), valueSourcesAdapter.isIncludedInUpdateByDefault(), valueSourcesAdapter.isForceNotNull()));
        } else if (StringHelper.isNotEmpty(valueSourcesAdapter.getFormulaAttribute())) {
            if (valueSourcesAdapter.getColumnOrFormulaElements() != null && !valueSourcesAdapter.getColumnOrFormulaElements().isEmpty()) {
                throw new org.hibernate.metamodel.source.MappingException("column/formula attribute may not be used together with <column>/<formula> subelement", localBindingContext.getOrigin());
            }
            arrayList.add(new FormulaImpl(valueSourcesAdapter.getContainingTableName(), valueSourcesAdapter.getFormulaAttribute()));
        } else if (valueSourcesAdapter.getColumnOrFormulaElements() != null && !valueSourcesAdapter.getColumnOrFormulaElements().isEmpty()) {
            for (Object e : valueSourcesAdapter.getColumnOrFormulaElements()) {
                if (JaxbColumnElement.class.isInstance(e)) {
                    arrayList.add(new ColumnSourceImpl(valueSourcesAdapter.getContainingTableName(), (JaxbColumnElement)e, valueSourcesAdapter.isIncludedInInsertByDefault(), valueSourcesAdapter.isIncludedInUpdateByDefault(), valueSourcesAdapter.isForceNotNull()));
                    continue;
                }
                arrayList.add(new FormulaImpl(valueSourcesAdapter.getContainingTableName(), (String)e));
            }
        }
        return arrayList;
    }

    public static Class classForName(String string, ServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        try {
            return classLoaderService.classForName(string);
        }
        catch (ClassLoadingException classLoadingException) {
            throw new MappingException("Could not find class: " + string);
        }
    }

    public static class ValueSourcesAdapter {
        public String getContainingTableName() {
            return null;
        }

        public boolean isIncludedInInsertByDefault() {
            return false;
        }

        public boolean isIncludedInUpdateByDefault() {
            return false;
        }

        public String getColumnAttribute() {
            return null;
        }

        public String getFormulaAttribute() {
            return null;
        }

        public List getColumnOrFormulaElements() {
            return null;
        }

        public boolean isForceNotNull() {
            return false;
        }
    }
}

