/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.jaxb.JaxbRoot;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.MetadataSourceProcessor;
import org.hibernate.metamodel.source.binder.Binder;
import org.hibernate.metamodel.source.hbm.EntityHierarchyImpl;
import org.hibernate.metamodel.source.hbm.HibernateMappingProcessor;
import org.hibernate.metamodel.source.hbm.HierarchyBuilder;
import org.hibernate.metamodel.source.hbm.MappingDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbmMetadataSourceProcessorImpl
implements MetadataSourceProcessor {
    private final MetadataImplementor metadata;
    private List<HibernateMappingProcessor> processors = new ArrayList<HibernateMappingProcessor>();
    private List<EntityHierarchyImpl> entityHierarchies;

    public HbmMetadataSourceProcessorImpl(MetadataImplementor metadataImplementor) {
        this.metadata = metadataImplementor;
    }

    @Override
    public void prepare(MetadataSources metadataSources) {
        HierarchyBuilder hierarchyBuilder = new HierarchyBuilder();
        for (JaxbRoot jaxbRoot : metadataSources.getJaxbRootList()) {
            if (!JaxbHibernateMapping.class.isInstance(jaxbRoot.getRoot())) continue;
            MappingDocument mappingDocument = new MappingDocument(jaxbRoot, this.metadata);
            this.processors.add(new HibernateMappingProcessor(this.metadata, mappingDocument));
            hierarchyBuilder.processMappingDocument(mappingDocument);
        }
        this.entityHierarchies = hierarchyBuilder.groupEntityHierarchies();
    }

    @Override
    public void processIndependentMetadata(MetadataSources metadataSources) {
        for (HibernateMappingProcessor hibernateMappingProcessor : this.processors) {
            hibernateMappingProcessor.processIndependentMetadata();
        }
    }

    @Override
    public void processTypeDependentMetadata(MetadataSources metadataSources) {
        for (HibernateMappingProcessor hibernateMappingProcessor : this.processors) {
            hibernateMappingProcessor.processTypeDependentMetadata();
        }
    }

    @Override
    public void processMappingMetadata(MetadataSources metadataSources, List<String> list) {
        Binder binder = new Binder(this.metadata, list);
        for (EntityHierarchyImpl entityHierarchyImpl : this.entityHierarchies) {
            binder.processEntityHierarchy(entityHierarchyImpl);
        }
    }

    @Override
    public void processMappingDependentMetadata(MetadataSources metadataSources) {
        for (HibernateMappingProcessor hibernateMappingProcessor : this.processors) {
            hibernateMappingProcessor.processMappingDependentMetadata();
        }
    }
}

