/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.binder.EntityHierarchy;
import org.hibernate.metamodel.source.binder.RootEntitySource;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.RootEntitySourceImpl;
import org.hibernate.metamodel.source.hbm.SubclassEntitySourceImpl;

public class EntityHierarchyImpl
implements EntityHierarchy {
    private final RootEntitySourceImpl rootEntitySource;
    private InheritanceType hierarchyInheritanceType = InheritanceType.NO_INHERITANCE;

    public EntityHierarchyImpl(RootEntitySourceImpl rootEntitySourceImpl) {
        this.rootEntitySource = rootEntitySourceImpl;
        this.rootEntitySource.injectHierarchy(this);
    }

    public InheritanceType getHierarchyInheritanceType() {
        return this.hierarchyInheritanceType;
    }

    public RootEntitySource getRootEntitySource() {
        return this.rootEntitySource;
    }

    public void processSubclass(SubclassEntitySourceImpl subclassEntitySourceImpl) {
        InheritanceType inheritanceType = Helper.interpretInheritanceType(subclassEntitySourceImpl.entityElement());
        if (this.hierarchyInheritanceType == InheritanceType.NO_INHERITANCE) {
            this.hierarchyInheritanceType = inheritanceType;
        } else if (this.hierarchyInheritanceType != inheritanceType) {
            throw new MappingException("Mixed inheritance strategies not supported", subclassEntitySourceImpl.getOrigin());
        }
    }
}

