/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.EntityMode;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbAnyElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbComponentElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbManyToManyElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbManyToOneElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbOneToManyElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbOneToOneElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbPropertyElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbTuplizerElement;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.binder.AttributeSource;
import org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.hibernate.metamodel.source.binder.ComponentAttributeSource;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.ManyToOneAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.PropertyAttributeSourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAttributeSourceImpl
implements ComponentAttributeSource {
    private final JaxbComponentElement componentElement;
    private final AttributeSourceContainer parentContainer;
    private final ValueHolder<Class<?>> componentClassReference;
    private final String path;

    public ComponentAttributeSourceImpl(JaxbComponentElement jaxbComponentElement, AttributeSourceContainer attributeSourceContainer, LocalBindingContext localBindingContext) {
        this.componentElement = jaxbComponentElement;
        this.parentContainer = attributeSourceContainer;
        this.componentClassReference = localBindingContext.makeClassReference(localBindingContext.qualifyClassName(jaxbComponentElement.getClazz()));
        this.path = attributeSourceContainer.getPath() + '.' + jaxbComponentElement.getName();
    }

    @Override
    public String getClassName() {
        return this.componentElement.getClazz();
    }

    @Override
    public ValueHolder<Class<?>> getClassReference() {
        return this.componentClassReference;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public LocalBindingContext getLocalBindingContext() {
        return this.parentContainer.getLocalBindingContext();
    }

    @Override
    public String getParentReferenceAttributeName() {
        return this.componentElement.getParent() == null ? null : this.componentElement.getParent().getName();
    }

    @Override
    public String getExplicitTuplizerClassName() {
        if (this.componentElement.getTuplizer() == null) {
            return null;
        }
        EntityMode entityMode = StringHelper.isEmpty(this.componentElement.getClazz()) ? EntityMode.MAP : EntityMode.POJO;
        for (JaxbTuplizerElement jaxbTuplizerElement : this.componentElement.getTuplizer()) {
            if (entityMode != EntityMode.parse(jaxbTuplizerElement.getEntityMode())) continue;
            return jaxbTuplizerElement.getClazz();
        }
        return null;
    }

    @Override
    public Iterable<AttributeSource> attributeSources() {
        ArrayList<AttributeSource> arrayList = new ArrayList<AttributeSource>();
        for (Object object : this.componentElement.getPropertyOrManyToOneOrOneToOne()) {
            if (JaxbPropertyElement.class.isInstance(object)) {
                arrayList.add(new PropertyAttributeSourceImpl((JaxbPropertyElement)JaxbPropertyElement.class.cast(object), this.getLocalBindingContext()));
                continue;
            }
            if (JaxbComponentElement.class.isInstance(object)) {
                arrayList.add(new ComponentAttributeSourceImpl((JaxbComponentElement)object, this, this.getLocalBindingContext()));
                continue;
            }
            if (JaxbManyToOneElement.class.isInstance(object)) {
                arrayList.add(new ManyToOneAttributeSourceImpl((JaxbManyToOneElement)JaxbManyToOneElement.class.cast(object), this.getLocalBindingContext()));
                continue;
            }
            if (!JaxbOneToOneElement.class.isInstance(object) && !JaxbAnyElement.class.isInstance(object) && !JaxbOneToManyElement.class.isInstance(object) && !JaxbManyToManyElement.class.isInstance(object)) continue;
        }
        return arrayList;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.COMPONENT;
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return null;
    }

    @Override
    public String getName() {
        return this.componentElement.getName();
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.componentElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return this.componentElement.isInsert();
    }

    @Override
    public boolean isUpdatable() {
        return this.componentElement.isUpdate();
    }

    @Override
    public PropertyGeneration getGeneration() {
        return null;
    }

    @Override
    public boolean isLazy() {
        return this.componentElement.isLazy();
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.componentElement.isOptimisticLock();
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.componentElement.getMeta());
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return this.isInsertable();
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return this.isUpdatable();
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return true;
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return null;
    }
}

