/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.Collections;
import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbCacheElement;
import org.hibernate.internal.jaxb.mapping.hbm.PluralAttributeElement;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.PluralAttributeElementSource;
import org.hibernate.metamodel.source.binder.PluralAttributeKeySource;
import org.hibernate.metamodel.source.binder.PluralAttributeSource;
import org.hibernate.metamodel.source.hbm.BasicPluralAttributeElementSourceImpl;
import org.hibernate.metamodel.source.hbm.CompositePluralAttributeElementSourceImpl;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.ManyToManyPluralAttributeElementSourceImpl;
import org.hibernate.metamodel.source.hbm.OneToManyPluralAttributeElementSourceImpl;
import org.hibernate.metamodel.source.hbm.PluralAttributeKeySourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluralAttributeSourceImpl
implements PluralAttributeSource {
    private final PluralAttributeElement pluralAttributeElement;
    private final AttributeSourceContainer container;
    private final ExplicitHibernateTypeSource typeInformation;
    private final PluralAttributeKeySource keySource;
    private final PluralAttributeElementSource elementSource;

    protected AbstractPluralAttributeSourceImpl(final PluralAttributeElement pluralAttributeElement, AttributeSourceContainer attributeSourceContainer) {
        this.pluralAttributeElement = pluralAttributeElement;
        this.container = attributeSourceContainer;
        this.keySource = new PluralAttributeKeySourceImpl(pluralAttributeElement.getKey(), attributeSourceContainer);
        this.elementSource = this.interpretElementType();
        this.typeInformation = new ExplicitHibernateTypeSource(){

            @Override
            public String getName() {
                return pluralAttributeElement.getCollectionType();
            }

            @Override
            public Map<String, String> getParameters() {
                return Collections.emptyMap();
            }
        };
    }

    private PluralAttributeElementSource interpretElementType() {
        if (this.pluralAttributeElement.getElement() != null) {
            return new BasicPluralAttributeElementSourceImpl(this.pluralAttributeElement.getElement(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getCompositeElement() != null) {
            return new CompositePluralAttributeElementSourceImpl(this.pluralAttributeElement.getCompositeElement(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getOneToMany() != null) {
            return new OneToManyPluralAttributeElementSourceImpl(this.pluralAttributeElement.getOneToMany(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getManyToMany() != null) {
            return new ManyToManyPluralAttributeElementSourceImpl(this.pluralAttributeElement.getManyToMany(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getManyToAny() != null) {
            throw new NotYetImplementedException("Support for many-to-any not yet implemented");
        }
        throw new MappingException("Unexpected collection element type : " + this.pluralAttributeElement.getName(), this.bindingContext().getOrigin());
    }

    public PluralAttributeElement getPluralAttributeElement() {
        return this.pluralAttributeElement;
    }

    protected AttributeSourceContainer container() {
        return this.container;
    }

    protected LocalBindingContext bindingContext() {
        return this.container().getLocalBindingContext();
    }

    @Override
    public PluralAttributeKeySource getKeySource() {
        return this.keySource;
    }

    @Override
    public PluralAttributeElementSource getElementSource() {
        return this.elementSource;
    }

    @Override
    public String getExplicitSchemaName() {
        return this.pluralAttributeElement.getSchema();
    }

    @Override
    public String getExplicitCatalogName() {
        return this.pluralAttributeElement.getCatalog();
    }

    @Override
    public String getExplicitCollectionTableName() {
        return this.pluralAttributeElement.getTable();
    }

    @Override
    public String getCollectionTableComment() {
        return this.pluralAttributeElement.getComment();
    }

    @Override
    public String getCollectionTableCheck() {
        return this.pluralAttributeElement.getCheck();
    }

    @Override
    public Caching getCaching() {
        JaxbCacheElement jaxbCacheElement = this.pluralAttributeElement.getCache();
        if (jaxbCacheElement == null) {
            return null;
        }
        String string = jaxbCacheElement.getRegion() != null ? jaxbCacheElement.getRegion() : StringHelper.qualify(this.container().getPath(), this.getName());
        AccessType accessType = Enum.valueOf(AccessType.class, jaxbCacheElement.getUsage());
        boolean bl = !"non-lazy".equals(jaxbCacheElement.getInclude());
        return new Caching(string, accessType, bl);
    }

    @Override
    public String getWhere() {
        return this.pluralAttributeElement.getWhere();
    }

    @Override
    public String getName() {
        return this.pluralAttributeElement.getName();
    }

    @Override
    public boolean isSingular() {
        return false;
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.pluralAttributeElement.getAccess();
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.pluralAttributeElement.isOptimisticLock();
    }

    @Override
    public boolean isInverse() {
        return this.pluralAttributeElement.isInverse();
    }

    @Override
    public String getCustomPersisterClassName() {
        return this.pluralAttributeElement.getPersister();
    }

    @Override
    public String getCustomLoaderName() {
        return this.pluralAttributeElement.getLoader() == null ? null : this.pluralAttributeElement.getLoader().getQueryRef();
    }

    @Override
    public CustomSQL getCustomSqlInsert() {
        return Helper.buildCustomSql(this.pluralAttributeElement.getSqlInsert());
    }

    @Override
    public CustomSQL getCustomSqlUpdate() {
        return Helper.buildCustomSql(this.pluralAttributeElement.getSqlUpdate());
    }

    @Override
    public CustomSQL getCustomSqlDelete() {
        return Helper.buildCustomSql(this.pluralAttributeElement.getSqlDelete());
    }

    @Override
    public CustomSQL getCustomSqlDeleteAll() {
        return Helper.buildCustomSql(this.pluralAttributeElement.getSqlDeleteAll());
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.pluralAttributeElement.getMeta());
    }

    @Override
    public Iterable<CascadeStyle> getCascadeStyles() {
        return Helper.interpretCascadeStyles(this.pluralAttributeElement.getCascade(), this.bindingContext());
    }

    @Override
    public FetchTiming getFetchTiming() {
        String string;
        String string2 = this.pluralAttributeElement.getFetch() != null ? this.pluralAttributeElement.getFetch().value() : null;
        String string3 = this.pluralAttributeElement.getLazy() != null ? this.pluralAttributeElement.getLazy().value() : null;
        String string4 = string = this.pluralAttributeElement.getOuterJoin() != null ? this.pluralAttributeElement.getOuterJoin().value() : null;
        if (string3 == null) {
            if ("join".equals(string2) || "true".equals(string)) {
                return FetchTiming.IMMEDIATE;
            }
            if ("false".equals(string)) {
                return FetchTiming.DELAYED;
            }
            return this.bindingContext().getMappingDefaults().areAssociationsLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
        }
        if ("extra".equals(string3)) {
            return FetchTiming.EXTRA_LAZY;
        }
        if ("true".equals(string3)) {
            return FetchTiming.DELAYED;
        }
        if ("false".equals(string3)) {
            return FetchTiming.IMMEDIATE;
        }
        throw new MappingException(String.format("Unexpected lazy selection [%s] on '%s'", string3, this.pluralAttributeElement.getName()), this.bindingContext().getOrigin());
    }

    @Override
    public FetchStyle getFetchStyle() {
        String string = this.pluralAttributeElement.getFetch() != null ? this.pluralAttributeElement.getFetch().value() : null;
        String string2 = this.pluralAttributeElement.getOuterJoin() != null ? this.pluralAttributeElement.getOuterJoin().value() : null;
        int n = Helper.getIntValue(this.pluralAttributeElement.getBatchSize(), -1);
        if (string == null) {
            if (string2 == null) {
                return n > 1 ? FetchStyle.BATCH : FetchStyle.SELECT;
            }
            if ("auto".equals(string2)) {
                return this.bindingContext().getMappingDefaults().areAssociationsLazy() ? FetchStyle.SELECT : FetchStyle.JOIN;
            }
            return "true".equals(string2) ? FetchStyle.JOIN : FetchStyle.SELECT;
        }
        if ("subselect".equals(string)) {
            return FetchStyle.SUBSELECT;
        }
        return "join".equals(string) ? FetchStyle.JOIN : FetchStyle.SELECT;
    }

    @Override
    public FetchMode getFetchMode() {
        return this.pluralAttributeElement.getFetch() == null ? FetchMode.DEFAULT : FetchMode.valueOf(this.pluralAttributeElement.getFetch().value());
    }
}

