/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.binder;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.beans.BeanInfoHelper;
import org.hibernate.metamodel.binding.AbstractPluralAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.BasicCollectionElement;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.CollectionLaziness;
import org.hibernate.metamodel.binding.ComponentAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityDiscriminator;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.MetaAttribute;
import org.hibernate.metamodel.binding.SimpleValueBinding;
import org.hibernate.metamodel.binding.SingularAttributeBinding;
import org.hibernate.metamodel.binding.TypeDef;
import org.hibernate.metamodel.domain.Component;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Tuple;
import org.hibernate.metamodel.relational.UniqueKey;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.MetaAttributeContext;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.binder.AttributeSource;
import org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.hibernate.metamodel.source.binder.BasicPluralAttributeElementSource;
import org.hibernate.metamodel.source.binder.ColumnSource;
import org.hibernate.metamodel.source.binder.ComponentAttributeSource;
import org.hibernate.metamodel.source.binder.ConstraintSource;
import org.hibernate.metamodel.source.binder.DerivedValueSource;
import org.hibernate.metamodel.source.binder.DiscriminatorSource;
import org.hibernate.metamodel.source.binder.EntityHierarchy;
import org.hibernate.metamodel.source.binder.EntitySource;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.Orderable;
import org.hibernate.metamodel.source.binder.PluralAttributeElementNature;
import org.hibernate.metamodel.source.binder.PluralAttributeElementSource;
import org.hibernate.metamodel.source.binder.PluralAttributeNature;
import org.hibernate.metamodel.source.binder.PluralAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.RelationalValueSourceContainer;
import org.hibernate.metamodel.source.binder.RootEntitySource;
import org.hibernate.metamodel.source.binder.SimpleIdentifierSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;
import org.hibernate.metamodel.source.binder.Sortable;
import org.hibernate.metamodel.source.binder.SubclassEntityContainer;
import org.hibernate.metamodel.source.binder.SubclassEntitySource;
import org.hibernate.metamodel.source.binder.TableSource;
import org.hibernate.metamodel.source.binder.ToOneAttributeSource;
import org.hibernate.metamodel.source.binder.UniqueConstraintSource;
import org.hibernate.metamodel.source.hbm.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Binder {
    private final MetadataImplementor metadata;
    private final List<String> processedEntityNames;
    private InheritanceType currentInheritanceType;
    private EntityMode currentHierarchyEntityMode;
    private LocalBindingContext currentBindingContext;

    public Binder(MetadataImplementor metadataImplementor, List<String> list) {
        this.metadata = metadataImplementor;
        this.processedEntityNames = list;
    }

    public void processEntityHierarchy(EntityHierarchy entityHierarchy) {
        this.currentInheritanceType = entityHierarchy.getHierarchyInheritanceType();
        EntityBinding entityBinding = this.createEntityBinding(entityHierarchy.getRootEntitySource(), null);
        if (this.currentInheritanceType != InheritanceType.NO_INHERITANCE) {
            this.processHierarchySubEntities(entityHierarchy.getRootEntitySource(), entityBinding);
        }
        this.currentHierarchyEntityMode = null;
    }

    private void processHierarchySubEntities(SubclassEntityContainer subclassEntityContainer, EntityBinding entityBinding) {
        for (SubclassEntitySource subclassEntitySource : subclassEntityContainer.subclassEntitySources()) {
            EntityBinding entityBinding2 = this.createEntityBinding(subclassEntitySource, entityBinding);
            this.processHierarchySubEntities(subclassEntitySource, entityBinding2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityBinding createEntityBinding(EntitySource entitySource, EntityBinding entityBinding) {
        if (this.processedEntityNames.contains(entitySource.getEntityName())) {
            return this.metadata.getEntityBinding(entitySource.getEntityName());
        }
        this.currentBindingContext = entitySource.getLocalBindingContext();
        try {
            EntityBinding entityBinding2 = this.doCreateEntityBinding(entitySource, entityBinding);
            this.metadata.addEntity(entityBinding2);
            this.processedEntityNames.add(entityBinding2.getEntity().getName());
            this.processFetchProfiles(entitySource, entityBinding2);
            EntityBinding entityBinding3 = entityBinding2;
            return entityBinding3;
        }
        finally {
            this.currentBindingContext = null;
        }
    }

    private EntityBinding doCreateEntityBinding(EntitySource entitySource, EntityBinding entityBinding) {
        EntityBinding entityBinding2 = this.createBasicEntityBinding(entitySource, entityBinding);
        this.bindSecondaryTables(entitySource, entityBinding2);
        this.bindAttributes(entitySource, entityBinding2);
        this.bindTableUniqueConstraints(entitySource, entityBinding2);
        return entityBinding2;
    }

    private EntityBinding createBasicEntityBinding(EntitySource entitySource, EntityBinding entityBinding) {
        if (entityBinding == null) {
            return this.makeRootEntityBinding((RootEntitySource)entitySource);
        }
        switch (this.currentInheritanceType) {
            case SINGLE_TABLE: {
                return this.makeDiscriminatedSubclassBinding((SubclassEntitySource)entitySource, entityBinding);
            }
            case JOINED: {
                return this.makeJoinedSubclassBinding((SubclassEntitySource)entitySource, entityBinding);
            }
            case TABLE_PER_CLASS: {
                return this.makeUnionedSubclassBinding((SubclassEntitySource)entitySource, entityBinding);
            }
        }
        throw new AssertionFailure("Internal condition failure");
    }

    private EntityBinding makeRootEntityBinding(RootEntitySource rootEntitySource) {
        this.currentHierarchyEntityMode = rootEntitySource.getEntityMode();
        EntityBinding entityBinding = this.buildBasicEntityBinding(rootEntitySource, null);
        this.bindPrimaryTable(rootEntitySource, entityBinding);
        this.bindIdentifier(rootEntitySource, entityBinding);
        this.bindVersion(entityBinding, rootEntitySource);
        this.bindDiscriminator(rootEntitySource, entityBinding);
        entityBinding.getHierarchyDetails().setCaching(rootEntitySource.getCaching());
        entityBinding.getHierarchyDetails().setExplicitPolymorphism(rootEntitySource.isExplicitPolymorphism());
        entityBinding.getHierarchyDetails().setOptimisticLockStyle(rootEntitySource.getOptimisticLockStyle());
        entityBinding.setMutable(rootEntitySource.isMutable());
        entityBinding.setWhereFilter(rootEntitySource.getWhere());
        entityBinding.setRowId(rootEntitySource.getRowId());
        return entityBinding;
    }

    private EntityBinding buildBasicEntityBinding(EntitySource entitySource, EntityBinding entityBinding) {
        String string;
        String string2;
        EntityBinding entityBinding2 = entityBinding == null ? new EntityBinding(this.currentInheritanceType, this.currentHierarchyEntityMode) : new EntityBinding(entityBinding);
        String string3 = entitySource.getEntityName();
        String string4 = this.currentHierarchyEntityMode == EntityMode.POJO ? entitySource.getClassName() : null;
        Entity entity = new Entity(string3, string4, this.currentBindingContext.makeClassReference(string4), entityBinding == null ? null : entityBinding.getEntity());
        entityBinding2.setEntity(entity);
        entityBinding2.setJpaEntityName(entitySource.getJpaEntityName());
        if (this.currentHierarchyEntityMode == EntityMode.POJO) {
            string2 = entitySource.getProxy();
            if (string2 != null) {
                entityBinding2.setProxyInterfaceType(this.currentBindingContext.makeClassReference(this.currentBindingContext.qualifyClassName(string2)));
                entityBinding2.setLazy(true);
            } else if (entitySource.isLazy()) {
                entityBinding2.setProxyInterfaceType(entityBinding2.getEntity().getClassReferenceUnresolved());
                entityBinding2.setLazy(true);
            }
        } else {
            entityBinding2.setProxyInterfaceType(null);
            entityBinding2.setLazy(entitySource.isLazy());
        }
        string2 = entitySource.getCustomTuplizerClassName();
        if (string2 != null) {
            entityBinding2.setCustomEntityTuplizerClass(this.currentBindingContext.locateClassByName(string2));
        }
        if ((string = entitySource.getCustomPersisterClassName()) != null) {
            entityBinding2.setCustomEntityPersisterClass(this.currentBindingContext.locateClassByName(string));
        }
        entityBinding2.setMetaAttributeContext(this.buildMetaAttributeContext(entitySource));
        entityBinding2.setDynamicUpdate(entitySource.isDynamicUpdate());
        entityBinding2.setDynamicInsert(entitySource.isDynamicInsert());
        entityBinding2.setBatchSize(entitySource.getBatchSize());
        entityBinding2.setSelectBeforeUpdate(entitySource.isSelectBeforeUpdate());
        entityBinding2.setAbstract(entitySource.isAbstract());
        entityBinding2.setCustomLoaderName(entitySource.getCustomLoaderName());
        entityBinding2.setCustomInsert(entitySource.getCustomSqlInsert());
        entityBinding2.setCustomUpdate(entitySource.getCustomSqlUpdate());
        entityBinding2.setCustomDelete(entitySource.getCustomSqlDelete());
        if (entitySource.getSynchronizedTableNames() != null) {
            entityBinding2.addSynchronizedTableNames(entitySource.getSynchronizedTableNames());
        }
        entityBinding2.setJpaCallbackClasses(entitySource.getJpaCallbackClasses());
        return entityBinding2;
    }

    private EntityBinding makeDiscriminatedSubclassBinding(SubclassEntitySource subclassEntitySource, EntityBinding entityBinding) {
        EntityBinding entityBinding2 = this.buildBasicEntityBinding(subclassEntitySource, entityBinding);
        entityBinding2.setPrimaryTable(entityBinding.getPrimaryTable());
        entityBinding2.setPrimaryTableName(entityBinding.getPrimaryTableName());
        this.bindDiscriminatorValue(subclassEntitySource, entityBinding2);
        return entityBinding2;
    }

    private EntityBinding makeJoinedSubclassBinding(SubclassEntitySource subclassEntitySource, EntityBinding entityBinding) {
        EntityBinding entityBinding2 = this.buildBasicEntityBinding(subclassEntitySource, entityBinding);
        this.bindPrimaryTable(subclassEntitySource, entityBinding2);
        return entityBinding2;
    }

    private EntityBinding makeUnionedSubclassBinding(SubclassEntitySource subclassEntitySource, EntityBinding entityBinding) {
        EntityBinding entityBinding2 = this.buildBasicEntityBinding(subclassEntitySource, entityBinding);
        this.bindPrimaryTable(subclassEntitySource, entityBinding2);
        return entityBinding2;
    }

    private void bindIdentifier(RootEntitySource rootEntitySource, EntityBinding entityBinding) {
        if (rootEntitySource.getIdentifierSource() == null) {
            throw new AssertionFailure("Expecting identifier information on root entity descriptor");
        }
        switch (rootEntitySource.getIdentifierSource().getNature()) {
            case SIMPLE: {
                this.bindSimpleIdentifier((SimpleIdentifierSource)rootEntitySource.getIdentifierSource(), entityBinding);
                break;
            }
            case AGGREGATED_COMPOSITE: {
                break;
            }
        }
    }

    private void bindSimpleIdentifier(SimpleIdentifierSource simpleIdentifierSource, EntityBinding entityBinding) {
        Object object;
        BasicAttributeBinding basicAttributeBinding = this.doBasicSingularAttributeBindingCreation(simpleIdentifierSource.getIdentifierAttributeSource(), entityBinding);
        entityBinding.getHierarchyDetails().getEntityIdentifier().setValueBinding(basicAttributeBinding);
        IdGenerator idGenerator = simpleIdentifierSource.getIdentifierGeneratorDescriptor();
        if (idGenerator == null) {
            object = new HashMap<String, String>();
            object.put("entity_name", entityBinding.getEntity().getName());
            idGenerator = new IdGenerator("default_assign_identity_generator", "assigned", (Map<String, String>)object);
        }
        entityBinding.getHierarchyDetails().getEntityIdentifier().setIdGenerator(idGenerator);
        object = basicAttributeBinding.getValue();
        if (SimpleValue.class.isInstance(object)) {
            if (!Column.class.isInstance(object)) {
                throw new AssertionFailure("Simple-id was not a column.");
            }
            entityBinding.getPrimaryTable().getPrimaryKey().addColumn((Column)Column.class.cast(object));
        } else {
            for (SimpleValue simpleValue : ((Tuple)object).values()) {
                if (!Column.class.isInstance(simpleValue)) continue;
                entityBinding.getPrimaryTable().getPrimaryKey().addColumn((Column)Column.class.cast(simpleValue));
            }
        }
    }

    private void bindVersion(EntityBinding entityBinding, RootEntitySource rootEntitySource) {
        SingularAttributeSource singularAttributeSource = rootEntitySource.getVersioningAttributeSource();
        if (singularAttributeSource == null) {
            return;
        }
        BasicAttributeBinding basicAttributeBinding = this.doBasicSingularAttributeBindingCreation(singularAttributeSource, entityBinding);
        entityBinding.getHierarchyDetails().setVersioningAttributeBinding(basicAttributeBinding);
    }

    private void bindDiscriminator(RootEntitySource rootEntitySource, EntityBinding entityBinding) {
        DiscriminatorSource discriminatorSource = rootEntitySource.getDiscriminatorSource();
        if (discriminatorSource == null) {
            return;
        }
        EntityDiscriminator entityDiscriminator = new EntityDiscriminator();
        SimpleValue simpleValue = this.makeSimpleValue(entityBinding, discriminatorSource.getDiscriminatorRelationalValueSource());
        entityDiscriminator.setBoundValue(simpleValue);
        entityDiscriminator.getExplicitHibernateTypeDescriptor().setExplicitTypeName(discriminatorSource.getExplicitHibernateTypeName() != null ? discriminatorSource.getExplicitHibernateTypeName() : "string");
        entityDiscriminator.setInserted(discriminatorSource.isInserted());
        entityDiscriminator.setForced(discriminatorSource.isForced());
        entityBinding.getHierarchyDetails().setEntityDiscriminator(entityDiscriminator);
        entityBinding.setDiscriminatorMatchValue(rootEntitySource.getDiscriminatorMatchValue());
    }

    private void bindDiscriminatorValue(SubclassEntitySource subclassEntitySource, EntityBinding entityBinding) {
        String string = subclassEntitySource.getDiscriminatorMatchValue();
        if (string == null) {
            return;
        }
        entityBinding.setDiscriminatorMatchValue(string);
    }

    private void bindAttributes(AttributeSourceContainer attributeSourceContainer, AttributeBindingContainer attributeBindingContainer) {
        for (AttributeSource attributeSource : attributeSourceContainer.attributeSources()) {
            if (attributeSource.isSingular()) {
                SingularAttributeSource singularAttributeSource = (SingularAttributeSource)attributeSource;
                if (singularAttributeSource.getNature() == SingularAttributeNature.COMPONENT) {
                    this.bindComponent((ComponentAttributeSource)singularAttributeSource, attributeBindingContainer);
                    continue;
                }
                this.doBasicSingularAttributeBindingCreation(singularAttributeSource, attributeBindingContainer);
                continue;
            }
            this.bindPersistentCollection((PluralAttributeSource)attributeSource, attributeBindingContainer);
        }
    }

    private void bindComponent(ComponentAttributeSource componentAttributeSource, AttributeBindingContainer attributeBindingContainer) {
        Object object;
        String string = componentAttributeSource.getName();
        SingularAttribute singularAttribute = attributeBindingContainer.getAttributeContainer().locateComponentAttribute(string);
        if (singularAttribute == null) {
            object = new Component(componentAttributeSource.getPath(), componentAttributeSource.getClassName(), componentAttributeSource.getClassReference(), null);
            singularAttribute = attributeBindingContainer.getAttributeContainer().createComponentAttribute(string, (Component)object);
        }
        object = attributeBindingContainer.makeComponentAttributeBinding(singularAttribute);
        if (StringHelper.isNotEmpty(componentAttributeSource.getParentReferenceAttributeName())) {
            SingularAttribute singularAttribute2 = ((ComponentAttributeBinding)object).getComponent().createSingularAttribute(componentAttributeSource.getParentReferenceAttributeName());
            ((ComponentAttributeBinding)object).setParentReference(singularAttribute2);
        }
        ((ComponentAttributeBinding)object).setMetaAttributeContext(Binder.buildMetaAttributeContext(componentAttributeSource.metaAttributes(), attributeBindingContainer.getMetaAttributeContext()));
        this.bindAttributes(componentAttributeSource, (AttributeBindingContainer)object);
    }

    private void bindPersistentCollection(PluralAttributeSource pluralAttributeSource, AttributeBindingContainer attributeBindingContainer) {
        AbstractPluralAttributeBinding abstractPluralAttributeBinding;
        PluralAttribute pluralAttribute = attributeBindingContainer.getAttributeContainer().locatePluralAttribute(pluralAttributeSource.getName());
        if (pluralAttributeSource.getPluralAttributeNature() == PluralAttributeNature.BAG) {
            PluralAttribute pluralAttribute2 = pluralAttribute != null ? pluralAttribute : attributeBindingContainer.getAttributeContainer().createBag(pluralAttributeSource.getName());
            abstractPluralAttributeBinding = attributeBindingContainer.makeBagAttributeBinding(pluralAttribute2, this.convert(pluralAttributeSource.getElementSource().getNature()));
        } else if (pluralAttributeSource.getPluralAttributeNature() == PluralAttributeNature.SET) {
            PluralAttribute pluralAttribute3 = pluralAttribute != null ? pluralAttribute : attributeBindingContainer.getAttributeContainer().createSet(pluralAttributeSource.getName());
            abstractPluralAttributeBinding = attributeBindingContainer.makeSetAttributeBinding(pluralAttribute3, this.convert(pluralAttributeSource.getElementSource().getNature()));
        } else {
            throw new NotYetImplementedException("Collections other than bag and set not yet implemented :(");
        }
        this.doBasicPluralAttributeBinding(pluralAttributeSource, abstractPluralAttributeBinding);
        this.bindCollectionTable(pluralAttributeSource, abstractPluralAttributeBinding);
        this.bindSortingAndOrdering(pluralAttributeSource, abstractPluralAttributeBinding);
        this.bindCollectionKey(pluralAttributeSource, abstractPluralAttributeBinding);
        this.bindCollectionElement(pluralAttributeSource, abstractPluralAttributeBinding);
        this.bindCollectionIndex(pluralAttributeSource, abstractPluralAttributeBinding);
        this.metadata.addCollection(abstractPluralAttributeBinding);
    }

    private void doBasicPluralAttributeBinding(PluralAttributeSource pluralAttributeSource, AbstractPluralAttributeBinding abstractPluralAttributeBinding) {
        abstractPluralAttributeBinding.setFetchTiming(pluralAttributeSource.getFetchTiming());
        abstractPluralAttributeBinding.setFetchStyle(pluralAttributeSource.getFetchStyle());
        abstractPluralAttributeBinding.setCascadeStyles(pluralAttributeSource.getCascadeStyles());
        abstractPluralAttributeBinding.setCaching(pluralAttributeSource.getCaching());
        abstractPluralAttributeBinding.getHibernateTypeDescriptor().setJavaTypeName(pluralAttributeSource.getPluralAttributeNature().reportedJavaType().getName());
        abstractPluralAttributeBinding.getHibernateTypeDescriptor().setExplicitTypeName(pluralAttributeSource.getTypeInformation().getName());
        abstractPluralAttributeBinding.getHibernateTypeDescriptor().getTypeParameters().putAll(pluralAttributeSource.getTypeInformation().getParameters());
        if (StringHelper.isNotEmpty(pluralAttributeSource.getCustomPersisterClassName())) {
            abstractPluralAttributeBinding.setCollectionPersisterClass(this.currentBindingContext.locateClassByName(pluralAttributeSource.getCustomPersisterClassName()));
        }
        if (pluralAttributeSource.getCustomPersisterClassName() != null) {
            abstractPluralAttributeBinding.setCollectionPersisterClass(this.metadata.locateClassByName(pluralAttributeSource.getCustomPersisterClassName()));
        }
        abstractPluralAttributeBinding.setCustomLoaderName(pluralAttributeSource.getCustomLoaderName());
        abstractPluralAttributeBinding.setCustomSqlInsert(pluralAttributeSource.getCustomSqlInsert());
        abstractPluralAttributeBinding.setCustomSqlUpdate(pluralAttributeSource.getCustomSqlUpdate());
        abstractPluralAttributeBinding.setCustomSqlDelete(pluralAttributeSource.getCustomSqlDelete());
        abstractPluralAttributeBinding.setCustomSqlDeleteAll(pluralAttributeSource.getCustomSqlDeleteAll());
        abstractPluralAttributeBinding.setMetaAttributeContext(Binder.buildMetaAttributeContext(pluralAttributeSource.metaAttributes(), abstractPluralAttributeBinding.getContainer().getMetaAttributeContext()));
        this.doBasicAttributeBinding(pluralAttributeSource, abstractPluralAttributeBinding);
    }

    private CollectionLaziness interpretLaziness(String string) {
        if (string == null) {
            string = Boolean.toString(this.metadata.getMappingDefaults().areAssociationsLazy());
        }
        if ("extra".equals(string)) {
            return CollectionLaziness.EXTRA;
        }
        if ("false".equals(string)) {
            return CollectionLaziness.NOT;
        }
        if ("true".equals(string)) {
            return CollectionLaziness.LAZY;
        }
        throw new MappingException(String.format("Unexpected collection laziness value %s", string), this.currentBindingContext.getOrigin());
    }

    private void bindCollectionTable(PluralAttributeSource pluralAttributeSource, AbstractPluralAttributeBinding abstractPluralAttributeBinding) {
        if (pluralAttributeSource.getElementSource().getNature() == PluralAttributeElementNature.ONE_TO_MANY) {
            return;
        }
        Schema.Name name = Helper.determineDatabaseSchemaName(pluralAttributeSource.getExplicitSchemaName(), pluralAttributeSource.getExplicitCatalogName(), this.currentBindingContext);
        Schema schema = this.metadata.getDatabase().locateSchema(name);
        String string = pluralAttributeSource.getExplicitCollectionTableName();
        if (StringHelper.isNotEmpty(string)) {
            Identifier identifier = Identifier.toIdentifier(this.currentBindingContext.getNamingStrategy().tableName(string));
            Table table = schema.locateTable(identifier);
            if (table == null) {
                table = schema.createTable(identifier);
            }
            abstractPluralAttributeBinding.setCollectionTable(table);
        } else {
            EntityBinding entityBinding = abstractPluralAttributeBinding.getContainer().seekEntityBinding();
            String string2 = Table.class.isInstance(entityBinding.getPrimaryTable()) ? ((Table)Table.class.cast(entityBinding.getPrimaryTable())).getTableName().getName() : null;
            String string3 = this.currentBindingContext.getNamingStrategy().collectionTableName(entityBinding.getEntity().getName(), string2, null, null, abstractPluralAttributeBinding.getContainer().getPathBase() + '.' + pluralAttributeSource.getName());
            string3 = this.quoteIdentifier(string3);
            abstractPluralAttributeBinding.setCollectionTable(schema.locateOrCreateTable(Identifier.toIdentifier(string3)));
        }
        if (StringHelper.isNotEmpty(pluralAttributeSource.getCollectionTableComment())) {
            abstractPluralAttributeBinding.getCollectionTable().addComment(pluralAttributeSource.getCollectionTableComment());
        }
        if (StringHelper.isNotEmpty(pluralAttributeSource.getCollectionTableCheck())) {
            abstractPluralAttributeBinding.getCollectionTable().addCheckConstraint(pluralAttributeSource.getCollectionTableCheck());
        }
        abstractPluralAttributeBinding.setWhere(pluralAttributeSource.getWhere());
    }

    private void bindCollectionKey(PluralAttributeSource pluralAttributeSource, AbstractPluralAttributeBinding abstractPluralAttributeBinding) {
        abstractPluralAttributeBinding.getCollectionKey().prepareForeignKey(pluralAttributeSource.getKeySource().getExplicitForeignKeyName(), null);
        abstractPluralAttributeBinding.getCollectionKey().getForeignKey().setDeleteRule(pluralAttributeSource.getKeySource().getOnDeleteAction());
    }

    private void bindCollectionElement(PluralAttributeSource pluralAttributeSource, AbstractPluralAttributeBinding abstractPluralAttributeBinding) {
        PluralAttributeElementSource pluralAttributeElementSource = pluralAttributeSource.getElementSource();
        if (pluralAttributeElementSource.getNature() == PluralAttributeElementNature.BASIC) {
            BasicPluralAttributeElementSource basicPluralAttributeElementSource = (BasicPluralAttributeElementSource)pluralAttributeElementSource;
            BasicCollectionElement basicCollectionElement = (BasicCollectionElement)abstractPluralAttributeBinding.getCollectionElement();
            this.resolveTypeInformation(basicPluralAttributeElementSource.getExplicitHibernateTypeSource(), abstractPluralAttributeBinding.getAttribute(), basicCollectionElement);
            return;
        }
        throw new NotYetImplementedException(String.format("Support for collection elements of type %s not yet implemented", new Object[]{pluralAttributeElementSource.getNature()}));
    }

    private void bindCollectionIndex(PluralAttributeSource pluralAttributeSource, AbstractPluralAttributeBinding abstractPluralAttributeBinding) {
        if (pluralAttributeSource.getPluralAttributeNature() != PluralAttributeNature.LIST && pluralAttributeSource.getPluralAttributeNature() != PluralAttributeNature.MAP) {
            return;
        }
        throw new NotYetImplementedException();
    }

    private void bindSortingAndOrdering(PluralAttributeSource pluralAttributeSource, AbstractPluralAttributeBinding abstractPluralAttributeBinding) {
        Object object;
        if (Sortable.class.isInstance(pluralAttributeSource) && (object = (Sortable)Sortable.class.cast(pluralAttributeSource)).isSorted()) {
            return;
        }
        if (!Orderable.class.isInstance(pluralAttributeSource) || (object = (Orderable)Orderable.class.cast(pluralAttributeSource)).isOrdered()) {
            // empty if block
        }
    }

    private void doBasicAttributeBinding(AttributeSource attributeSource, AttributeBinding attributeBinding) {
        attributeBinding.setPropertyAccessorName(attributeSource.getPropertyAccessorName());
        attributeBinding.setIncludedInOptimisticLocking(attributeSource.isIncludedInOptimisticLocking());
    }

    private CollectionElementNature convert(PluralAttributeElementNature pluralAttributeElementNature) {
        return CollectionElementNature.valueOf(pluralAttributeElementNature.name());
    }

    private BasicAttributeBinding doBasicSingularAttributeBindingCreation(SingularAttributeSource singularAttributeSource, AttributeBindingContainer attributeBindingContainer) {
        BasicAttributeBinding basicAttributeBinding;
        SingularAttribute singularAttribute = attributeBindingContainer.getAttributeContainer().locateSingularAttribute(singularAttributeSource.getName());
        SingularAttribute singularAttribute2 = singularAttribute != null ? singularAttribute : (singularAttributeSource.isVirtualAttribute() ? attributeBindingContainer.getAttributeContainer().createVirtualSingularAttribute(singularAttributeSource.getName()) : attributeBindingContainer.getAttributeContainer().createSingularAttribute(singularAttributeSource.getName()));
        if (singularAttributeSource.getNature() == SingularAttributeNature.BASIC) {
            basicAttributeBinding = attributeBindingContainer.makeBasicAttributeBinding(singularAttribute2);
            this.resolveTypeInformation(singularAttributeSource.getTypeInformation(), basicAttributeBinding);
        } else if (singularAttributeSource.getNature() == SingularAttributeNature.MANY_TO_ONE) {
            basicAttributeBinding = attributeBindingContainer.makeManyToOneAttributeBinding(singularAttribute2);
            this.resolveTypeInformation(singularAttributeSource.getTypeInformation(), basicAttributeBinding);
            this.resolveToOneInformation((ToOneAttributeSource)singularAttributeSource, (ManyToOneAttributeBinding)basicAttributeBinding);
        } else {
            throw new NotYetImplementedException();
        }
        basicAttributeBinding.setGeneration(singularAttributeSource.getGeneration());
        basicAttributeBinding.setLazy(singularAttributeSource.isLazy());
        basicAttributeBinding.setIncludedInOptimisticLocking(singularAttributeSource.isIncludedInOptimisticLocking());
        basicAttributeBinding.setPropertyAccessorName(Helper.getPropertyAccessorName(singularAttributeSource.getPropertyAccessorName(), false, this.currentBindingContext.getMappingDefaults().getPropertyAccessorName()));
        this.bindRelationalValues(singularAttributeSource, basicAttributeBinding);
        basicAttributeBinding.setMetaAttributeContext(Binder.buildMetaAttributeContext(singularAttributeSource.metaAttributes(), attributeBindingContainer.getMetaAttributeContext()));
        return basicAttributeBinding;
    }

    private void resolveTypeInformation(ExplicitHibernateTypeSource explicitHibernateTypeSource, BasicAttributeBinding basicAttributeBinding) {
        Class<?> clazz = this.determineJavaType(basicAttributeBinding.getAttribute());
        if (clazz != null) {
            basicAttributeBinding.getAttribute().resolveType(this.currentBindingContext.makeJavaType(clazz.getName()));
        }
        this.resolveTypeInformation(explicitHibernateTypeSource, basicAttributeBinding.getHibernateTypeDescriptor(), clazz);
    }

    private void resolveTypeInformation(ExplicitHibernateTypeSource explicitHibernateTypeSource, PluralAttribute pluralAttribute, BasicCollectionElement basicCollectionElement) {
        Class<?> clazz = this.determineJavaType(pluralAttribute);
        this.resolveTypeInformation(explicitHibernateTypeSource, basicCollectionElement.getHibernateTypeDescriptor(), clazz);
    }

    private void resolveTypeInformation(ExplicitHibernateTypeSource explicitHibernateTypeSource, HibernateTypeDescriptor hibernateTypeDescriptor, Class<?> clazz) {
        String string;
        if (clazz != null) {
            hibernateTypeDescriptor.setJavaTypeName(clazz.getName());
        }
        if ((string = explicitHibernateTypeSource.getName()) != null) {
            TypeDef typeDef = this.currentBindingContext.getMetadataImplementor().getTypeDefinition(string);
            if (typeDef != null) {
                hibernateTypeDescriptor.setExplicitTypeName(typeDef.getTypeClass());
                hibernateTypeDescriptor.getTypeParameters().putAll(typeDef.getParameters());
            } else {
                hibernateTypeDescriptor.setExplicitTypeName(string);
            }
            Map<String, String> map = explicitHibernateTypeSource.getParameters();
            if (map != null) {
                hibernateTypeDescriptor.getTypeParameters().putAll(map);
            }
        } else if (clazz == null) {
            // empty if block
        }
    }

    private Class<?> determineJavaType(SingularAttribute singularAttribute) {
        try {
            Class<?> clazz = singularAttribute.getAttributeContainer().getClassReference();
            AttributeJavaTypeDeterminerDelegate attributeJavaTypeDeterminerDelegate = new AttributeJavaTypeDeterminerDelegate(singularAttribute.getName());
            BeanInfoHelper.visitBeanInfo(clazz, attributeJavaTypeDeterminerDelegate);
            return attributeJavaTypeDeterminerDelegate.javaType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Class<?> determineJavaType(PluralAttribute pluralAttribute) {
        try {
            Class<?> clazz = pluralAttribute.getAttributeContainer().getClassReference();
            PluralAttributeJavaTypeDeterminerDelegate pluralAttributeJavaTypeDeterminerDelegate = new PluralAttributeJavaTypeDeterminerDelegate(clazz, pluralAttribute.getName());
            BeanInfoHelper.visitBeanInfo(clazz, pluralAttributeJavaTypeDeterminerDelegate);
            return pluralAttributeJavaTypeDeterminerDelegate.javaType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void resolveToOneInformation(ToOneAttributeSource toOneAttributeSource, ManyToOneAttributeBinding manyToOneAttributeBinding) {
        String string = toOneAttributeSource.getReferencedEntityName() != null ? toOneAttributeSource.getReferencedEntityName() : manyToOneAttributeBinding.getAttribute().getSingularAttributeType().getClassName();
        manyToOneAttributeBinding.setReferencedEntityName(string);
        manyToOneAttributeBinding.setReferencedAttributeName(toOneAttributeSource.getReferencedEntityAttributeName());
        manyToOneAttributeBinding.setCascadeStyles(toOneAttributeSource.getCascadeStyles());
        manyToOneAttributeBinding.setFetchTiming(toOneAttributeSource.getFetchTiming());
        manyToOneAttributeBinding.setFetchStyle(toOneAttributeSource.getFetchStyle());
    }

    private MetaAttributeContext buildMetaAttributeContext(EntitySource entitySource) {
        return Binder.buildMetaAttributeContext(entitySource.metaAttributes(), true, this.currentBindingContext.getMetadataImplementor().getGlobalMetaAttributeContext());
    }

    private static MetaAttributeContext buildMetaAttributeContext(Iterable<MetaAttributeSource> iterable, MetaAttributeContext metaAttributeContext) {
        return Binder.buildMetaAttributeContext(iterable, false, metaAttributeContext);
    }

    private static MetaAttributeContext buildMetaAttributeContext(Iterable<MetaAttributeSource> iterable, boolean bl, MetaAttributeContext metaAttributeContext) {
        MetaAttributeContext metaAttributeContext2 = new MetaAttributeContext(metaAttributeContext);
        for (MetaAttributeSource metaAttributeSource : iterable) {
            if (bl & !metaAttributeSource.isInheritable()) continue;
            String string = metaAttributeSource.getName();
            MetaAttribute metaAttribute = metaAttributeContext.getMetaAttribute(string);
            MetaAttribute metaAttribute2 = metaAttributeContext2.getLocalMetaAttribute(string);
            if (metaAttribute2 == null || metaAttribute2 == metaAttribute) {
                metaAttribute2 = new MetaAttribute(string);
                metaAttributeContext2.add(metaAttribute2);
            }
            metaAttribute2.addValue(metaAttributeSource.getValue());
        }
        return metaAttributeContext2;
    }

    private void bindPrimaryTable(EntitySource entitySource, EntityBinding entityBinding) {
        TableSource tableSource = entitySource.getPrimaryTable();
        Table table = this.createTable(entityBinding, tableSource);
        entityBinding.setPrimaryTable(table);
        entityBinding.setPrimaryTableName(table.getTableName().getName());
    }

    private void bindSecondaryTables(EntitySource entitySource, EntityBinding entityBinding) {
        for (TableSource tableSource : entitySource.getSecondaryTables()) {
            Table table = this.createTable(entityBinding, tableSource);
            entityBinding.addSecondaryTable(tableSource.getLogicalName(), table);
        }
    }

    private Table createTable(EntityBinding entityBinding, TableSource tableSource) {
        String string = tableSource.getExplicitTableName();
        string = StringHelper.isEmpty(string) ? this.currentBindingContext.getNamingStrategy().classToTableName(entityBinding.getEntity().getClassName()) : this.currentBindingContext.getNamingStrategy().tableName(string);
        string = this.quoteIdentifier(string);
        Schema.Name name = Helper.determineDatabaseSchemaName(tableSource.getExplicitSchemaName(), tableSource.getExplicitCatalogName(), this.currentBindingContext);
        return this.currentBindingContext.getMetadataImplementor().getDatabase().locateSchema(name).locateOrCreateTable(Identifier.toIdentifier(string));
    }

    private void bindTableUniqueConstraints(EntitySource entitySource, EntityBinding entityBinding) {
        for (ConstraintSource constraintSource : entitySource.getConstraints()) {
            String string;
            if (!(constraintSource instanceof UniqueConstraintSource)) continue;
            TableSpecification tableSpecification = entityBinding.locateTable(constraintSource.getTableName());
            if (tableSpecification == null) {
                // empty if block
            }
            if ((string = constraintSource.name()) == null) {
                // empty if block
            }
            UniqueKey uniqueKey = tableSpecification.getOrCreateUniqueKey(string);
            for (String string2 : constraintSource.columnNames()) {
                uniqueKey.addColumn(tableSpecification.locateOrCreateColumn(this.quoteIdentifier(string2)));
            }
        }
    }

    private void bindRelationalValues(RelationalValueSourceContainer relationalValueSourceContainer, SingularAttributeBinding singularAttributeBinding) {
        ArrayList<SimpleValueBinding> arrayList = new ArrayList<SimpleValueBinding>();
        if (!relationalValueSourceContainer.relationalValueSources().isEmpty()) {
            for (RelationalValueSource relationalValueSource : relationalValueSourceContainer.relationalValueSources()) {
                TableSpecification tableSpecification = singularAttributeBinding.getContainer().seekEntityBinding().locateTable(relationalValueSource.getContainingTableName());
                if (ColumnSource.class.isInstance(relationalValueSource)) {
                    ColumnSource columnSource = (ColumnSource)ColumnSource.class.cast(relationalValueSource);
                    Column column = this.makeColumn((ColumnSource)relationalValueSource, tableSpecification);
                    arrayList.add(new SimpleValueBinding(column, columnSource.isIncludedInInsert(), columnSource.isIncludedInUpdate()));
                    continue;
                }
                arrayList.add(new SimpleValueBinding(this.makeDerivedValue((DerivedValueSource)relationalValueSource, tableSpecification)));
            }
        } else {
            String string = this.metadata.getOptions().getNamingStrategy().propertyToColumnName(singularAttributeBinding.getAttribute().getName());
            string = this.quoteIdentifier(string);
            Column column = singularAttributeBinding.getContainer().seekEntityBinding().getPrimaryTable().locateOrCreateColumn(string);
            column.setNullable(relationalValueSourceContainer.areValuesNullableByDefault());
            arrayList.add(new SimpleValueBinding(column, relationalValueSourceContainer.areValuesIncludedInInsertByDefault(), relationalValueSourceContainer.areValuesIncludedInUpdateByDefault()));
        }
        singularAttributeBinding.setSimpleValueBindings(arrayList);
    }

    private String quoteIdentifier(String string) {
        return this.currentBindingContext.isGloballyQuotedIdentifiers() ? StringHelper.quote(string) : string;
    }

    private SimpleValue makeSimpleValue(EntityBinding entityBinding, RelationalValueSource relationalValueSource) {
        TableSpecification tableSpecification = entityBinding.locateTable(relationalValueSource.getContainingTableName());
        if (ColumnSource.class.isInstance(relationalValueSource)) {
            return this.makeColumn((ColumnSource)relationalValueSource, tableSpecification);
        }
        return this.makeDerivedValue((DerivedValueSource)relationalValueSource, tableSpecification);
    }

    private Column makeColumn(ColumnSource columnSource, TableSpecification tableSpecification) {
        String string = columnSource.getName();
        string = this.metadata.getOptions().getNamingStrategy().columnName(string);
        string = this.quoteIdentifier(string);
        Column column = tableSpecification.locateOrCreateColumn(string);
        column.setNullable(columnSource.isNullable());
        column.setDefaultValue(columnSource.getDefaultValue());
        column.setSqlType(columnSource.getSqlType());
        column.setSize(columnSource.getSize());
        column.setDatatype(columnSource.getDatatype());
        column.setReadFragment(columnSource.getReadFragment());
        column.setWriteFragment(columnSource.getWriteFragment());
        column.setUnique(columnSource.isUnique());
        column.setCheckCondition(columnSource.getCheckCondition());
        column.setComment(columnSource.getComment());
        return column;
    }

    private DerivedValue makeDerivedValue(DerivedValueSource derivedValueSource, TableSpecification tableSpecification) {
        return tableSpecification.locateOrCreateDerivedValue(derivedValueSource.getExpression());
    }

    private void processFetchProfiles(EntitySource entitySource, EntityBinding entityBinding) {
    }

    private static class AttributeJavaTypeDeterminerDelegate
    implements BeanInfoHelper.BeanInfoDelegate {
        private final String attributeName;
        private Class<?> javaType = null;

        private AttributeJavaTypeDeterminerDelegate(String string) {
            this.attributeName = string;
        }

        public void processBeanInfo(BeanInfo beanInfo) throws Exception {
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(this.attributeName)) continue;
                this.javaType = propertyDescriptor.getPropertyType();
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluralAttributeJavaTypeDeterminerDelegate
    implements BeanInfoHelper.BeanInfoDelegate {
        private final Class<?> ownerClass;
        private final String attributeName;
        private Class<?> javaType = null;

        private PluralAttributeJavaTypeDeterminerDelegate(Class<?> clazz, String string) {
            this.ownerClass = clazz;
            this.attributeName = string;
        }

        @Override
        public void processBeanInfo(BeanInfo beanInfo) throws Exception {
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(this.attributeName)) continue;
                this.javaType = this.extractCollectionComponentType(beanInfo, propertyDescriptor);
                break;
            }
        }

        private Class<?> extractCollectionComponentType(BeanInfo beanInfo, PropertyDescriptor propertyDescriptor) {
            Type type;
            if (propertyDescriptor.getReadMethod() != null) {
                type = propertyDescriptor.getReadMethod().getGenericReturnType();
            } else if (propertyDescriptor.getWriteMethod() != null) {
                type = propertyDescriptor.getWriteMethod().getGenericParameterTypes()[0];
            } else {
                try {
                    type = this.ownerClass.getField(propertyDescriptor.getName()).getGenericType();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (ParameterizedType.class.isInstance(type)) {
                Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                if (typeArray == null) {
                    return null;
                }
                if (typeArray.length == 1) {
                    return (Class)typeArray[0];
                }
                if (typeArray.length == 2) {
                    return (Class)typeArray[1];
                }
            }
            return null;
        }
    }
}

