/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAccessType;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEnumType;
import org.hibernate.internal.jaxb.mapping.orm.JaxbMapKey;
import org.hibernate.internal.jaxb.mapping.orm.JaxbMapKeyClass;
import org.hibernate.internal.jaxb.mapping.orm.JaxbMapKeyColumn;
import org.hibernate.internal.jaxb.mapping.orm.JaxbMapKeyJoinColumn;
import org.hibernate.internal.jaxb.mapping.orm.JaxbTemporalType;
import org.hibernate.metamodel.source.annotations.xml.mocker.AccessHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.AnnotationMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PropertyMocker
extends AnnotationMocker {
    protected ClassInfo classInfo;
    private AnnotationTarget target;

    PropertyMocker(IndexBuilder indexBuilder, ClassInfo classInfo, EntityMappingsMocker.Default default_) {
        super(indexBuilder, default_);
        this.classInfo = classInfo;
    }

    protected abstract void processExtra();

    protected abstract String getFieldName();

    protected abstract JaxbAccessType getAccessType();

    protected abstract void setAccessType(JaxbAccessType var1);

    @Override
    protected DotName getTargetName() {
        return this.classInfo.name();
    }

    protected void resolveTarget() {
        JaxbAccessType jaxbAccessType = this.getAccessType();
        if (jaxbAccessType == null) {
            jaxbAccessType = AccessHelper.getAccessFromAttributeAnnotation(this.getTargetName(), this.getFieldName(), this.indexBuilder);
            if (jaxbAccessType == null) {
                jaxbAccessType = AccessHelper.getEntityAccess(this.getTargetName(), this.indexBuilder);
            }
            if (jaxbAccessType == null) {
                jaxbAccessType = AccessHelper.getAccessFromIdPosition(this.getTargetName(), this.indexBuilder);
            }
            if (jaxbAccessType == null) {
                jaxbAccessType = AccessHelper.getAccessFromDefault(this.indexBuilder);
            }
            if (jaxbAccessType == null) {
                jaxbAccessType = JaxbAccessType.PROPERTY;
            }
            this.setAccessType(jaxbAccessType);
        }
    }

    @Override
    protected AnnotationTarget getTarget() {
        if (this.target == null) {
            this.target = this.getTargetFromAttributeAccessType(this.getAccessType());
        }
        return this.target;
    }

    protected AnnotationTarget getTargetFromAttributeAccessType(JaxbAccessType jaxbAccessType) {
        if (jaxbAccessType == null) {
            throw new IllegalArgumentException("access type can't be null.");
        }
        switch (jaxbAccessType) {
            case FIELD: {
                return MockHelper.getTarget(this.indexBuilder.getServiceRegistry(), this.classInfo, this.getFieldName(), MockHelper.TargetType.FIELD);
            }
            case PROPERTY: {
                return MockHelper.getTarget(this.indexBuilder.getServiceRegistry(), this.classInfo, this.getFieldName(), MockHelper.TargetType.PROPERTY);
            }
        }
        throw new HibernateException("can't determin access type [" + (Object)((Object)jaxbAccessType) + "]");
    }

    @Override
    final void process() {
        this.resolveTarget();
        this.processExtra();
    }

    protected AnnotationInstance parserMapKeyColumn(JaxbMapKeyColumn jaxbMapKeyColumn, AnnotationTarget annotationTarget) {
        if (jaxbMapKeyColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbMapKeyColumn.getName(), arrayList);
        MockHelper.stringValue("columnDefinition", jaxbMapKeyColumn.getColumnDefinition(), arrayList);
        MockHelper.stringValue("table", jaxbMapKeyColumn.getTable(), arrayList);
        MockHelper.booleanValue("nullable", jaxbMapKeyColumn.isNullable(), arrayList);
        MockHelper.booleanValue("insertable", jaxbMapKeyColumn.isInsertable(), arrayList);
        MockHelper.booleanValue("updatable", jaxbMapKeyColumn.isUpdatable(), arrayList);
        MockHelper.booleanValue("unique", jaxbMapKeyColumn.isUnique(), arrayList);
        MockHelper.integerValue("length", jaxbMapKeyColumn.getLength(), arrayList);
        MockHelper.integerValue("precision", jaxbMapKeyColumn.getPrecision(), arrayList);
        MockHelper.integerValue("scale", jaxbMapKeyColumn.getScale(), arrayList);
        return this.create(MAP_KEY_COLUMN, annotationTarget, arrayList);
    }

    protected AnnotationInstance parserMapKeyClass(JaxbMapKeyClass jaxbMapKeyClass, AnnotationTarget annotationTarget) {
        if (jaxbMapKeyClass == null) {
            return null;
        }
        return this.create(MAP_KEY_CLASS, annotationTarget, MockHelper.classValueArray("value", jaxbMapKeyClass.getClazz(), this.indexBuilder.getServiceRegistry()));
    }

    protected AnnotationInstance parserMapKeyTemporal(JaxbTemporalType jaxbTemporalType, AnnotationTarget annotationTarget) {
        if (jaxbTemporalType == null) {
            return null;
        }
        return this.create(MAP_KEY_TEMPORAL, annotationTarget, MockHelper.enumValueArray("value", TEMPORAL_TYPE, jaxbTemporalType));
    }

    protected AnnotationInstance parserMapKeyEnumerated(JaxbEnumType jaxbEnumType, AnnotationTarget annotationTarget) {
        if (jaxbEnumType == null) {
            return null;
        }
        return this.create(MAP_KEY_ENUMERATED, annotationTarget, MockHelper.enumValueArray("value", ENUM_TYPE, jaxbEnumType));
    }

    protected AnnotationInstance parserMapKey(JaxbMapKey jaxbMapKey, AnnotationTarget annotationTarget) {
        if (jaxbMapKey == null) {
            return null;
        }
        return this.create(MAP_KEY, annotationTarget, MockHelper.stringValueArray("name", jaxbMapKey.getName()));
    }

    private AnnotationValue[] nestedMapKeyJoinColumnList(String string, List<JaxbMapKeyJoinColumn> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserMapKeyJoinColumn(list.get(i), null);
                annotationValueArray[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(list2, AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
            return annotationValueArray;
        }
        return MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY;
    }

    protected AnnotationInstance parserMapKeyJoinColumnList(List<JaxbMapKeyJoinColumn> list, AnnotationTarget annotationTarget) {
        if (MockHelper.isNotEmpty(list)) {
            if (list.size() == 1) {
                return this.parserMapKeyJoinColumn(list.get(0), annotationTarget);
            }
            AnnotationValue[] annotationValueArray = this.nestedMapKeyJoinColumnList("value", list, null);
            return this.create(MAP_KEY_JOIN_COLUMNS, annotationTarget, annotationValueArray);
        }
        return null;
    }

    private AnnotationInstance parserMapKeyJoinColumn(JaxbMapKeyJoinColumn jaxbMapKeyJoinColumn, AnnotationTarget annotationTarget) {
        if (jaxbMapKeyJoinColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbMapKeyJoinColumn.getName(), arrayList);
        MockHelper.stringValue("columnDefinition", jaxbMapKeyJoinColumn.getColumnDefinition(), arrayList);
        MockHelper.stringValue("table", jaxbMapKeyJoinColumn.getTable(), arrayList);
        MockHelper.stringValue("referencedColumnName", jaxbMapKeyJoinColumn.getReferencedColumnName(), arrayList);
        MockHelper.booleanValue("unique", jaxbMapKeyJoinColumn.isUnique(), arrayList);
        MockHelper.booleanValue("nullable", jaxbMapKeyJoinColumn.isNullable(), arrayList);
        MockHelper.booleanValue("insertable", jaxbMapKeyJoinColumn.isInsertable(), arrayList);
        MockHelper.booleanValue("updatable", jaxbMapKeyJoinColumn.isUpdatable(), arrayList);
        return this.create(MAP_KEY_JOIN_COLUMN, annotationTarget, arrayList);
    }
}

