/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAccessType;
import org.hibernate.internal.jaxb.mapping.orm.JaxbOneToOne;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.PropertyMocker;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

class OneToOneMocker
extends PropertyMocker {
    private JaxbOneToOne oneToOne;

    OneToOneMocker(IndexBuilder indexBuilder, ClassInfo classInfo, EntityMappingsMocker.Default default_, JaxbOneToOne jaxbOneToOne) {
        super(indexBuilder, classInfo, default_);
        this.oneToOne = jaxbOneToOne;
    }

    protected String getFieldName() {
        return this.oneToOne.getName();
    }

    protected void processExtra() {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.classValue("targetEntity", this.oneToOne.getTargetEntity(), arrayList, this.indexBuilder.getServiceRegistry());
        MockHelper.enumValue("fetch", FETCH_TYPE, this.oneToOne.getFetch(), arrayList);
        MockHelper.booleanValue("optional", this.oneToOne.isOptional(), arrayList);
        MockHelper.booleanValue("orphanRemoval", this.oneToOne.isOrphanRemoval(), arrayList);
        MockHelper.stringValue("mappedBy", this.oneToOne.getMappedBy(), arrayList);
        MockHelper.cascadeValue("cascade", this.oneToOne.getCascade(), this.isDefaultCascadePersist(), arrayList);
        this.create(ONE_TO_ONE, arrayList);
        this.parserPrimaryKeyJoinColumnList(this.oneToOne.getPrimaryKeyJoinColumn(), this.getTarget());
        this.parserJoinColumnList(this.oneToOne.getJoinColumn(), this.getTarget());
        this.parserJoinTable(this.oneToOne.getJoinTable(), this.getTarget());
        if (this.oneToOne.getMapsId() != null) {
            this.create(MAPS_ID, MockHelper.stringValueArray("value", this.oneToOne.getMapsId()));
        }
        if (this.oneToOne.isId() != null && this.oneToOne.isId().booleanValue()) {
            this.create(ID);
        }
    }

    protected JaxbAccessType getAccessType() {
        return this.oneToOne.getAccess();
    }

    protected void setAccessType(JaxbAccessType jaxbAccessType) {
        this.oneToOne.setAccess(jaxbAccessType);
    }
}

