/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import org.hibernate.HibernateException;
import org.hibernate.internal.jaxb.mapping.orm.JaxbCascadeType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHelper {
    static final AnnotationValue[] EMPTY_ANNOTATION_VALUE_ARRAY = new AnnotationValue[0];
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    static void stringArrayValue(String string, List<String> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                annotationValueArray[i] = MockHelper.stringValue("", list.get(i));
            }
            list2.add(AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
        }
    }

    static AnnotationValue[] stringValueArray(String string, String string2) {
        return MockHelper.nullSafe(MockHelper.stringValue(string, string2));
    }

    private static AnnotationValue stringValue(String string, String string2) {
        if (StringHelper.isNotEmpty(string2)) {
            return AnnotationValue.createStringValue((String)string, (String)string2);
        }
        return null;
    }

    static void stringValue(String string, String string2, List<AnnotationValue> list) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.stringValue(string, string2));
    }

    private static AnnotationValue integerValue(String string, Integer n) {
        if (n == null) {
            return null;
        }
        return AnnotationValue.createIntegerValue((String)string, (int)n);
    }

    static void integerValue(String string, Integer n, List<AnnotationValue> list) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.integerValue(string, n));
    }

    static AnnotationValue[] booleanValueArray(String string, Boolean bl) {
        return MockHelper.nullSafe(MockHelper.booleanValue(string, bl));
    }

    static void booleanValue(String string, Boolean bl, List<AnnotationValue> list) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.booleanValue(string, bl));
    }

    private static AnnotationValue booleanValue(String string, Boolean bl) {
        if (bl == null) {
            return null;
        }
        return AnnotationValue.createBooleanValue((String)string, (boolean)bl);
    }

    private static AnnotationValue classValue(String string, String string2, ServiceRegistry serviceRegistry) {
        if (StringHelper.isNotEmpty(string2)) {
            return AnnotationValue.createClassValue((String)string, (Type)MockHelper.getType(string2, serviceRegistry));
        }
        return null;
    }

    static void classValue(String string, String string2, List<AnnotationValue> list, ServiceRegistry serviceRegistry) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.classValue(string, string2, serviceRegistry));
    }

    static AnnotationValue[] classValueArray(String string, String string2, ServiceRegistry serviceRegistry) {
        return MockHelper.nullSafe(MockHelper.classValue(string, string2, serviceRegistry));
    }

    static AnnotationValue nestedAnnotationValue(String string, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        return AnnotationValue.createNestedAnnotationValue((String)string, (AnnotationInstance)annotationInstance);
    }

    static void nestedAnnotationValue(String string, AnnotationInstance annotationInstance, List<AnnotationValue> list) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.nestedAnnotationValue(string, annotationInstance));
    }

    private static AnnotationValue[] nullSafe(AnnotationValue annotationValue) {
        AnnotationValue[] annotationValueArray;
        if (annotationValue == null) {
            annotationValueArray = EMPTY_ANNOTATION_VALUE_ARRAY;
        } else {
            AnnotationValue[] annotationValueArray2 = new AnnotationValue[1];
            annotationValueArray = annotationValueArray2;
            annotationValueArray2[0] = annotationValue;
        }
        return annotationValueArray;
    }

    static void classArrayValue(String string, List<String> list, List<AnnotationValue> list2, ServiceRegistry serviceRegistry) {
        if (MockHelper.isNotEmpty(list)) {
            ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>(list.size());
            for (String string2 : list) {
                MockHelper.addToCollectionIfNotNull(arrayList, MockHelper.classValue("", string2, serviceRegistry));
            }
            list2.add(AnnotationValue.createArrayValue((String)string, (AnnotationValue[])MockHelper.toArray(arrayList)));
        }
    }

    public static AnnotationValue[] toArray(List<AnnotationValue> list) {
        AnnotationValue[] annotationValueArray = EMPTY_ANNOTATION_VALUE_ARRAY;
        if (MockHelper.isNotEmpty(list)) {
            annotationValueArray = list.toArray(new AnnotationValue[list.size()]);
        }
        return annotationValueArray;
    }

    private static AnnotationValue enumValue(String string, DotName dotName, Enum enum_) {
        if (enum_ != null && StringHelper.isNotEmpty(enum_.toString())) {
            return AnnotationValue.createEnumValue((String)string, (DotName)dotName, (String)enum_.toString());
        }
        return null;
    }

    static void cascadeValue(String string, JaxbCascadeType jaxbCascadeType, boolean bl, List<AnnotationValue> list) {
        ArrayList<Enum> arrayList = new ArrayList<Enum>();
        if (bl) {
            arrayList.add(CascadeType.PERSIST);
        }
        if (jaxbCascadeType != null) {
            if (jaxbCascadeType.getCascadeAll() != null) {
                arrayList.add(CascadeType.ALL);
            }
            if (jaxbCascadeType.getCascadePersist() != null && !bl) {
                arrayList.add(CascadeType.PERSIST);
            }
            if (jaxbCascadeType.getCascadeMerge() != null) {
                arrayList.add(CascadeType.MERGE);
            }
            if (jaxbCascadeType.getCascadeRemove() != null) {
                arrayList.add(CascadeType.REMOVE);
            }
            if (jaxbCascadeType.getCascadeRefresh() != null) {
                arrayList.add(CascadeType.REFRESH);
            }
            if (jaxbCascadeType.getCascadeDetach() != null) {
                arrayList.add(CascadeType.DETACH);
            }
        }
        if (!arrayList.isEmpty()) {
            MockHelper.enumArrayValue(string, JPADotNames.CASCADE_TYPE, arrayList, list);
        }
    }

    static void enumArrayValue(String string, DotName dotName, List<Enum> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>(list.size());
            for (Enum enum_ : list) {
                MockHelper.addToCollectionIfNotNull(arrayList, MockHelper.enumValue("", dotName, enum_));
            }
            list2.add(AnnotationValue.createArrayValue((String)string, (AnnotationValue[])MockHelper.toArray(arrayList)));
        }
    }

    static void enumValue(String string, DotName dotName, Enum enum_, List<AnnotationValue> list) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.enumValue(string, dotName, enum_));
    }

    static AnnotationValue[] enumValueArray(String string, DotName dotName, Enum enum_) {
        return MockHelper.nullSafe(MockHelper.enumValue(string, dotName, enum_));
    }

    public static void addToCollectionIfNotNull(Collection collection, Object object) {
        if (object != null && collection != null) {
            collection.add(object);
        }
    }

    public static boolean targetEquals(AnnotationTarget annotationTarget, AnnotationTarget annotationTarget2) {
        if (annotationTarget == annotationTarget2) {
            return true;
        }
        if (annotationTarget != null && annotationTarget2 != null && annotationTarget.getClass() == annotationTarget2.getClass()) {
            if (annotationTarget.getClass() == ClassInfo.class) {
                return ((ClassInfo)annotationTarget).name().equals((Object)((ClassInfo)annotationTarget2).name());
            }
            if (annotationTarget.getClass() == MethodInfo.class) {
                return ((MethodInfo)annotationTarget).name().equals(((MethodInfo)annotationTarget2).name());
            }
            return ((FieldInfo)annotationTarget).name().equals(((FieldInfo)annotationTarget2).name());
        }
        return false;
    }

    public static boolean isNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    static AnnotationInstance create(DotName dotName, AnnotationTarget annotationTarget, List<AnnotationValue> list) {
        return MockHelper.create(dotName, annotationTarget, MockHelper.toArray(list));
    }

    static String buildSafeClassName(String string, String string2) {
        if (string.indexOf(46) < 0 && StringHelper.isNotEmpty(string2)) {
            string = StringHelper.qualify(string2, string);
        }
        return string;
    }

    static AnnotationInstance create(DotName dotName, AnnotationTarget annotationTarget, AnnotationValue[] annotationValueArray) {
        if (annotationValueArray == null || annotationValueArray.length == 0) {
            annotationValueArray = EMPTY_ANNOTATION_VALUE_ARRAY;
        }
        return AnnotationInstance.create((DotName)dotName, (AnnotationTarget)annotationTarget, (AnnotationValue[])MockHelper.addMockMark(annotationValueArray));
    }

    private static AnnotationValue[] addMockMark(AnnotationValue[] annotationValueArray) {
        AnnotationValue[] annotationValueArray2 = new AnnotationValue[annotationValueArray.length + 1];
        System.arraycopy(annotationValueArray, 0, annotationValueArray2, 0, annotationValueArray.length);
        annotationValueArray2[annotationValueArray.length] = MockHelper.booleanValue("isMocked", true);
        return annotationValueArray2;
    }

    private static MethodInfo getMethodInfo(ClassInfo classInfo, Method method) {
        Class<?> clazz = method.getReturnType();
        short s = (short)method.getModifiers();
        return MethodInfo.create((ClassInfo)classInfo, (String)method.getName(), (Type[])MockHelper.getTypes(method.getParameterTypes()), (Type)MockHelper.getType(clazz), (short)s);
    }

    static AnnotationTarget getTarget(ServiceRegistry serviceRegistry, ClassInfo classInfo, String string, TargetType targetType) {
        Class clazz = serviceRegistry.getService(ClassLoaderService.class).classForName(classInfo.toString());
        switch (targetType) {
            case FIELD: {
                Field field = MockHelper.getField(clazz, string);
                if (field == null) {
                    throw new HibernateException("Unable to load field " + string + " of class " + clazz.getName());
                }
                return FieldInfo.create((ClassInfo)classInfo, (String)string, (Type)MockHelper.getType(field.getType()), (short)((short)field.getModifiers()));
            }
            case METHOD: {
                Method method = MockHelper.getMethod(clazz, string);
                if (method == null) {
                    throw new HibernateException("Unable to load method " + string + " of class " + clazz.getName());
                }
                return MockHelper.getMethodInfo(classInfo, method);
            }
            case PROPERTY: {
                Method method = MockHelper.getterMethod(clazz, string);
                if (method == null) {
                    throw new HibernateException("Unable to load property " + string + " of class " + clazz.getName());
                }
                return MockHelper.getMethodInfo(classInfo, method);
            }
        }
        throw new HibernateException("");
    }

    private static Method getterMethod(Class clazz, String string) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredMethods();
        Method.setAccessible(accessibleObjectArray, true);
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            String string2;
            String string3;
            if (((Method)accessibleObject).getParameterTypes().length != 0 || ((Method)accessibleObject).isBridge()) continue;
            String string4 = ((Method)accessibleObject).getName();
            if (string4.startsWith("get") || string4.startsWith("has")) {
                string3 = Introspector.decapitalize(string4.substring(3));
                string2 = string4.substring(3);
                if (string3.equals(string) || string2.equals(string)) {
                    return accessibleObject;
                }
            }
            if (!string4.startsWith("is")) continue;
            string3 = Introspector.decapitalize(string4.substring(2));
            string2 = string4.substring(2);
            if (!string3.equals(string) && !string2.equals(string)) continue;
            return accessibleObject;
        }
        return null;
    }

    private static Method getMethod(Class clazz, String string) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredMethods();
        Method.setAccessible(accessibleObjectArray, true);
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            String string2;
            if (((Method)accessibleObject).getParameterTypes().length != 0 || ((Method)accessibleObject).isBridge() || !(string2 = ((Method)accessibleObject).getName()).equals(string)) continue;
            return accessibleObject;
        }
        return null;
    }

    private static Field getField(Class clazz, String string) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        Field.setAccessible(accessibleObjectArray, true);
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            if (!((Field)accessibleObject).getName().equals(string)) continue;
            return accessibleObject;
        }
        return null;
    }

    private static Type[] getTypes(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return EMPTY_TYPE_ARRAY;
        }
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = MockHelper.getType(classArray[i]);
        }
        return typeArray;
    }

    private static Type getType(String string, ServiceRegistry serviceRegistry) {
        return MockHelper.getType(serviceRegistry.getService(ClassLoaderService.class).classForName(string));
    }

    private static Type getType(Class clazz) {
        return Type.create((DotName)DotName.createSimple((String)clazz.getName()), (Type.Kind)MockHelper.getTypeKind(clazz));
    }

    private static Type.Kind getTypeKind(Class clazz) {
        Type.Kind kind = clazz == Void.TYPE ? Type.Kind.VOID : (clazz.isPrimitive() ? Type.Kind.PRIMITIVE : (clazz.isArray() ? Type.Kind.ARRAY : Type.Kind.CLASS));
        return kind;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TargetType {
        METHOD,
        FIELD,
        PROPERTY;

    }
}

