/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.xml.filter.IndexedAnnotationFilter;
import org.hibernate.metamodel.source.annotations.xml.mocker.DefaultConfigurationHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotations;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexBuilder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IndexBuilder.class.getName());
    private Map<DotName, List<AnnotationInstance>> annotations;
    private Map<DotName, List<ClassInfo>> subclasses;
    private Map<DotName, List<ClassInfo>> implementors;
    private Map<DotName, ClassInfo> classes;
    private Index index;
    private Map<DotName, Map<DotName, List<AnnotationInstance>>> classInfoAnnotationsMap;
    private Map<DotName, Map<DotName, List<AnnotationInstance>>> indexedClassInfoAnnotationsMap;
    private ServiceRegistry serviceRegistry;

    IndexBuilder(Index index, ServiceRegistry serviceRegistry) {
        this.index = index;
        this.serviceRegistry = serviceRegistry;
        this.annotations = new HashMap<DotName, List<AnnotationInstance>>();
        this.subclasses = new HashMap<DotName, List<ClassInfo>>();
        this.implementors = new HashMap<DotName, List<ClassInfo>>();
        this.classes = new HashMap<DotName, ClassInfo>();
        this.classInfoAnnotationsMap = new HashMap<DotName, Map<DotName, List<AnnotationInstance>>>();
        this.indexedClassInfoAnnotationsMap = new HashMap<DotName, Map<DotName, List<AnnotationInstance>>>();
    }

    Index build(EntityMappingsMocker.Default default_) {
        for (ClassInfo classInfo : this.index.getKnownClasses()) {
            DotName dotName = classInfo.name();
            if (this.indexedClassInfoAnnotationsMap.containsKey(dotName) || classInfo.annotations() == null || classInfo.annotations().isEmpty()) continue;
            HashMap<DotName, List<AnnotationInstance>> hashMap = new HashMap<DotName, List<AnnotationInstance>>(classInfo.annotations());
            DefaultConfigurationHelper.INSTANCE.applyDefaults(hashMap, default_);
            this.mergeAnnotationMap(hashMap, this.annotations);
            this.classes.put(dotName, classInfo);
            if (classInfo.superName() != null) {
                this.addSubClasses(classInfo.superName(), classInfo);
            }
            if (classInfo.interfaces() == null || classInfo.interfaces().length <= 0) continue;
            this.addImplementors(classInfo.interfaces(), classInfo);
        }
        return Index.create(this.annotations, this.subclasses, this.implementors, this.classes);
    }

    Map<DotName, List<AnnotationInstance>> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    void mappingMetadataComplete() {
        LOG.debug("xml-mapping-metadata-complete is specified in persistence-unit-metadata, ignore JPA annotations.");
        this.index = Index.create(new HashMap(), new HashMap(), new HashMap(), new HashMap());
    }

    void metadataComplete(DotName dotName) {
        LOG.debug("metadata-complete is specified in " + dotName + ", ignore JPA annotations.");
        this.getIndexedAnnotations(dotName).clear();
    }

    public Map<DotName, List<AnnotationInstance>> getIndexedAnnotations(DotName dotName) {
        Map<Object, List<Object>> map = this.indexedClassInfoAnnotationsMap.get(dotName);
        if (map == null) {
            ClassInfo classInfo = this.index.getClassByName(dotName);
            if (classInfo == null || classInfo.annotations() == null) {
                map = Collections.emptyMap();
            } else {
                map = new HashMap<DotName, List<AnnotationInstance>>(classInfo.annotations());
                for (DotName dotName2 : DefaultConfigurationHelper.GLOBAL_ANNOTATIONS) {
                    if (!map.containsKey(dotName2)) continue;
                    map.put(dotName2, Collections.emptyList());
                }
            }
            this.indexedClassInfoAnnotationsMap.put(dotName, map);
        }
        return map;
    }

    public Map<DotName, List<AnnotationInstance>> getClassInfoAnnotationsMap(DotName dotName) {
        return this.classInfoAnnotationsMap.get(dotName);
    }

    public ClassInfo getClassInfo(DotName dotName) {
        return this.classes.get(dotName);
    }

    public ClassInfo getIndexedClassInfo(DotName dotName) {
        return this.index.getClassByName(dotName);
    }

    void collectGlobalConfigurationFromIndex(GlobalAnnotations globalAnnotations) {
        for (DotName dotName : DefaultConfigurationHelper.GLOBAL_ANNOTATIONS) {
            List list = this.index.getAnnotations(dotName);
            if (!MockHelper.isNotEmpty(list)) continue;
            globalAnnotations.addIndexedAnnotationInstance(list);
        }
        globalAnnotations.filterIndexedAnnotations();
    }

    void finishGlobalConfigurationMocking(GlobalAnnotations globalAnnotations) {
        this.annotations.putAll(globalAnnotations.getAnnotationInstanceMap());
    }

    void finishEntityObject(DotName dotName, EntityMappingsMocker.Default default_) {
        Map<DotName, List<AnnotationInstance>> map = this.classInfoAnnotationsMap.get(dotName);
        if (map == null) {
            throw new AssertionFailure("Calling finish entity object " + dotName + " before create it.");
        }
        if (this.indexedClassInfoAnnotationsMap.containsKey(dotName)) {
            Map<DotName, List<AnnotationInstance>> map2 = this.getIndexedAnnotations(dotName);
            this.mergeAnnotationMap(map2, map);
        }
        DefaultConfigurationHelper.INSTANCE.applyDefaults(map, default_);
        this.mergeAnnotationMap(map, this.annotations);
    }

    void addAnnotationInstance(DotName dotName, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return;
        }
        for (IndexedAnnotationFilter indexedAnnotationFilter : IndexedAnnotationFilter.ALL_FILTERS) {
            indexedAnnotationFilter.beforePush(this, dotName, annotationInstance);
        }
        Map<DotName, List<AnnotationInstance>> map = this.classInfoAnnotationsMap.get(dotName);
        if (map == null) {
            throw new AssertionFailure("Can't find " + dotName + " in internal cache, should call createClassInfo first");
        }
        ArrayList<AnnotationInstance> arrayList = (ArrayList<AnnotationInstance>)map.get(annotationInstance.name());
        if (arrayList == null) {
            arrayList = new ArrayList<AnnotationInstance>();
            map.put(annotationInstance.name(), arrayList);
        }
        arrayList.add(annotationInstance);
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    ClassInfo createClassInfo(String string) {
        ClassInfo classInfo;
        Serializable serializable;
        short s;
        if (StringHelper.isEmpty(string)) {
            throw new AssertionFailure("Class Name used to create ClassInfo is empty.");
        }
        DotName dotName = DotName.createSimple((String)string);
        if (this.classes.containsKey(dotName)) {
            return this.classes.get(dotName);
        }
        Class clazz = this.serviceRegistry.getService(ClassLoaderService.class).classForName(string);
        DotName dotName2 = null;
        DotName[] dotNameArray = null;
        ClassInfo classInfo2 = this.index.getClassByName(dotName);
        if (classInfo2 != null) {
            dotName2 = classInfo2.superName();
            dotNameArray = classInfo2.interfaces();
            s = classInfo2.flags();
        } else {
            serializable = clazz.getSuperclass();
            if (serializable != null) {
                dotName2 = DotName.createSimple((String)serializable.getName());
            }
            if ((classInfo = clazz.getInterfaces()) != null && ((Class<?>[])classInfo).length > 0) {
                dotNameArray = new DotName[((Class<?>[])classInfo).length];
                for (int i = 0; i < ((Class<?>[])classInfo).length; ++i) {
                    dotNameArray[i] = DotName.createSimple((String)classInfo[i].getName());
                }
            }
            s = (short)(clazz.getModifiers() | 0x20);
        }
        serializable = new HashMap();
        this.classInfoAnnotationsMap.put(dotName, (Map<DotName, List<AnnotationInstance>>)((Object)serializable));
        classInfo = ClassInfo.create((DotName)dotName, (DotName)dotName2, (short)s, (DotName[])dotNameArray, serializable);
        this.classes.put(dotName, classInfo);
        this.addSubClasses(dotName2, classInfo);
        this.addImplementors(dotNameArray, classInfo);
        return classInfo;
    }

    private void addSubClasses(DotName dotName, ClassInfo classInfo) {
        if (dotName != null) {
            List<ClassInfo> list = this.subclasses.get(dotName);
            if (list == null) {
                list = new ArrayList<ClassInfo>();
                this.subclasses.put(dotName, list);
            }
            list.add(classInfo);
        }
    }

    private void addImplementors(DotName[] dotNameArray, ClassInfo classInfo) {
        if (dotNameArray != null && dotNameArray.length > 0) {
            for (DotName dotName : dotNameArray) {
                List<ClassInfo> list = this.implementors.get(dotName);
                if (list == null) {
                    list = new ArrayList<ClassInfo>();
                    this.implementors.put(dotName, list);
                }
                list.add(classInfo);
            }
        }
    }

    private void mergeAnnotationMap(Map<DotName, List<AnnotationInstance>> map, Map<DotName, List<AnnotationInstance>> map2) {
        if (map != null) {
            for (Map.Entry<DotName, List<AnnotationInstance>> entry : map.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                DotName dotName = entry.getKey();
                List<AnnotationInstance> list = entry.getValue();
                List<AnnotationInstance> list2 = map2.get(dotName);
                if (list2 == null) {
                    list2 = new ArrayList<AnnotationInstance>();
                    map2.put(dotName, list2);
                }
                list2.addAll(list);
            }
        }
    }
}

