/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAttributes;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntity;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntityMappings;
import org.hibernate.internal.jaxb.mapping.orm.JaxbId;
import org.hibernate.internal.jaxb.mapping.orm.JaxbNamedNativeQuery;
import org.hibernate.internal.jaxb.mapping.orm.JaxbNamedQuery;
import org.hibernate.internal.jaxb.mapping.orm.JaxbSequenceGenerator;
import org.hibernate.internal.jaxb.mapping.orm.JaxbSqlResultSetMapping;
import org.hibernate.internal.jaxb.mapping.orm.JaxbTableGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GlobalAnnotations
implements JPADotNames {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, GlobalAnnotations.class.getName());
    private Map<String, JaxbSequenceGenerator> sequenceGeneratorMap = new HashMap<String, JaxbSequenceGenerator>();
    private Map<String, JaxbTableGenerator> tableGeneratorMap = new HashMap<String, JaxbTableGenerator>();
    private Map<String, JaxbNamedQuery> namedQueryMap = new HashMap<String, JaxbNamedQuery>();
    private Map<String, JaxbNamedNativeQuery> namedNativeQueryMap = new HashMap<String, JaxbNamedNativeQuery>();
    private Map<String, JaxbSqlResultSetMapping> sqlResultSetMappingMap = new HashMap<String, JaxbSqlResultSetMapping>();
    private Map<DotName, List<AnnotationInstance>> annotationInstanceMap = new HashMap<DotName, List<AnnotationInstance>>();
    private List<AnnotationInstance> indexedAnnotationInstanceList = new ArrayList<AnnotationInstance>();
    private Set<String> defaultNamedNativeQueryNames = new HashSet<String>();
    private Set<String> defaultNamedQueryNames = new HashSet<String>();
    private Set<String> defaultNamedGenerators = new HashSet<String>();
    private Set<String> defaultSqlResultSetMappingNames = new HashSet<String>();

    GlobalAnnotations() {
    }

    Map<DotName, List<AnnotationInstance>> getAnnotationInstanceMap() {
        return this.annotationInstanceMap;
    }

    AnnotationInstance push(DotName dotName, AnnotationInstance annotationInstance) {
        if (dotName == null || annotationInstance == null) {
            return null;
        }
        List<AnnotationInstance> list = this.annotationInstanceMap.get(dotName);
        if (list == null) {
            list = new ArrayList<AnnotationInstance>();
            this.annotationInstanceMap.put(dotName, list);
        }
        list.add(annotationInstance);
        return annotationInstance;
    }

    void addIndexedAnnotationInstance(List<AnnotationInstance> list) {
        if (MockHelper.isNotEmpty(list)) {
            this.indexedAnnotationInstanceList.addAll(list);
        }
    }

    boolean hasGlobalConfiguration() {
        return !this.namedQueryMap.isEmpty() || !this.namedNativeQueryMap.isEmpty() || !this.sequenceGeneratorMap.isEmpty() || !this.tableGeneratorMap.isEmpty() || !this.sqlResultSetMappingMap.isEmpty();
    }

    Map<String, JaxbNamedNativeQuery> getNamedNativeQueryMap() {
        return this.namedNativeQueryMap;
    }

    Map<String, JaxbNamedQuery> getNamedQueryMap() {
        return this.namedQueryMap;
    }

    Map<String, JaxbSequenceGenerator> getSequenceGeneratorMap() {
        return this.sequenceGeneratorMap;
    }

    Map<String, JaxbSqlResultSetMapping> getSqlResultSetMappingMap() {
        return this.sqlResultSetMappingMap;
    }

    Map<String, JaxbTableGenerator> getTableGeneratorMap() {
        return this.tableGeneratorMap;
    }

    public void filterIndexedAnnotations() {
        for (AnnotationInstance annotationInstance : this.indexedAnnotationInstanceList) {
            this.pushIfNotExist(annotationInstance);
        }
    }

    private void pushIfNotExist(AnnotationInstance annotationInstance) {
        DotName dotName = annotationInstance.name();
        boolean bl = false;
        if (dotName.equals((Object)SQL_RESULT_SET_MAPPINGS)) {
            AnnotationInstance[] annotationInstanceArray;
            for (AnnotationInstance annotationInstance2 : annotationInstanceArray = annotationInstance.value().asNestedArray()) {
                this.pushIfNotExist(annotationInstance2);
            }
        } else {
            AnnotationValue annotationValue = annotationInstance.value("name");
            String string = annotationValue.asString();
            boolean bl2 = bl = dotName.equals((Object)TABLE_GENERATOR) && !this.tableGeneratorMap.containsKey(string) || dotName.equals((Object)SEQUENCE_GENERATOR) && !this.sequenceGeneratorMap.containsKey(string) || dotName.equals((Object)NAMED_QUERY) && !this.namedQueryMap.containsKey(string) || dotName.equals((Object)NAMED_NATIVE_QUERY) && !this.namedNativeQueryMap.containsKey(string) || dotName.equals((Object)SQL_RESULT_SET_MAPPING) && !this.sqlResultSetMappingMap.containsKey(string);
        }
        if (bl) {
            this.push(dotName, annotationInstance);
        }
    }

    void collectGlobalMappings(JaxbEntityMappings jaxbEntityMappings, EntityMappingsMocker.Default default_) {
        for (JaxbSequenceGenerator object : jaxbEntityMappings.getSequenceGenerator()) {
            this.put(object, default_);
            this.defaultNamedGenerators.add(object.getName());
        }
        for (JaxbTableGenerator jaxbTableGenerator : jaxbEntityMappings.getTableGenerator()) {
            this.put(jaxbTableGenerator, default_);
            this.defaultNamedGenerators.add(jaxbTableGenerator.getName());
        }
        for (JaxbNamedQuery jaxbNamedQuery : jaxbEntityMappings.getNamedQuery()) {
            this.put(jaxbNamedQuery);
            this.defaultNamedQueryNames.add(jaxbNamedQuery.getName());
        }
        for (JaxbNamedNativeQuery jaxbNamedNativeQuery : jaxbEntityMappings.getNamedNativeQuery()) {
            this.put(jaxbNamedNativeQuery);
            this.defaultNamedNativeQueryNames.add(jaxbNamedNativeQuery.getName());
        }
        for (JaxbSqlResultSetMapping jaxbSqlResultSetMapping : jaxbEntityMappings.getSqlResultSetMapping()) {
            this.put(jaxbSqlResultSetMapping);
            this.defaultSqlResultSetMappingNames.add(jaxbSqlResultSetMapping.getName());
        }
    }

    void collectGlobalMappings(JaxbEntity jaxbEntity, EntityMappingsMocker.Default default_) {
        JaxbAttributes jaxbAttributes;
        JaxbTableGenerator jaxbTableGenerator;
        for (JaxbNamedQuery object2 : jaxbEntity.getNamedQuery()) {
            if (!this.defaultNamedQueryNames.contains(object2.getName())) {
                this.put(object2);
                continue;
            }
            LOG.warn("Named Query [" + object2.getName() + "] duplicated.");
        }
        for (JaxbNamedNativeQuery jaxbNamedNativeQuery : jaxbEntity.getNamedNativeQuery()) {
            if (!this.defaultNamedNativeQueryNames.contains(jaxbNamedNativeQuery.getName())) {
                this.put(jaxbNamedNativeQuery);
                continue;
            }
            LOG.warn("Named native Query [" + jaxbNamedNativeQuery.getName() + "] duplicated.");
        }
        for (JaxbSqlResultSetMapping jaxbSqlResultSetMapping : jaxbEntity.getSqlResultSetMapping()) {
            if (this.defaultSqlResultSetMappingNames.contains(jaxbSqlResultSetMapping.getName())) continue;
            this.put(jaxbSqlResultSetMapping);
        }
        Object object3 = jaxbEntity.getSequenceGenerator();
        if (object3 != null && !this.defaultNamedGenerators.contains(((JaxbSequenceGenerator)object3).getName())) {
            this.put((JaxbSequenceGenerator)object3, default_);
        }
        if ((jaxbTableGenerator = jaxbEntity.getTableGenerator()) != null && !this.defaultNamedGenerators.contains(jaxbTableGenerator.getName())) {
            this.put(jaxbTableGenerator, default_);
        }
        if ((jaxbAttributes = jaxbEntity.getAttributes()) != null) {
            for (JaxbId jaxbId : jaxbAttributes.getId()) {
                JaxbTableGenerator jaxbTableGenerator2;
                object3 = jaxbId.getSequenceGenerator();
                if (object3 != null) {
                    this.put((JaxbSequenceGenerator)object3, default_);
                }
                if ((jaxbTableGenerator2 = jaxbId.getTableGenerator()) == null) continue;
                this.put(jaxbTableGenerator2, default_);
            }
        }
    }

    private static JaxbSequenceGenerator overrideGenerator(JaxbSequenceGenerator jaxbSequenceGenerator, EntityMappingsMocker.Default default_) {
        if (StringHelper.isEmpty(jaxbSequenceGenerator.getSchema()) && default_ != null) {
            jaxbSequenceGenerator.setSchema(default_.getSchema());
        }
        if (StringHelper.isEmpty(jaxbSequenceGenerator.getCatalog()) && default_ != null) {
            jaxbSequenceGenerator.setCatalog(default_.getCatalog());
        }
        return jaxbSequenceGenerator;
    }

    private static JaxbTableGenerator overrideGenerator(JaxbTableGenerator jaxbTableGenerator, EntityMappingsMocker.Default default_) {
        if (StringHelper.isEmpty(jaxbTableGenerator.getSchema()) && default_ != null) {
            jaxbTableGenerator.setSchema(default_.getSchema());
        }
        if (StringHelper.isEmpty(jaxbTableGenerator.getCatalog()) && default_ != null) {
            jaxbTableGenerator.setCatalog(default_.getCatalog());
        }
        return jaxbTableGenerator;
    }

    private void put(JaxbNamedNativeQuery jaxbNamedNativeQuery) {
        if (jaxbNamedNativeQuery != null) {
            this.checkQueryName(jaxbNamedNativeQuery.getName());
            this.namedNativeQueryMap.put(jaxbNamedNativeQuery.getName(), jaxbNamedNativeQuery);
        }
    }

    private void checkQueryName(String string) {
        if (this.namedQueryMap.containsKey(string) || this.namedNativeQueryMap.containsKey(string)) {
            throw new MappingException("Duplicated query mapping " + string, null);
        }
    }

    private void put(JaxbNamedQuery jaxbNamedQuery) {
        if (jaxbNamedQuery != null) {
            this.checkQueryName(jaxbNamedQuery.getName());
            this.namedQueryMap.put(jaxbNamedQuery.getName(), jaxbNamedQuery);
        }
    }

    private void put(JaxbSequenceGenerator jaxbSequenceGenerator, EntityMappingsMocker.Default default_) {
        JaxbSequenceGenerator jaxbSequenceGenerator2;
        if (jaxbSequenceGenerator != null && (jaxbSequenceGenerator2 = this.sequenceGeneratorMap.put(jaxbSequenceGenerator.getName(), GlobalAnnotations.overrideGenerator(jaxbSequenceGenerator, default_))) != null) {
            LOG.duplicateGeneratorName(jaxbSequenceGenerator.getName());
        }
    }

    private void put(JaxbTableGenerator jaxbTableGenerator, EntityMappingsMocker.Default default_) {
        JaxbTableGenerator jaxbTableGenerator2;
        if (jaxbTableGenerator != null && (jaxbTableGenerator2 = this.tableGeneratorMap.put(jaxbTableGenerator.getName(), GlobalAnnotations.overrideGenerator(jaxbTableGenerator, default_))) != null) {
            LOG.duplicateGeneratorName(jaxbTableGenerator.getName());
        }
    }

    private void put(JaxbSqlResultSetMapping jaxbSqlResultSetMapping) {
        JaxbSqlResultSetMapping jaxbSqlResultSetMapping2;
        if (jaxbSqlResultSetMapping != null && (jaxbSqlResultSetMapping2 = this.sqlResultSetMappingMap.put(jaxbSqlResultSetMapping.getName(), jaxbSqlResultSetMapping)) != null) {
            throw new MappingException("Duplicated SQL result set mapping " + jaxbSqlResultSetMapping.getName(), null);
        }
    }
}

