/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.internal.jaxb.mapping.orm.JaxbColumnResult;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntityResult;
import org.hibernate.internal.jaxb.mapping.orm.JaxbFieldResult;
import org.hibernate.internal.jaxb.mapping.orm.JaxbNamedNativeQuery;
import org.hibernate.internal.jaxb.mapping.orm.JaxbNamedQuery;
import org.hibernate.internal.jaxb.mapping.orm.JaxbQueryHint;
import org.hibernate.internal.jaxb.mapping.orm.JaxbSequenceGenerator;
import org.hibernate.internal.jaxb.mapping.orm.JaxbSqlResultSetMapping;
import org.hibernate.internal.jaxb.mapping.orm.JaxbTableGenerator;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotations;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GlobalAnnotationMocker
extends AbstractMocker {
    private GlobalAnnotations globalAnnotations;

    GlobalAnnotationMocker(IndexBuilder indexBuilder, GlobalAnnotations globalAnnotations) {
        super(indexBuilder);
        this.globalAnnotations = globalAnnotations;
    }

    void process() {
        Collection<Object> collection;
        if (!this.globalAnnotations.getTableGeneratorMap().isEmpty()) {
            for (JaxbTableGenerator object : this.globalAnnotations.getTableGeneratorMap().values()) {
                this.parserTableGenerator(object);
            }
        }
        if (!this.globalAnnotations.getSequenceGeneratorMap().isEmpty()) {
            for (JaxbSequenceGenerator jaxbSequenceGenerator : this.globalAnnotations.getSequenceGeneratorMap().values()) {
                this.parserSequenceGenerator(jaxbSequenceGenerator);
            }
        }
        if (!this.globalAnnotations.getNamedQueryMap().isEmpty()) {
            collection = this.globalAnnotations.getNamedQueryMap().values();
            if (collection.size() > 1) {
                this.parserNamedQueries(collection);
            } else {
                this.parserNamedQuery((JaxbNamedQuery)((Object)collection.iterator().next()));
            }
        }
        if (!this.globalAnnotations.getNamedNativeQueryMap().isEmpty()) {
            collection = this.globalAnnotations.getNamedNativeQueryMap().values();
            if (collection.size() > 1) {
                this.parserNamedNativeQueries(collection);
            } else {
                this.parserNamedNativeQuery(collection.iterator().next());
            }
        }
        if (!this.globalAnnotations.getSqlResultSetMappingMap().isEmpty()) {
            this.parserSqlResultSetMappings(this.globalAnnotations.getSqlResultSetMappingMap().values());
        }
        this.indexBuilder.finishGlobalConfigurationMocking(this.globalAnnotations);
    }

    private AnnotationInstance parserSqlResultSetMappings(Collection<JaxbSqlResultSetMapping> collection) {
        AnnotationValue[] annotationValueArray = new AnnotationValue[collection.size()];
        int n = 0;
        Iterator<JaxbSqlResultSetMapping> iterator = collection.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserSqlResultSetMapping(iterator.next());
            annotationValueArray[n++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(SQL_RESULT_SET_MAPPINGS, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])annotationValueArray)});
    }

    private AnnotationInstance parserSqlResultSetMapping(JaxbSqlResultSetMapping jaxbSqlResultSetMapping) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbSqlResultSetMapping.getName(), arrayList);
        this.nestedEntityResultList("entities", jaxbSqlResultSetMapping.getEntityResult(), arrayList);
        this.nestedColumnResultList("columns", jaxbSqlResultSetMapping.getColumnResult(), arrayList);
        return this.create(SQL_RESULT_SET_MAPPING, null, arrayList);
    }

    private AnnotationInstance parserEntityResult(JaxbEntityResult jaxbEntityResult) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("discriminatorColumn", jaxbEntityResult.getDiscriminatorColumn(), arrayList);
        this.nestedFieldResultList("fields", jaxbEntityResult.getFieldResult(), arrayList);
        MockHelper.classValue("entityClass", jaxbEntityResult.getEntityClass(), arrayList, this.indexBuilder.getServiceRegistry());
        return this.create(ENTITY_RESULT, null, arrayList);
    }

    private void nestedEntityResultList(String string, List<JaxbEntityResult> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserEntityResult(list.get(i));
                annotationValueArray[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(list2, AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
        }
    }

    private AnnotationInstance parserColumnResult(JaxbColumnResult jaxbColumnResult) {
        return this.create(COLUMN_RESULT, null, MockHelper.stringValueArray("name", jaxbColumnResult.getName()));
    }

    private void nestedColumnResultList(String string, List<JaxbColumnResult> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserColumnResult(list.get(i));
                annotationValueArray[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(list2, AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
        }
    }

    private AnnotationInstance parserFieldResult(JaxbFieldResult jaxbFieldResult) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbFieldResult.getName(), arrayList);
        MockHelper.stringValue("column", jaxbFieldResult.getColumn(), arrayList);
        return this.create(FIELD_RESULT, null, arrayList);
    }

    private void nestedFieldResultList(String string, List<JaxbFieldResult> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserFieldResult(list.get(i));
                annotationValueArray[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(list2, AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
        }
    }

    private AnnotationInstance parserNamedNativeQueries(Collection<JaxbNamedNativeQuery> collection) {
        AnnotationValue[] annotationValueArray = new AnnotationValue[collection.size()];
        int n = 0;
        Iterator<JaxbNamedNativeQuery> iterator = collection.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserNamedNativeQuery(iterator.next());
            annotationValueArray[n++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(NAMED_NATIVE_QUERIES, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])annotationValueArray)});
    }

    private AnnotationInstance parserNamedNativeQuery(JaxbNamedNativeQuery jaxbNamedNativeQuery) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbNamedNativeQuery.getName(), arrayList);
        MockHelper.stringValue("query", jaxbNamedNativeQuery.getQuery(), arrayList);
        MockHelper.stringValue("resultSetMapping", jaxbNamedNativeQuery.getResultSetMapping(), arrayList);
        MockHelper.classValue("resultClass", jaxbNamedNativeQuery.getResultClass(), arrayList, this.indexBuilder.getServiceRegistry());
        this.nestedQueryHintList("hints", jaxbNamedNativeQuery.getHint(), arrayList);
        return this.create(NAMED_NATIVE_QUERY, null, arrayList);
    }

    private AnnotationInstance parserNamedQueries(Collection<JaxbNamedQuery> collection) {
        AnnotationValue[] annotationValueArray = new AnnotationValue[collection.size()];
        int n = 0;
        Iterator<JaxbNamedQuery> iterator = collection.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserNamedQuery(iterator.next());
            annotationValueArray[n++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(NAMED_QUERIES, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])annotationValueArray)});
    }

    private AnnotationInstance parserNamedQuery(JaxbNamedQuery jaxbNamedQuery) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbNamedQuery.getName(), arrayList);
        MockHelper.stringValue("query", jaxbNamedQuery.getQuery(), arrayList);
        MockHelper.enumValue("lockMode", LOCK_MODE_TYPE, jaxbNamedQuery.getLockMode(), arrayList);
        this.nestedQueryHintList("hints", jaxbNamedQuery.getHint(), arrayList);
        return this.create(NAMED_QUERY, null, arrayList);
    }

    private AnnotationInstance parserQueryHint(JaxbQueryHint jaxbQueryHint) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbQueryHint.getName(), arrayList);
        MockHelper.stringValue("value", jaxbQueryHint.getValue(), arrayList);
        return this.create(QUERY_HINT, null, arrayList);
    }

    private void nestedQueryHintList(String string, List<JaxbQueryHint> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserQueryHint(list.get(i));
                annotationValueArray[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(list2, AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
        }
    }

    private AnnotationInstance parserSequenceGenerator(JaxbSequenceGenerator jaxbSequenceGenerator) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbSequenceGenerator.getName(), arrayList);
        MockHelper.stringValue("catalog", jaxbSequenceGenerator.getCatalog(), arrayList);
        MockHelper.stringValue("schema", jaxbSequenceGenerator.getSchema(), arrayList);
        MockHelper.stringValue("sequenceName", jaxbSequenceGenerator.getSequenceName(), arrayList);
        MockHelper.integerValue("initialValue", jaxbSequenceGenerator.getInitialValue(), arrayList);
        MockHelper.integerValue("allocationSize", jaxbSequenceGenerator.getAllocationSize(), arrayList);
        return this.create(SEQUENCE_GENERATOR, null, arrayList);
    }

    private AnnotationInstance parserTableGenerator(JaxbTableGenerator jaxbTableGenerator) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbTableGenerator.getName(), arrayList);
        MockHelper.stringValue("catalog", jaxbTableGenerator.getCatalog(), arrayList);
        MockHelper.stringValue("schema", jaxbTableGenerator.getSchema(), arrayList);
        MockHelper.stringValue("table", jaxbTableGenerator.getTable(), arrayList);
        MockHelper.stringValue("pkColumnName", jaxbTableGenerator.getPkColumnName(), arrayList);
        MockHelper.stringValue("valueColumnName", jaxbTableGenerator.getValueColumnName(), arrayList);
        MockHelper.stringValue("pkColumnValue", jaxbTableGenerator.getPkColumnValue(), arrayList);
        MockHelper.integerValue("initialValue", jaxbTableGenerator.getInitialValue(), arrayList);
        MockHelper.integerValue("allocationSize", jaxbTableGenerator.getAllocationSize(), arrayList);
        this.nestedUniqueConstraintList("uniqueConstraints", jaxbTableGenerator.getUniqueConstraint(), arrayList);
        return this.create(TABLE_GENERATOR, null, arrayList);
    }

    @Override
    protected AnnotationInstance push(AnnotationInstance annotationInstance) {
        if (annotationInstance != null) {
            return this.globalAnnotations.push(annotationInstance.name(), annotationInstance);
        }
        return null;
    }
}

