/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.AccessType;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAccessType;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAttributes;
import org.hibernate.internal.jaxb.mapping.orm.JaxbDiscriminatorColumn;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntity;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntityListeners;
import org.hibernate.internal.jaxb.mapping.orm.JaxbIdClass;
import org.hibernate.internal.jaxb.mapping.orm.JaxbInheritance;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPostLoad;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPostPersist;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPostRemove;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPostUpdate;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPrePersist;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPreRemove;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPreUpdate;
import org.hibernate.internal.jaxb.mapping.orm.JaxbSecondaryTable;
import org.hibernate.internal.jaxb.mapping.orm.JaxbTable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractEntityObjectMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.DefaultConfigurationHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.SchemaAware;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityMocker
extends AbstractEntityObjectMocker {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, EntityMocker.class.getName());
    private JaxbEntity entity;

    EntityMocker(IndexBuilder indexBuilder, JaxbEntity jaxbEntity, EntityMappingsMocker.Default default_) {
        super(indexBuilder, default_);
        this.entity = jaxbEntity;
    }

    @Override
    protected String getClassName() {
        return this.entity.getClazz();
    }

    @Override
    protected void processExtra() {
        this.create(ENTITY, MockHelper.stringValueArray("name", this.entity.getName()));
        if (this.entity.isCacheable() != null) {
            this.create(CACHEABLE, MockHelper.booleanValueArray("value", this.entity.isCacheable()));
        }
        if (StringHelper.isNotEmpty(this.entity.getDiscriminatorValue())) {
            this.create(DISCRIMINATOR_VALUE, MockHelper.stringValueArray("value", this.entity.getDiscriminatorValue()));
        }
        this.parserTable(this.entity.getTable());
        this.parserInheritance(this.entity.getInheritance());
        this.parserDiscriminatorColumn(this.entity.getDiscriminatorColumn());
        this.parserAttributeOverrides(this.entity.getAttributeOverride(), this.getTarget());
        this.parserAssociationOverrides(this.entity.getAssociationOverride(), this.getTarget());
        this.parserPrimaryKeyJoinColumnList(this.entity.getPrimaryKeyJoinColumn(), this.getTarget());
        this.parserSecondaryTableList(this.entity.getSecondaryTable(), this.getTarget());
    }

    private AnnotationInstance parserTable(JaxbTable jaxbTable) {
        if (jaxbTable == null) {
            return null;
        }
        DefaultConfigurationHelper.INSTANCE.applyDefaults(new SchemaAware.TableSchemaAware(jaxbTable), this.getDefaults());
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbTable.getName(), arrayList);
        MockHelper.stringValue("catalog", jaxbTable.getCatalog(), arrayList);
        MockHelper.stringValue("schema", jaxbTable.getSchema(), arrayList);
        this.nestedUniqueConstraintList("uniqueConstraints", jaxbTable.getUniqueConstraint(), arrayList);
        return this.create(TABLE, arrayList);
    }

    protected AccessType getDefaultAccess() {
        if (this.entity.getAccess() != null) {
            return AccessType.valueOf(this.entity.getAccess().value());
        }
        return null;
    }

    protected AccessType getAccessFromIndex(DotName dotName) {
        Map<DotName, List<AnnotationInstance>> map = this.indexBuilder.getIndexedAnnotations(dotName);
        List<AnnotationInstance> list = map.get(ACCESS);
        if (MockHelper.isNotEmpty(list)) {
            for (AnnotationInstance annotationInstance : list) {
                ClassInfo classInfo;
                if (annotationInstance.target() == null || !(annotationInstance.target() instanceof ClassInfo) || !dotName.equals((Object)(classInfo = (ClassInfo)annotationInstance.target()).name())) continue;
                return AccessType.valueOf(annotationInstance.value().asEnum());
            }
        }
        return null;
    }

    @Override
    protected void applyDefaults() {
        DefaultConfigurationHelper.INSTANCE.applyDefaults(this.entity, this.getDefaults());
    }

    @Override
    protected JaxbPrePersist getPrePersist() {
        return this.entity.getPrePersist();
    }

    @Override
    protected JaxbPreRemove getPreRemove() {
        return this.entity.getPreRemove();
    }

    @Override
    protected JaxbPreUpdate getPreUpdate() {
        return this.entity.getPreUpdate();
    }

    @Override
    protected JaxbPostPersist getPostPersist() {
        return this.entity.getPostPersist();
    }

    @Override
    protected JaxbPostUpdate getPostUpdate() {
        return this.entity.getPostUpdate();
    }

    @Override
    protected JaxbPostRemove getPostRemove() {
        return this.entity.getPostRemove();
    }

    @Override
    protected JaxbPostLoad getPostLoad() {
        return this.entity.getPostLoad();
    }

    @Override
    protected JaxbAttributes getAttributes() {
        return this.entity.getAttributes();
    }

    @Override
    protected boolean isMetadataComplete() {
        return this.entity.isMetadataComplete() != null && this.entity.isMetadataComplete() != false;
    }

    @Override
    protected boolean isExcludeDefaultListeners() {
        return this.entity.getExcludeDefaultListeners() != null;
    }

    @Override
    protected boolean isExcludeSuperclassListeners() {
        return this.entity.getExcludeSuperclassListeners() != null;
    }

    @Override
    protected JaxbIdClass getIdClass() {
        return this.entity.getIdClass();
    }

    @Override
    protected JaxbEntityListeners getEntityListeners() {
        return this.entity.getEntityListeners();
    }

    @Override
    protected JaxbAccessType getAccessType() {
        return this.entity.getAccess();
    }

    protected AnnotationInstance parserInheritance(JaxbInheritance jaxbInheritance) {
        if (jaxbInheritance == null) {
            return null;
        }
        return this.create(INHERITANCE, MockHelper.enumValueArray("strategy", INHERITANCE_TYPE, jaxbInheritance.getStrategy()));
    }

    protected AnnotationInstance parserDiscriminatorColumn(JaxbDiscriminatorColumn jaxbDiscriminatorColumn) {
        if (jaxbDiscriminatorColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbDiscriminatorColumn.getName(), arrayList);
        MockHelper.stringValue("columnDefinition", jaxbDiscriminatorColumn.getColumnDefinition(), arrayList);
        MockHelper.integerValue("length", jaxbDiscriminatorColumn.getLength(), arrayList);
        MockHelper.enumValue("discriminatorType", DISCRIMINATOR_TYPE, jaxbDiscriminatorColumn.getDiscriminatorType(), arrayList);
        return this.create(DISCRIMINATOR_COLUMN, arrayList);
    }

    protected AnnotationInstance parserSecondaryTable(JaxbSecondaryTable jaxbSecondaryTable, AnnotationTarget annotationTarget) {
        if (jaxbSecondaryTable == null) {
            return null;
        }
        DefaultConfigurationHelper.INSTANCE.applyDefaults(new SchemaAware.SecondaryTableSchemaAware(jaxbSecondaryTable), this.getDefaults());
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbSecondaryTable.getName(), arrayList);
        MockHelper.stringValue("catalog", jaxbSecondaryTable.getCatalog(), arrayList);
        MockHelper.stringValue("schema", jaxbSecondaryTable.getSchema(), arrayList);
        this.nestedPrimaryKeyJoinColumnList("pkJoinColumns", jaxbSecondaryTable.getPrimaryKeyJoinColumn(), arrayList);
        this.nestedUniqueConstraintList("uniqueConstraints", jaxbSecondaryTable.getUniqueConstraint(), arrayList);
        return this.create(SECONDARY_TABLE, annotationTarget, arrayList);
    }

    protected AnnotationInstance parserSecondaryTableList(List<JaxbSecondaryTable> list, AnnotationTarget annotationTarget) {
        if (MockHelper.isNotEmpty(list)) {
            if (list.size() == 1) {
                return this.parserSecondaryTable(list.get(0), annotationTarget);
            }
            return this.create(SECONDARY_TABLES, annotationTarget, this.nestedSecondaryTableList("value", list, null));
        }
        return null;
    }

    protected AnnotationValue[] nestedSecondaryTableList(String string, List<JaxbSecondaryTable> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserSecondaryTable(list.get(i), null);
                annotationValueArray[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(list2, AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
            return annotationValueArray;
        }
        return MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY;
    }
}

