/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAccessType;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEmbeddable;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntity;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntityMappings;
import org.hibernate.internal.jaxb.mapping.orm.JaxbMappedSuperclass;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPersistenceUnitDefaults;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPersistenceUnitMetadata;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractEntityObjectMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.EmbeddableMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotationMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotations;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MappedSuperclassMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.PersistenceMetadataMocker;
import org.hibernate.service.ServiceRegistry;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMappingsMocker {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, EntityMappingsMocker.class.getName());
    private final List<JaxbEntityMappings> entityMappingsList;
    private Default globalDefaults;
    private final IndexBuilder indexBuilder;
    private final GlobalAnnotations globalAnnotations;

    public EntityMappingsMocker(List<JaxbEntityMappings> list, Index index, ServiceRegistry serviceRegistry) {
        this.entityMappingsList = list;
        this.indexBuilder = new IndexBuilder(index, serviceRegistry);
        this.globalAnnotations = new GlobalAnnotations();
    }

    public Index mockNewIndex() {
        this.processPersistenceUnitMetadata(this.entityMappingsList);
        this.processEntityMappings(this.entityMappingsList);
        this.processGlobalAnnotations();
        return this.indexBuilder.build(this.globalDefaults);
    }

    private void processPersistenceUnitMetadata(List<JaxbEntityMappings> list) {
        for (JaxbEntityMappings jaxbEntityMappings : list) {
            JaxbPersistenceUnitDefaults jaxbPersistenceUnitDefaults;
            JaxbPersistenceUnitMetadata jaxbPersistenceUnitMetadata = jaxbEntityMappings.getPersistenceUnitMetadata();
            if (this.globalDefaults != null) {
                LOG.duplicateMetadata();
                return;
            }
            if (jaxbPersistenceUnitMetadata == null) continue;
            this.globalDefaults = new Default();
            if (jaxbPersistenceUnitMetadata.getXmlMappingMetadataComplete() != null) {
                this.globalDefaults.setMetadataComplete(true);
                this.indexBuilder.mappingMetadataComplete();
            }
            if ((jaxbPersistenceUnitDefaults = jaxbPersistenceUnitMetadata.getPersistenceUnitDefaults()) == null) {
                return;
            }
            this.globalDefaults.setSchema(jaxbPersistenceUnitDefaults.getSchema());
            this.globalDefaults.setCatalog(jaxbPersistenceUnitDefaults.getCatalog());
            this.globalDefaults.setCascadePersist(jaxbPersistenceUnitDefaults.getCascadePersist() != null);
            new PersistenceMetadataMocker(this.indexBuilder, jaxbPersistenceUnitDefaults).process();
        }
    }

    private void processEntityMappings(List<JaxbEntityMappings> list) {
        ArrayList<AbstractEntityObjectMocker> arrayList = new ArrayList<AbstractEntityObjectMocker>();
        for (JaxbEntityMappings object : list) {
            AbstractEntityObjectMocker abstractEntityObjectMocker;
            Default default_ = this.getEntityMappingsDefaults(object);
            this.globalAnnotations.collectGlobalMappings(object, default_);
            for (JaxbMappedSuperclass jaxbMappedSuperclass : object.getMappedSuperclass()) {
                abstractEntityObjectMocker = new MappedSuperclassMocker(this.indexBuilder, jaxbMappedSuperclass, default_);
                arrayList.add(abstractEntityObjectMocker);
                abstractEntityObjectMocker.preProcess();
            }
            for (JaxbEmbeddable jaxbEmbeddable : object.getEmbeddable()) {
                abstractEntityObjectMocker = new EmbeddableMocker(this.indexBuilder, jaxbEmbeddable, default_);
                arrayList.add(abstractEntityObjectMocker);
                abstractEntityObjectMocker.preProcess();
            }
            for (JaxbEntity jaxbEntity : object.getEntity()) {
                this.globalAnnotations.collectGlobalMappings(jaxbEntity, default_);
                abstractEntityObjectMocker = new EntityMocker(this.indexBuilder, jaxbEntity, default_);
                arrayList.add(abstractEntityObjectMocker);
                abstractEntityObjectMocker.preProcess();
            }
        }
        for (AbstractEntityObjectMocker abstractEntityObjectMocker : arrayList) {
            abstractEntityObjectMocker.process();
        }
    }

    private void processGlobalAnnotations() {
        if (this.globalAnnotations.hasGlobalConfiguration()) {
            this.indexBuilder.collectGlobalConfigurationFromIndex(this.globalAnnotations);
            new GlobalAnnotationMocker(this.indexBuilder, this.globalAnnotations).process();
        }
    }

    private Default getEntityMappingsDefaults(JaxbEntityMappings jaxbEntityMappings) {
        Default default_ = new Default();
        default_.setPackageName(jaxbEntityMappings.getPackage());
        default_.setSchema(jaxbEntityMappings.getSchema());
        default_.setCatalog(jaxbEntityMappings.getCatalog());
        default_.setAccess(jaxbEntityMappings.getAccess());
        Default default_2 = new Default();
        default_2.override(this.globalDefaults);
        default_2.override(default_);
        return default_2;
    }

    public static class Default
    implements Serializable {
        private JaxbAccessType access;
        private String packageName;
        private String schema;
        private String catalog;
        private Boolean metadataComplete;
        private Boolean cascadePersist;

        public JaxbAccessType getAccess() {
            return this.access;
        }

        void setAccess(JaxbAccessType jaxbAccessType) {
            this.access = jaxbAccessType;
        }

        public String getCatalog() {
            return this.catalog;
        }

        void setCatalog(String string) {
            this.catalog = string;
        }

        public String getPackageName() {
            return this.packageName;
        }

        void setPackageName(String string) {
            this.packageName = string;
        }

        public String getSchema() {
            return this.schema;
        }

        void setSchema(String string) {
            this.schema = string;
        }

        public Boolean isMetadataComplete() {
            return this.metadataComplete;
        }

        void setMetadataComplete(Boolean bl) {
            this.metadataComplete = bl;
        }

        public Boolean isCascadePersist() {
            return this.cascadePersist;
        }

        void setCascadePersist(Boolean bl) {
            this.cascadePersist = bl;
        }

        void override(Default default_) {
            if (default_ != null) {
                if (default_.getAccess() != null) {
                    this.access = default_.getAccess();
                }
                if (default_.getPackageName() != null) {
                    this.packageName = default_.getPackageName();
                }
                if (default_.getSchema() != null) {
                    this.schema = default_.getSchema();
                }
                if (default_.getCatalog() != null) {
                    this.catalog = default_.getCatalog();
                }
                if (default_.isCascadePersist() != null) {
                    this.cascadePersist = default_.isCascadePersist();
                }
                if (default_.isMetadataComplete() != null) {
                    this.metadataComplete = default_.isMetadataComplete();
                }
            }
        }
    }
}

