/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEmbeddable;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntity;
import org.hibernate.internal.jaxb.mapping.orm.JaxbMappedSuperclass;
import org.hibernate.internal.jaxb.mapping.orm.JaxbTable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.xml.filter.IndexedAnnotationFilter;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.SchemaAware;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultConfigurationHelper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultConfigurationHelper.class.getName());
    static final DefaultConfigurationHelper INSTANCE = new DefaultConfigurationHelper();
    static final DotName[] GLOBAL_ANNOTATIONS = new DotName[]{JPADotNames.SEQUENCE_GENERATOR, JPADotNames.TABLE_GENERATOR, JPADotNames.NAMED_QUERIES, JPADotNames.NAMED_QUERY, JPADotNames.NAMED_NATIVE_QUERIES, JPADotNames.NAMED_NATIVE_QUERY, JPADotNames.SQL_RESULT_SET_MAPPING, JPADotNames.SQL_RESULT_SET_MAPPINGS};
    static final DotName[] SCHEMA_AWARE_ANNOTATIONS = new DotName[]{JPADotNames.TABLE, JPADotNames.JOIN_TABLE, JPADotNames.COLLECTION_TABLE, JPADotNames.SECONDARY_TABLE, JPADotNames.SECONDARY_TABLES, JPADotNames.TABLE_GENERATOR, JPADotNames.SEQUENCE_GENERATOR};
    static final DotName[] ASSOCIATION_ANNOTATIONS = new DotName[]{JPADotNames.ONE_TO_MANY, JPADotNames.ONE_TO_ONE, JPADotNames.MANY_TO_ONE, JPADotNames.MANY_TO_MANY};

    private DefaultConfigurationHelper() {
    }

    void applyDefaults(SchemaAware schemaAware, EntityMappingsMocker.Default default_) {
        if (this.hasSchemaOrCatalogDefined(default_)) {
            if (StringHelper.isEmpty(schemaAware.getSchema())) {
                schemaAware.setSchema(default_.getSchema());
            }
            if (StringHelper.isEmpty(schemaAware.getCatalog())) {
                schemaAware.setCatalog(default_.getCatalog());
            }
        }
    }

    void applyDefaults(Map<DotName, List<AnnotationInstance>> map, EntityMappingsMocker.Default default_) {
        if (map.isEmpty() || default_ == null) {
            return;
        }
        if (this.hasSchemaOrCatalogDefined(default_)) {
            this.applyDefaultSchemaAndCatalog(map, default_);
        }
        if (default_.isCascadePersist() != null && default_.isCascadePersist().booleanValue()) {
            this.applyDefaultCascadePersist(map);
        }
    }

    void applyDefaults(JaxbMappedSuperclass jaxbMappedSuperclass, EntityMappingsMocker.Default default_) {
        this.applyDefaultsToEntityObject(new MappedSuperClassEntityObject(jaxbMappedSuperclass), default_);
    }

    void applyDefaults(JaxbEmbeddable jaxbEmbeddable, EntityMappingsMocker.Default default_) {
        this.applyDefaultsToEntityObject(new EmbeddableEntityObject(jaxbEmbeddable), default_);
    }

    void applyDefaults(JaxbEntity jaxbEntity, EntityMappingsMocker.Default default_) {
        this.mockTableIfNonExist(jaxbEntity, default_);
        this.applyDefaultsToEntityObject(new EntityEntityObject(jaxbEntity), default_);
    }

    private void applyDefaultsToEntityObject(EntityObject entityObject, EntityMappingsMocker.Default default_) {
        if (default_ == null) {
            return;
        }
        String string = MockHelper.buildSafeClassName(entityObject.getClazz(), default_.getPackageName());
        entityObject.setClazz(string);
        if (entityObject.isMetadataComplete() == null) {
            entityObject.setMetadataComplete(default_.isMetadataComplete());
        }
        LOG.debugf("Adding XML overriding information for %s", (Object)string);
    }

    private boolean hasSchemaOrCatalogDefined(EntityMappingsMocker.Default default_) {
        return default_ != null && (StringHelper.isNotEmpty(default_.getSchema()) || StringHelper.isNotEmpty(default_.getCatalog()));
    }

    private void applyDefaultCascadePersist(Map<DotName, List<AnnotationInstance>> map) {
        for (DotName dotName : ASSOCIATION_ANNOTATIONS) {
            if (!map.containsKey(dotName)) continue;
            this.addCascadePersistIfNotExist(dotName, map);
        }
    }

    private void applyDefaultSchemaAndCatalog(Map<DotName, List<AnnotationInstance>> map, EntityMappingsMocker.Default default_) {
        for (DotName dotName : SCHEMA_AWARE_ANNOTATIONS) {
            this.mockTableIfNonExist(map, dotName);
            if (!map.containsKey(dotName)) continue;
            this.overrideSchemaCatalogByDefault(dotName, map, default_);
        }
    }

    private void mockTableIfNonExist(Map<DotName, List<AnnotationInstance>> map, DotName dotName) {
        if (dotName == JPADotNames.TABLE && !map.containsKey(JPADotNames.TABLE) && map.containsKey(JPADotNames.ENTITY)) {
            AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(map, JPADotNames.ENTITY);
            AnnotationInstance annotationInstance2 = MockHelper.create(JPADotNames.TABLE, annotationInstance.target(), MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY);
            ArrayList<AnnotationInstance> arrayList = new ArrayList<AnnotationInstance>(1);
            arrayList.add(annotationInstance2);
            map.put(JPADotNames.TABLE, arrayList);
        }
    }

    private void mockTableIfNonExist(JaxbEntity jaxbEntity, EntityMappingsMocker.Default default_) {
        JaxbTable jaxbTable;
        if (this.hasSchemaOrCatalogDefined(default_) && (jaxbTable = jaxbEntity.getTable()) == null) {
            jaxbTable = new JaxbTable();
            jaxbEntity.setTable(jaxbTable);
        }
    }

    private void addCascadePersistIfNotExist(DotName dotName, Map<DotName, List<AnnotationInstance>> map) {
        List<AnnotationInstance> list = map.get(dotName);
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (AnnotationInstance annotationInstance : list) {
            String[] stringArray;
            AnnotationValue annotationValue = annotationInstance.value("cascade");
            ArrayList<AnnotationValue> arrayList2 = new ArrayList<AnnotationValue>();
            arrayList2.addAll(annotationInstance.values());
            if (annotationValue == null) {
                stringArray = AnnotationValue.createEnumValue((String)"", (DotName)JPADotNames.CASCADE_TYPE, (String)"PERSIST");
                annotationValue = AnnotationValue.createArrayValue((String)"cascade", (AnnotationValue[])new AnnotationValue[]{stringArray});
            } else {
                arrayList2.remove(annotationValue);
                stringArray = annotationValue.asEnumArray();
                boolean bl = false;
                for (String string : stringArray) {
                    if (!"PERSIST".equals(string)) continue;
                    bl = true;
                }
                if (bl) {
                    arrayList.add(annotationInstance);
                    continue;
                }
                String[] stringArray2 = new String[stringArray.length + 1];
                stringArray2[0] = "PERSIST";
                System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                AnnotationValue[] annotationValueArray = new AnnotationValue[stringArray2.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    annotationValueArray[i] = AnnotationValue.createEnumValue((String)"", (DotName)JPADotNames.CASCADE_TYPE, (String)stringArray2[i]);
                }
                annotationValue = AnnotationValue.createArrayValue((String)"cascade", (AnnotationValue[])annotationValueArray);
            }
            arrayList2.add(annotationValue);
            stringArray = MockHelper.create(annotationInstance.name(), annotationInstance.target(), MockHelper.toArray(arrayList2));
            arrayList.add(stringArray);
        }
        map.put(dotName, arrayList);
    }

    private void overrideSchemaCatalogByDefault(DotName dotName, Map<DotName, List<AnnotationInstance>> map, EntityMappingsMocker.Default default_) {
        List<AnnotationInstance> list = map.get(dotName);
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<AnnotationInstance> arrayList = new ArrayList<AnnotationInstance>(list.size());
        for (AnnotationInstance annotationInstance : list) {
            if (dotName.equals((Object)IndexedAnnotationFilter.SECONDARY_TABLES)) {
                AnnotationInstance[] annotationInstanceArray = annotationInstance.value().asNestedArray();
                AnnotationValue[] annotationValueArray = new AnnotationValue[annotationInstanceArray.length];
                for (int i = 0; i < annotationInstanceArray.length; ++i) {
                    annotationValueArray[i] = MockHelper.nestedAnnotationValue("", this.overrideSchemaCatalogByDefault(annotationInstanceArray[i], default_));
                }
                AnnotationInstance annotationInstance2 = MockHelper.create(dotName, annotationInstance.target(), new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])annotationValueArray)});
                arrayList.add(annotationInstance2);
                continue;
            }
            arrayList.add(this.overrideSchemaCatalogByDefault(annotationInstance, default_));
        }
        map.put(dotName, arrayList);
    }

    private AnnotationInstance overrideSchemaCatalogByDefault(AnnotationInstance annotationInstance, EntityMappingsMocker.Default default_) {
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        arrayList.addAll(annotationInstance.values());
        boolean bl = false;
        boolean bl2 = false;
        if (annotationInstance.value("schema") != null) {
            bl = true;
        }
        if (annotationInstance.value("catalog") != null) {
            bl2 = true;
        }
        if (bl && bl2) {
            return annotationInstance;
        }
        if (!bl2 && StringHelper.isNotEmpty(default_.getCatalog())) {
            arrayList.add(AnnotationValue.createStringValue((String)"catalog", (String)default_.getCatalog()));
        }
        if (!bl && StringHelper.isNotEmpty(default_.getSchema())) {
            arrayList.add(AnnotationValue.createStringValue((String)"schema", (String)default_.getSchema()));
        }
        return MockHelper.create(annotationInstance.name(), annotationInstance.target(), MockHelper.toArray(arrayList));
    }

    private static class MappedSuperClassEntityObject
    implements EntityObject {
        private JaxbMappedSuperclass entity;

        private MappedSuperClassEntityObject(JaxbMappedSuperclass jaxbMappedSuperclass) {
            this.entity = jaxbMappedSuperclass;
        }

        public String getClazz() {
            return this.entity.getClazz();
        }

        public void setClazz(String string) {
            this.entity.setClazz(string);
        }

        public Boolean isMetadataComplete() {
            return this.entity.isMetadataComplete();
        }

        public void setMetadataComplete(Boolean bl) {
            this.entity.setMetadataComplete(bl);
        }
    }

    private static class EmbeddableEntityObject
    implements EntityObject {
        private JaxbEmbeddable entity;

        private EmbeddableEntityObject(JaxbEmbeddable jaxbEmbeddable) {
            this.entity = jaxbEmbeddable;
        }

        public String getClazz() {
            return this.entity.getClazz();
        }

        public void setClazz(String string) {
            this.entity.setClazz(string);
        }

        public Boolean isMetadataComplete() {
            return this.entity.isMetadataComplete();
        }

        public void setMetadataComplete(Boolean bl) {
            this.entity.setMetadataComplete(bl);
        }
    }

    private static class EntityEntityObject
    implements EntityObject {
        private JaxbEntity entity;

        private EntityEntityObject(JaxbEntity jaxbEntity) {
            this.entity = jaxbEntity;
        }

        public String getClazz() {
            return this.entity.getClazz();
        }

        public void setClazz(String string) {
            this.entity.setClazz(string);
        }

        public Boolean isMetadataComplete() {
            return this.entity.isMetadataComplete();
        }

        public void setMetadataComplete(Boolean bl) {
            this.entity.setMetadataComplete(bl);
        }
    }

    private static interface EntityObject {
        public String getClazz();

        public void setClazz(String var1);

        public Boolean isMetadataComplete();

        public void setMetadataComplete(Boolean var1);
    }
}

