/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAssociationOverride;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAttributeOverride;
import org.hibernate.internal.jaxb.mapping.orm.JaxbCollectionTable;
import org.hibernate.internal.jaxb.mapping.orm.JaxbColumn;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEnumType;
import org.hibernate.internal.jaxb.mapping.orm.JaxbJoinColumn;
import org.hibernate.internal.jaxb.mapping.orm.JaxbJoinTable;
import org.hibernate.internal.jaxb.mapping.orm.JaxbLob;
import org.hibernate.internal.jaxb.mapping.orm.JaxbOrderColumn;
import org.hibernate.internal.jaxb.mapping.orm.JaxbPrimaryKeyJoinColumn;
import org.hibernate.internal.jaxb.mapping.orm.JaxbTemporalType;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.DefaultConfigurationHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.SchemaAware;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AnnotationMocker
extends AbstractMocker {
    private EntityMappingsMocker.Default defaults;

    AnnotationMocker(IndexBuilder indexBuilder, EntityMappingsMocker.Default default_) {
        super(indexBuilder);
        this.defaults = default_;
    }

    abstract void process();

    protected EntityMappingsMocker.Default getDefaults() {
        return this.defaults;
    }

    protected boolean isDefaultCascadePersist() {
        return this.defaults.isCascadePersist() != null && this.defaults.isCascadePersist() != false;
    }

    protected AnnotationInstance parserJoinTable(JaxbJoinTable jaxbJoinTable, AnnotationTarget annotationTarget) {
        if (jaxbJoinTable == null) {
            return null;
        }
        DefaultConfigurationHelper.INSTANCE.applyDefaults(new SchemaAware.JoinTableSchemaAware(jaxbJoinTable), this.getDefaults());
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbJoinTable.getName(), arrayList);
        MockHelper.stringValue("catalog", jaxbJoinTable.getCatalog(), arrayList);
        MockHelper.stringValue("schema", jaxbJoinTable.getSchema(), arrayList);
        this.nestedJoinColumnList("joinColumns", jaxbJoinTable.getJoinColumn(), arrayList);
        this.nestedJoinColumnList("inverseJoinColumns", jaxbJoinTable.getInverseJoinColumn(), arrayList);
        this.nestedUniqueConstraintList("uniqueConstraints", jaxbJoinTable.getUniqueConstraint(), arrayList);
        return this.create(JOIN_TABLE, annotationTarget, arrayList);
    }

    private AnnotationInstance parserAssociationOverride(JaxbAssociationOverride jaxbAssociationOverride, AnnotationTarget annotationTarget) {
        if (jaxbAssociationOverride == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbAssociationOverride.getName(), arrayList);
        if (jaxbAssociationOverride instanceof JaxbAssociationOverrideProxy) {
            JaxbAssociationOverrideProxy jaxbAssociationOverrideProxy = (JaxbAssociationOverrideProxy)jaxbAssociationOverride;
            MockHelper.addToCollectionIfNotNull(arrayList, jaxbAssociationOverrideProxy.getJoinColumnsAnnotationValue());
            MockHelper.addToCollectionIfNotNull(arrayList, jaxbAssociationOverrideProxy.getJoinTableAnnotationValue());
        } else {
            this.nestedJoinColumnList("joinColumns", jaxbAssociationOverride.getJoinColumn(), arrayList);
            MockHelper.nestedAnnotationValue("joinTable", this.parserJoinTable(jaxbAssociationOverride.getJoinTable(), null), arrayList);
        }
        return this.create(ASSOCIATION_OVERRIDE, annotationTarget, arrayList);
    }

    private AnnotationValue[] nestedJoinColumnList(String string, List<JaxbJoinColumn> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserJoinColumn(list.get(i), null);
                annotationValueArray[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(list2, AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
            return annotationValueArray;
        }
        return MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY;
    }

    protected AnnotationInstance parserColumn(JaxbColumn jaxbColumn, AnnotationTarget annotationTarget) {
        if (jaxbColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbColumn.getName(), arrayList);
        MockHelper.stringValue("columnDefinition", jaxbColumn.getColumnDefinition(), arrayList);
        MockHelper.stringValue("table", jaxbColumn.getTable(), arrayList);
        MockHelper.booleanValue("unique", jaxbColumn.isUnique(), arrayList);
        MockHelper.booleanValue("nullable", jaxbColumn.isNullable(), arrayList);
        MockHelper.booleanValue("insertable", jaxbColumn.isInsertable(), arrayList);
        MockHelper.booleanValue("updatable", jaxbColumn.isUpdatable(), arrayList);
        MockHelper.integerValue("length", jaxbColumn.getLength(), arrayList);
        MockHelper.integerValue("precision", jaxbColumn.getPrecision(), arrayList);
        MockHelper.integerValue("scale", jaxbColumn.getScale(), arrayList);
        return this.create(COLUMN, annotationTarget, arrayList);
    }

    private AnnotationInstance parserAttributeOverride(JaxbAttributeOverride jaxbAttributeOverride, AnnotationTarget annotationTarget) {
        if (jaxbAttributeOverride == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbAttributeOverride.getName(), arrayList);
        if (jaxbAttributeOverride instanceof JaxbAttributeOverrideProxy) {
            JaxbAttributeOverrideProxy jaxbAttributeOverrideProxy = (JaxbAttributeOverrideProxy)jaxbAttributeOverride;
            MockHelper.addToCollectionIfNotNull(arrayList, jaxbAttributeOverrideProxy.getColumnAnnotationValue());
        } else {
            MockHelper.nestedAnnotationValue("column", this.parserColumn(jaxbAttributeOverride.getColumn(), null), arrayList);
        }
        return this.create(ATTRIBUTE_OVERRIDE, annotationTarget, arrayList);
    }

    protected AnnotationInstance parserOrderColumn(JaxbOrderColumn jaxbOrderColumn, AnnotationTarget annotationTarget) {
        if (jaxbOrderColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbOrderColumn.getName(), arrayList);
        MockHelper.stringValue("columnDefinition", jaxbOrderColumn.getColumnDefinition(), arrayList);
        MockHelper.booleanValue("nullable", jaxbOrderColumn.isNullable(), arrayList);
        MockHelper.booleanValue("insertable", jaxbOrderColumn.isInsertable(), arrayList);
        MockHelper.booleanValue("updatable", jaxbOrderColumn.isUpdatable(), arrayList);
        return this.create(ORDER_COLUMN, annotationTarget, arrayList);
    }

    protected AnnotationInstance parserJoinColumn(JaxbJoinColumn jaxbJoinColumn, AnnotationTarget annotationTarget) {
        if (jaxbJoinColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbJoinColumn.getName(), arrayList);
        MockHelper.stringValue("columnDefinition", jaxbJoinColumn.getColumnDefinition(), arrayList);
        MockHelper.stringValue("table", jaxbJoinColumn.getTable(), arrayList);
        MockHelper.stringValue("referencedColumnName", jaxbJoinColumn.getReferencedColumnName(), arrayList);
        MockHelper.booleanValue("unique", jaxbJoinColumn.isUnique(), arrayList);
        MockHelper.booleanValue("nullable", jaxbJoinColumn.isNullable(), arrayList);
        MockHelper.booleanValue("insertable", jaxbJoinColumn.isInsertable(), arrayList);
        MockHelper.booleanValue("updatable", jaxbJoinColumn.isUpdatable(), arrayList);
        return this.create(JOIN_COLUMN, annotationTarget, arrayList);
    }

    protected AnnotationInstance parserLob(JaxbLob jaxbLob, AnnotationTarget annotationTarget) {
        if (jaxbLob == null) {
            return null;
        }
        return this.create(LOB, annotationTarget);
    }

    protected AnnotationInstance parserTemporalType(JaxbTemporalType jaxbTemporalType, AnnotationTarget annotationTarget) {
        if (jaxbTemporalType == null) {
            return null;
        }
        return this.create(TEMPORAL, annotationTarget, MockHelper.enumValueArray("value", TEMPORAL_TYPE, jaxbTemporalType));
    }

    protected AnnotationInstance parserEnumType(JaxbEnumType jaxbEnumType, AnnotationTarget annotationTarget) {
        if (jaxbEnumType == null) {
            return null;
        }
        return this.create(ENUMERATED, annotationTarget, MockHelper.enumValueArray("value", ENUM_TYPE, jaxbEnumType));
    }

    protected AnnotationInstance parserPrimaryKeyJoinColumn(JaxbPrimaryKeyJoinColumn jaxbPrimaryKeyJoinColumn, AnnotationTarget annotationTarget) {
        if (jaxbPrimaryKeyJoinColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbPrimaryKeyJoinColumn.getName(), arrayList);
        MockHelper.stringValue("referencedColumnName", jaxbPrimaryKeyJoinColumn.getReferencedColumnName(), arrayList);
        MockHelper.stringValue("columnDefinition", jaxbPrimaryKeyJoinColumn.getColumnDefinition(), arrayList);
        return this.create(PRIMARY_KEY_JOIN_COLUMN, annotationTarget, arrayList);
    }

    protected AnnotationInstance parserPrimaryKeyJoinColumnList(List<JaxbPrimaryKeyJoinColumn> list, AnnotationTarget annotationTarget) {
        if (MockHelper.isNotEmpty(list)) {
            if (list.size() == 1) {
                return this.parserPrimaryKeyJoinColumn(list.get(0), annotationTarget);
            }
            return this.create(PRIMARY_KEY_JOIN_COLUMNS, annotationTarget, this.nestedPrimaryKeyJoinColumnList("value", list, null));
        }
        return null;
    }

    protected AnnotationValue[] nestedPrimaryKeyJoinColumnList(String string, List<JaxbPrimaryKeyJoinColumn> list, List<AnnotationValue> list2) {
        if (MockHelper.isNotEmpty(list)) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserPrimaryKeyJoinColumn(list.get(i), null);
                annotationValueArray[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(list2, AnnotationValue.createArrayValue((String)string, (AnnotationValue[])annotationValueArray));
            return annotationValueArray;
        }
        return MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY;
    }

    protected void getAnnotationInstanceByTarget(DotName dotName, AnnotationTarget annotationTarget, Operation operation) {
        Map<DotName, List<AnnotationInstance>> map = this.indexBuilder.getIndexedAnnotations(this.getTargetName());
        if (!map.containsKey(dotName)) {
            return;
        }
        List<AnnotationInstance> list = map.get(dotName);
        if (MockHelper.isNotEmpty(list)) {
            for (AnnotationInstance annotationInstance : list) {
                AnnotationTarget annotationTarget2 = annotationInstance.target();
                if (!MockHelper.targetEquals(annotationTarget, annotationTarget2) || !operation.process(annotationInstance)) continue;
                return;
            }
        }
    }

    protected AnnotationInstance parserAttributeOverrides(List<JaxbAttributeOverride> list, AnnotationTarget annotationTarget) {
        if (annotationTarget == null) {
            throw new AssertionFailure("target can not be null");
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (JaxbAttributeOverride annotationValueArray2 : list) {
            hashSet.add(annotationValueArray2.getName());
        }
        AttributeOverrideOperation attributeOverrideOperation = new AttributeOverrideOperation(hashSet, list);
        this.getAnnotationInstanceByTarget(ATTRIBUTE_OVERRIDES, annotationTarget, new ContainerOperation(attributeOverrideOperation));
        this.getAnnotationInstanceByTarget(ATTRIBUTE_OVERRIDE, annotationTarget, attributeOverrideOperation);
        if (list.size() == 1) {
            return this.parserAttributeOverride(list.get(0), annotationTarget);
        }
        AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
        for (int i = 0; i < annotationValueArray.length; ++i) {
            annotationValueArray[i] = MockHelper.nestedAnnotationValue("", this.parserAttributeOverride(list.get(i), null));
        }
        return this.create(ATTRIBUTE_OVERRIDES, annotationTarget, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])annotationValueArray)});
    }

    protected AnnotationInstance parserAssociationOverrides(List<JaxbAssociationOverride> list, AnnotationTarget annotationTarget) {
        if (annotationTarget == null) {
            throw new AssertionFailure("target can not be null");
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (JaxbAssociationOverride annotationValueArray2 : list) {
            hashSet.add(annotationValueArray2.getName());
        }
        AssociationOverrideOperation associationOverrideOperation = new AssociationOverrideOperation(hashSet, list);
        this.getAnnotationInstanceByTarget(ASSOCIATION_OVERRIDES, annotationTarget, new ContainerOperation(associationOverrideOperation));
        this.getAnnotationInstanceByTarget(ASSOCIATION_OVERRIDE, annotationTarget, associationOverrideOperation);
        if (list.size() == 1) {
            return this.parserAssociationOverride(list.get(0), annotationTarget);
        }
        AnnotationValue[] annotationValueArray = new AnnotationValue[list.size()];
        for (int i = 0; i < annotationValueArray.length; ++i) {
            annotationValueArray[i] = MockHelper.nestedAnnotationValue("", this.parserAssociationOverride(list.get(i), null));
        }
        return this.create(ASSOCIATION_OVERRIDES, annotationTarget, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])annotationValueArray)});
    }

    protected AnnotationInstance parserCollectionTable(JaxbCollectionTable jaxbCollectionTable, AnnotationTarget annotationTarget) {
        if (jaxbCollectionTable == null) {
            return null;
        }
        DefaultConfigurationHelper.INSTANCE.applyDefaults(new SchemaAware.CollectionTableSchemaAware(jaxbCollectionTable), this.getDefaults());
        ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", jaxbCollectionTable.getName(), arrayList);
        MockHelper.stringValue("catalog", jaxbCollectionTable.getCatalog(), arrayList);
        MockHelper.stringValue("schema", jaxbCollectionTable.getSchema(), arrayList);
        this.nestedJoinColumnList("joinColumns", jaxbCollectionTable.getJoinColumn(), arrayList);
        this.nestedUniqueConstraintList("uniqueConstraints", jaxbCollectionTable.getUniqueConstraint(), arrayList);
        return this.create(COLLECTION_TABLE, annotationTarget, arrayList);
    }

    protected AnnotationInstance parserJoinColumnList(List<JaxbJoinColumn> list, AnnotationTarget annotationTarget) {
        if (MockHelper.isNotEmpty(list)) {
            if (list.size() == 1) {
                return this.parserJoinColumn(list.get(0), annotationTarget);
            }
            AnnotationValue[] annotationValueArray = this.nestedJoinColumnList("value", list, null);
            return this.create(JOIN_COLUMNS, annotationTarget, annotationValueArray);
        }
        return null;
    }

    protected AnnotationInstance create(DotName dotName) {
        return this.create(dotName, MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY);
    }

    protected AnnotationInstance create(DotName dotName, AnnotationValue[] annotationValueArray) {
        return this.create(dotName, this.getTarget(), annotationValueArray);
    }

    protected AnnotationInstance create(DotName dotName, List<AnnotationValue> list) {
        return this.create(dotName, this.getTarget(), list);
    }

    protected abstract DotName getTargetName();

    protected abstract AnnotationTarget getTarget();

    @Override
    protected AnnotationInstance push(AnnotationInstance annotationInstance) {
        if (annotationInstance != null && annotationInstance.target() != null) {
            this.indexBuilder.addAnnotationInstance(this.getTargetName(), annotationInstance);
        }
        return annotationInstance;
    }

    class JaxbAttributeOverrideProxy
    extends JaxbAttributeOverride {
        private AnnotationValue columnAnnotationValue;

        JaxbAttributeOverrideProxy() {
        }

        AnnotationValue getColumnAnnotationValue() {
            return this.columnAnnotationValue;
        }

        void setColumnAnnotationValue(AnnotationValue annotationValue) {
            this.columnAnnotationValue = annotationValue;
        }
    }

    class JaxbAssociationOverrideProxy
    extends JaxbAssociationOverride {
        private AnnotationValue joinTableAnnotationValue;
        private AnnotationValue joinColumnsAnnotationValue;

        JaxbAssociationOverrideProxy() {
        }

        AnnotationValue getJoinColumnsAnnotationValue() {
            return this.joinColumnsAnnotationValue;
        }

        void setJoinColumnsAnnotationValue(AnnotationValue annotationValue) {
            this.joinColumnsAnnotationValue = annotationValue;
        }

        AnnotationValue getJoinTableAnnotationValue() {
            return this.joinTableAnnotationValue;
        }

        void setJoinTableAnnotationValue(AnnotationValue annotationValue) {
            this.joinTableAnnotationValue = annotationValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssociationOverrideOperation
    implements Operation {
        private Set<String> names;
        private List<JaxbAssociationOverride> associationOverrides;

        AssociationOverrideOperation(Set<String> set, List<JaxbAssociationOverride> list) {
            this.names = set;
            this.associationOverrides = list;
        }

        @Override
        public boolean process(AnnotationInstance annotationInstance) {
            String string = annotationInstance.value("name").asString();
            if (!this.names.contains(string)) {
                JaxbAssociationOverrideProxy jaxbAssociationOverrideProxy = new JaxbAssociationOverrideProxy();
                jaxbAssociationOverrideProxy.setName(string);
                jaxbAssociationOverrideProxy.setJoinColumnsAnnotationValue(annotationInstance.value("joinColumns"));
                jaxbAssociationOverrideProxy.setJoinTableAnnotationValue(annotationInstance.value("joinTable"));
                this.associationOverrides.add(jaxbAssociationOverrideProxy);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AttributeOverrideOperation
    implements Operation {
        private Set<String> names;
        private List<JaxbAttributeOverride> attributeOverrides;

        AttributeOverrideOperation(Set<String> set, List<JaxbAttributeOverride> list) {
            this.names = set;
            this.attributeOverrides = list;
        }

        @Override
        public boolean process(AnnotationInstance annotationInstance) {
            String string = annotationInstance.value("name").asString();
            if (!this.names.contains(string)) {
                JaxbAttributeOverrideProxy jaxbAttributeOverrideProxy = new JaxbAttributeOverrideProxy();
                jaxbAttributeOverrideProxy.setName(string);
                jaxbAttributeOverrideProxy.setColumnAnnotationValue(annotationInstance.value("column"));
                this.attributeOverrides.add(jaxbAttributeOverrideProxy);
            }
            return false;
        }
    }

    class ContainerOperation
    implements Operation {
        private Operation child;

        ContainerOperation(Operation operation) {
            this.child = operation;
        }

        public boolean process(AnnotationInstance annotationInstance) {
            AnnotationInstance[] annotationInstanceArray;
            AnnotationValue annotationValue = annotationInstance.value();
            for (AnnotationInstance annotationInstance2 : annotationInstanceArray = annotationValue.asNestedArray()) {
                this.child.process(annotationInstance2);
            }
            return true;
        }
    }

    protected static interface Operation {
        public boolean process(AnnotationInstance var1);
    }
}

