/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAccessType;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.xml.PseudoJpaDotNames;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccessHelper
implements JPADotNames {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AccessHelper.class.getName());

    AccessHelper() {
    }

    static JaxbAccessType getAccessFromDefault(IndexBuilder indexBuilder) {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(indexBuilder.getAnnotations(), PseudoJpaDotNames.DEFAULT_ACCESS);
        if (annotationInstance == null) {
            return null;
        }
        return JandexHelper.getEnumValue(annotationInstance, "value", JaxbAccessType.class);
    }

    static JaxbAccessType getAccessFromIdPosition(DotName dotName, IndexBuilder indexBuilder) {
        Map<DotName, List<AnnotationInstance>> map = indexBuilder.getIndexedAnnotations(dotName);
        Map<DotName, List<AnnotationInstance>> map2 = indexBuilder.getClassInfoAnnotationsMap(dotName);
        JaxbAccessType jaxbAccessType = AccessHelper.getAccessFromIdPosition(map2);
        if (jaxbAccessType == null) {
            jaxbAccessType = AccessHelper.getAccessFromIdPosition(map);
        }
        if (jaxbAccessType == null) {
            ClassInfo classInfo = indexBuilder.getClassInfo(dotName);
            if (classInfo == null) {
                classInfo = indexBuilder.getIndexedClassInfo(dotName);
            }
            if (classInfo != null) {
                DotName dotName2 = classInfo.superName();
                jaxbAccessType = AccessHelper.getAccessFromIdPosition(dotName2, indexBuilder);
            }
        }
        return jaxbAccessType;
    }

    private static JaxbAccessType getAccessFromIdPosition(Map<DotName, List<AnnotationInstance>> map) {
        if (map == null || map.isEmpty() || !map.containsKey(ID)) {
            return null;
        }
        List<AnnotationInstance> list = map.get(ID);
        if (MockHelper.isNotEmpty(list)) {
            return AccessHelper.processIdAnnotations(list);
        }
        return null;
    }

    private static JaxbAccessType processIdAnnotations(List<AnnotationInstance> list) {
        JaxbAccessType jaxbAccessType = null;
        for (AnnotationInstance annotationInstance : list) {
            AnnotationTarget annotationTarget = annotationInstance.target();
            if (annotationTarget == null) {
                throw new AssertionFailure("@Id has no AnnotationTarget, this is mostly a internal error.");
            }
            if (jaxbAccessType == null) {
                jaxbAccessType = AccessHelper.annotationTargetToAccessType(annotationTarget);
                continue;
            }
            if (jaxbAccessType.equals((Object)AccessHelper.annotationTargetToAccessType(annotationTarget))) continue;
            throw new MappingException("Inconsistent placement of @Id annotation within hierarchy ");
        }
        return jaxbAccessType;
    }

    static JaxbAccessType annotationTargetToAccessType(AnnotationTarget annotationTarget) {
        return annotationTarget instanceof MethodInfo ? JaxbAccessType.PROPERTY : JaxbAccessType.FIELD;
    }

    static JaxbAccessType getEntityAccess(DotName dotName, IndexBuilder indexBuilder) {
        Map<DotName, List<AnnotationInstance>> map = indexBuilder.getIndexedAnnotations(dotName);
        Map<DotName, List<AnnotationInstance>> map2 = indexBuilder.getClassInfoAnnotationsMap(dotName);
        JaxbAccessType jaxbAccessType = AccessHelper.getAccess(map2);
        if (jaxbAccessType == null) {
            jaxbAccessType = AccessHelper.getAccess(map);
        }
        if (jaxbAccessType == null) {
            ClassInfo classInfo = indexBuilder.getClassInfo(dotName);
            if (classInfo == null) {
                classInfo = indexBuilder.getIndexedClassInfo(dotName);
            }
            if (classInfo != null) {
                DotName dotName2 = classInfo.superName();
                jaxbAccessType = AccessHelper.getEntityAccess(dotName2, indexBuilder);
            }
        }
        return jaxbAccessType;
    }

    private static JaxbAccessType getAccess(Map<DotName, List<AnnotationInstance>> map) {
        if (map == null || map.isEmpty() || !AccessHelper.isEntityObject(map)) {
            return null;
        }
        List<AnnotationInstance> list = map.get(JPADotNames.ACCESS);
        if (MockHelper.isNotEmpty(list)) {
            for (AnnotationInstance annotationInstance : list) {
                if (annotationInstance.target() == null || !(annotationInstance.target() instanceof ClassInfo)) continue;
                return JandexHelper.getEnumValue(annotationInstance, "value", JaxbAccessType.class);
            }
        }
        return null;
    }

    private static boolean isEntityObject(Map<DotName, List<AnnotationInstance>> map) {
        return map.containsKey(ENTITY) || map.containsKey(MAPPED_SUPERCLASS) || map.containsKey(EMBEDDABLE);
    }

    static JaxbAccessType getAccessFromAttributeAnnotation(DotName dotName, String string, IndexBuilder indexBuilder) {
        List<AnnotationInstance> list;
        Map<DotName, List<AnnotationInstance>> map = indexBuilder.getIndexedAnnotations(dotName);
        if (map != null && map.containsKey(ACCESS) && MockHelper.isNotEmpty(list = map.get(ACCESS))) {
            for (AnnotationInstance annotationInstance : list) {
                JaxbAccessType jaxbAccessType;
                AnnotationTarget annotationTarget = annotationInstance.target();
                if (annotationTarget == null || !JandexHelper.getPropertyName(annotationTarget).equals(string)) continue;
                JaxbAccessType jaxbAccessType2 = JandexHelper.getEnumValue(annotationInstance, "value", JaxbAccessType.class);
                if (jaxbAccessType2.equals((Object)(jaxbAccessType = AccessHelper.annotationTargetToAccessType(annotationTarget)))) {
                    return jaxbAccessType;
                }
                LOG.warn(String.format("%s.%s has @Access on %s, but it tries to assign the access type to %s, this is not allowed by JPA spec, and will be ignored.", new Object[]{dotName, string, jaxbAccessType, jaxbAccessType2}));
            }
        }
        return null;
    }
}

