/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.metamodel.source.annotations.xml.filter.AbstractAnnotationFilter;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExclusiveAnnotationFilter
extends AbstractAnnotationFilter {
    public static ExclusiveAnnotationFilter INSTANCE = new ExclusiveAnnotationFilter();
    private DotName[] targetNames;
    private List<ExclusiveGroup> exclusiveGroupList = this.getExclusiveGroupList();

    private ExclusiveAnnotationFilter() {
        HashSet<DotName> hashSet = new HashSet<DotName>();
        for (ExclusiveGroup exclusiveGroup : this.exclusiveGroupList) {
            hashSet.addAll(exclusiveGroup.getNames());
        }
        this.targetNames = hashSet.toArray(new DotName[hashSet.size()]);
    }

    private List<ExclusiveGroup> getExclusiveGroupList() {
        if (this.exclusiveGroupList == null) {
            this.exclusiveGroupList = new ArrayList<ExclusiveGroup>();
            ExclusiveGroup exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(ENTITY);
            exclusiveGroup.add(MAPPED_SUPERCLASS);
            exclusiveGroup.add(EMBEDDABLE);
            exclusiveGroup.scope = Scope.TYPE;
            this.exclusiveGroupList.add(exclusiveGroup);
            exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(SECONDARY_TABLES);
            exclusiveGroup.add(SECONDARY_TABLE);
            exclusiveGroup.scope = Scope.TYPE;
            this.exclusiveGroupList.add(exclusiveGroup);
            exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(PRIMARY_KEY_JOIN_COLUMNS);
            exclusiveGroup.add(PRIMARY_KEY_JOIN_COLUMN);
            exclusiveGroup.scope = Scope.ATTRIBUTE;
            this.exclusiveGroupList.add(exclusiveGroup);
            exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(SQL_RESULT_SET_MAPPING);
            exclusiveGroup.add(SQL_RESULT_SET_MAPPINGS);
            exclusiveGroup.scope = Scope.TYPE;
            this.exclusiveGroupList.add(exclusiveGroup);
            exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(NAMED_NATIVE_QUERY);
            exclusiveGroup.add(NAMED_NATIVE_QUERIES);
            exclusiveGroup.scope = Scope.TYPE;
            this.exclusiveGroupList.add(exclusiveGroup);
            exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(NAMED_QUERY);
            exclusiveGroup.add(NAMED_QUERIES);
            exclusiveGroup.scope = Scope.TYPE;
            this.exclusiveGroupList.add(exclusiveGroup);
            exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(ATTRIBUTE_OVERRIDES);
            exclusiveGroup.add(ATTRIBUTE_OVERRIDE);
            exclusiveGroup.scope = Scope.ATTRIBUTE;
            this.exclusiveGroupList.add(exclusiveGroup);
            exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(ASSOCIATION_OVERRIDE);
            exclusiveGroup.add(ASSOCIATION_OVERRIDES);
            exclusiveGroup.scope = Scope.ATTRIBUTE;
            this.exclusiveGroupList.add(exclusiveGroup);
            exclusiveGroup = new ExclusiveGroup();
            exclusiveGroup.add(MAP_KEY_JOIN_COLUMN);
            exclusiveGroup.add(MAP_KEY_JOIN_COLUMNS);
            exclusiveGroup.scope = Scope.ATTRIBUTE;
            this.exclusiveGroupList.add(exclusiveGroup);
        }
        return this.exclusiveGroupList;
    }

    @Override
    protected void overrideIndexedAnnotationMap(DotName dotName, AnnotationInstance annotationInstance, Map<DotName, List<AnnotationInstance>> map) {
        ExclusiveGroup exclusiveGroup = this.getExclusiveGroup(dotName);
        if (exclusiveGroup == null) {
            return;
        }
        AnnotationTarget annotationTarget = annotationInstance.target();
        for (DotName dotName2 : exclusiveGroup) {
            if (!map.containsKey(dotName2)) continue;
            switch (exclusiveGroup.scope) {
                case TYPE: {
                    map.put(dotName2, Collections.emptyList());
                    break;
                }
                case ATTRIBUTE: {
                    List<AnnotationInstance> list = map.get(dotName2);
                    Iterator<AnnotationInstance> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        AnnotationInstance annotationInstance2 = iterator.next();
                        if (!MockHelper.targetEquals(annotationTarget, annotationInstance2.target())) continue;
                        iterator.remove();
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected DotName[] targetAnnotation() {
        return this.targetNames;
    }

    private ExclusiveGroup getExclusiveGroup(DotName dotName) {
        for (ExclusiveGroup exclusiveGroup : this.exclusiveGroupList) {
            if (!exclusiveGroup.contains(dotName)) continue;
            return exclusiveGroup;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExclusiveGroup
    implements Iterable<DotName> {
        private Set<DotName> names = new HashSet<DotName>();
        Scope scope = Scope.ATTRIBUTE;

        private ExclusiveGroup() {
        }

        public Set<DotName> getNames() {
            return this.names;
        }

        @Override
        public Iterator iterator() {
            return this.names.iterator();
        }

        boolean contains(DotName dotName) {
            return this.names.contains(dotName);
        }

        void add(DotName dotName) {
            this.names.add(dotName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Scope {
        TYPE,
        ATTRIBUTE;

    }
}

