/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.metamodel.source.annotations.xml.filter.IndexedAnnotationFilter;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAnnotationFilter
implements IndexedAnnotationFilter {
    protected static final DotName[] EMPTY_DOTNAME_ARRAY = new DotName[0];
    private Set<DotName> candidates;

    AbstractAnnotationFilter() {
    }

    private boolean match(DotName dotName) {
        if (this.candidates == null) {
            this.candidates = new HashSet<DotName>();
            this.candidates.addAll(Arrays.asList(this.targetAnnotation()));
        }
        return this.candidates.contains(dotName);
    }

    @Override
    public void beforePush(IndexBuilder indexBuilder, DotName dotName, AnnotationInstance annotationInstance) {
        DotName dotName2 = annotationInstance.name();
        if (!this.match(dotName2)) {
            return;
        }
        Map<DotName, List<AnnotationInstance>> map = indexBuilder.getIndexedAnnotations(dotName);
        this.overrideIndexedAnnotationMap(dotName2, annotationInstance, map);
    }

    protected void overrideIndexedAnnotationMap(DotName dotName, AnnotationInstance annotationInstance, Map<DotName, List<AnnotationInstance>> map) {
        if (!map.containsKey(dotName)) {
            return;
        }
        List<AnnotationInstance> list = map.get(dotName);
        if (list.isEmpty()) {
            return;
        }
        this.process(dotName, annotationInstance, list);
    }

    protected void process(DotName dotName, AnnotationInstance annotationInstance, List<AnnotationInstance> list) {
    }

    protected DotName[] targetAnnotation() {
        return EMPTY_DOTNAME_ARRAY;
    }
}

