/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.TypeDef;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDefBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TypeDefBinder.class.getName());

    public static void bind(AnnotationBindingContext annotationBindingContext) {
        List list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.TYPE_DEF);
        for (AnnotationInstance annotationInstance : list) {
            TypeDefBinder.bind(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.TYPE_DEFS);
        for (AnnotationInstance annotationInstance : list) {
            AnnotationInstance[] annotationInstanceArray;
            for (AnnotationInstance annotationInstance2 : annotationInstanceArray = JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class)) {
                TypeDefBinder.bind(annotationBindingContext.getMetadataImplementor(), annotationInstance2);
            }
        }
    }

    private static void bind(MetadataImplementor metadataImplementor, AnnotationInstance annotationInstance) {
        AnnotationInstance[] annotationInstanceArray;
        boolean bl;
        String string = JandexHelper.getValue(annotationInstance, "name", String.class);
        String string2 = JandexHelper.getValue(annotationInstance, "defaultForType", String.class);
        String string3 = JandexHelper.getValue(annotationInstance, "typeClass", String.class);
        boolean bl2 = StringHelper.isEmpty(string);
        boolean bl3 = bl = string2 == null || string2.equals(Void.TYPE.getName());
        if (bl2 && bl) {
            throw new AnnotationException("Either name or defaultForType (or both) attribute should be set in TypeDef having typeClass " + string3);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (AnnotationInstance annotationInstance2 : annotationInstanceArray = JandexHelper.getValue(annotationInstance, "parameters", AnnotationInstance[].class)) {
            hashMap.put(JandexHelper.getValue(annotationInstance2, "name", String.class), JandexHelper.getValue(annotationInstance2, "value", String.class));
        }
        if (!bl2) {
            TypeDefBinder.bind(string, string3, hashMap, metadataImplementor);
        }
        if (!bl) {
            TypeDefBinder.bind(string2, string3, hashMap, metadataImplementor);
        }
    }

    private static void bind(String string, String string2, Map<String, String> map, MetadataImplementor metadataImplementor) {
        LOG.debugf("Binding type definition: %s", (Object)string);
        metadataImplementor.addTypeDefinition(new TypeDef(string, string2, map));
    }

    private TypeDefBinder() {
    }
}

