/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.ObjectName;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;

public class TableBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TableBinder.class.getName());

    private TableBinder() {
    }

    public static void bind(AnnotationBindingContext annotationBindingContext) {
        List list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.TABLE);
        for (AnnotationInstance annotationInstance : list) {
            TableBinder.bind(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.TABLES);
        for (AnnotationInstance annotationInstance : list) {
            for (AnnotationInstance annotationInstance2 : JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class)) {
                TableBinder.bind(annotationBindingContext.getMetadataImplementor(), annotationInstance2);
            }
        }
    }

    private static void bind(MetadataImplementor metadataImplementor, AnnotationInstance annotationInstance) {
        String string = JandexHelper.getValue(annotationInstance, "appliesTo", String.class);
        ObjectName objectName = new ObjectName(string);
        Schema schema = metadataImplementor.getDatabase().getSchema(objectName.getSchema(), objectName.getCatalog());
        Table table = schema.locateTable(objectName.getName());
        if (table != null) {
            TableBinder.bindHibernateTableAnnotation(table, annotationInstance);
        }
    }

    private static void bindHibernateTableAnnotation(Table table, AnnotationInstance annotationInstance) {
        for (AnnotationInstance annotationInstance2 : JandexHelper.getValue(annotationInstance, "indexes", AnnotationInstance[].class)) {
            TableBinder.bindIndexAnnotation(table, annotationInstance2);
        }
        String string = JandexHelper.getValue(annotationInstance, "comment", String.class);
        if (StringHelper.isNotEmpty(string)) {
            table.addComment(string.trim());
        }
    }

    private static void bindIndexAnnotation(Table table, AnnotationInstance annotationInstance) {
        String string = JandexHelper.getValue(annotationInstance, "appliesTo", String.class);
        String[] stringArray = JandexHelper.getValue(annotationInstance, "columnNames", String[].class);
        if (stringArray == null) {
            LOG.noColumnsSpecifiedForIndex(string, table.toLoggableString());
            return;
        }
        Index index = table.getOrCreateIndex(string);
        for (String string2 : stringArray) {
            Column column = TableBinder.findColumn(table, string2);
            if (column == null) {
                throw new AnnotationException("@Index references a unknown column: " + string2);
            }
            index.addColumn(column);
        }
    }

    private static Column findColumn(Table table, String string) {
        Column column = null;
        for (SimpleValue simpleValue : table.values()) {
            if (!(simpleValue instanceof Column) || !((Column)simpleValue).getColumnName().getName().equals(string)) continue;
            column = (Column)simpleValue;
            break;
        }
        return column;
    }
}

