/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.logging.Logger;

public class QueryBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, QueryBinder.class.getName());

    private QueryBinder() {
    }

    public static void bind(AnnotationBindingContext annotationBindingContext) {
        List list = annotationBindingContext.getIndex().getAnnotations(JPADotNames.NAMED_QUERY);
        for (AnnotationInstance annotationInstance : list) {
            QueryBinder.bindNamedQuery(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(JPADotNames.NAMED_QUERIES);
        for (AnnotationInstance annotationInstance : list) {
            for (AnnotationInstance annotationInstance2 : JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class)) {
                QueryBinder.bindNamedQuery(annotationBindingContext.getMetadataImplementor(), annotationInstance2);
            }
        }
        list = annotationBindingContext.getIndex().getAnnotations(JPADotNames.NAMED_NATIVE_QUERY);
        for (AnnotationInstance annotationInstance : list) {
            QueryBinder.bindNamedNativeQuery(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(JPADotNames.NAMED_NATIVE_QUERIES);
        for (AnnotationInstance annotationInstance : list) {
            for (AnnotationInstance annotationInstance2 : JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class)) {
                QueryBinder.bindNamedNativeQuery(annotationBindingContext.getMetadataImplementor(), annotationInstance2);
            }
        }
        list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.NAMED_QUERY);
        for (AnnotationInstance annotationInstance : list) {
            QueryBinder.bindNamedQuery(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.NAMED_QUERIES);
        for (AnnotationInstance annotationInstance : list) {
            for (AnnotationInstance annotationInstance2 : JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class)) {
                QueryBinder.bindNamedQuery(annotationBindingContext.getMetadataImplementor(), annotationInstance2);
            }
        }
        list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.NAMED_NATIVE_QUERY);
        for (AnnotationInstance annotationInstance : list) {
            QueryBinder.bindNamedNativeQuery(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.NAMED_NATIVE_QUERIES);
        for (AnnotationInstance annotationInstance : list) {
            for (AnnotationInstance annotationInstance2 : JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class)) {
                QueryBinder.bindNamedNativeQuery(annotationBindingContext.getMetadataImplementor(), annotationInstance2);
            }
        }
    }

    private static void bindNamedQuery(MetadataImplementor metadataImplementor, AnnotationInstance annotationInstance) {
        String string;
        Integer n;
        Integer n2;
        String string2 = JandexHelper.getValue(annotationInstance, "name", String.class);
        if (StringHelper.isEmpty(string2)) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String string3 = JandexHelper.getValue(annotationInstance, "query", String.class);
        AnnotationInstance[] annotationInstanceArray = JandexHelper.getValue(annotationInstance, "hints", AnnotationInstance[].class);
        String string4 = QueryBinder.getString(annotationInstanceArray, "org.hibernate.cacheRegion");
        if (StringHelper.isEmpty(string4)) {
            string4 = null;
        }
        if ((n2 = QueryBinder.getTimeout(annotationInstanceArray, string3)) != null && n2 < 0) {
            n2 = null;
        }
        if ((n = QueryBinder.getInteger(annotationInstanceArray, "org.hibernate.fetchSize", string2)) != null && n < 0) {
            n = null;
        }
        if (StringHelper.isEmpty(string = QueryBinder.getString(annotationInstanceArray, "org.hibernate.comment"))) {
            string = null;
        }
        metadataImplementor.addNamedQuery(new NamedQueryDefinition(string2, string3, QueryBinder.getBoolean(annotationInstanceArray, "org.hibernate.cacheable", string2), string4, n2, n, QueryBinder.getFlushMode(annotationInstanceArray, "org.hibernate.flushMode", string2), QueryBinder.getCacheMode(annotationInstanceArray, "org.hibernate.cacheMode", string2), QueryBinder.getBoolean(annotationInstanceArray, "org.hibernate.readOnly", string2), string, null));
        LOG.debugf("Binding named query: %s => %s", (Object)string2, (Object)string3);
    }

    private static void bindNamedNativeQuery(MetadataImplementor metadataImplementor, AnnotationInstance annotationInstance) {
        NamedSQLQueryDefinition namedSQLQueryDefinition;
        Integer n;
        Integer n2;
        String string = JandexHelper.getValue(annotationInstance, "name", String.class);
        if (StringHelper.isEmpty(string)) {
            throw new AnnotationException("A named native query must have a name when used in class or package level");
        }
        String string2 = JandexHelper.getValue(annotationInstance, "query", String.class);
        String string3 = JandexHelper.getValue(annotationInstance, "resultSetMapping", String.class);
        AnnotationInstance[] annotationInstanceArray = JandexHelper.getValue(annotationInstance, "hints", AnnotationInstance[].class);
        boolean bl = QueryBinder.getBoolean(annotationInstanceArray, "org.hibernate.cacheable", string);
        String string4 = QueryBinder.getString(annotationInstanceArray, "org.hibernate.cacheRegion");
        if (StringHelper.isEmpty(string4)) {
            string4 = null;
        }
        if ((n2 = QueryBinder.getTimeout(annotationInstanceArray, string2)) != null && n2 < 0) {
            n2 = null;
        }
        if ((n = QueryBinder.getInteger(annotationInstanceArray, "org.hibernate.fetchSize", string)) != null && n < 0) {
            n = null;
        }
        FlushMode flushMode = QueryBinder.getFlushMode(annotationInstanceArray, "org.hibernate.flushMode", string);
        CacheMode cacheMode = QueryBinder.getCacheMode(annotationInstanceArray, "org.hibernate.cacheMode", string);
        boolean bl2 = QueryBinder.getBoolean(annotationInstanceArray, "org.hibernate.readOnly", string);
        String string5 = QueryBinder.getString(annotationInstanceArray, "org.hibernate.comment");
        if (StringHelper.isEmpty(string5)) {
            string5 = null;
        }
        boolean bl3 = QueryBinder.getBoolean(annotationInstanceArray, "org.hibernate.callable", string);
        if (StringHelper.isNotEmpty(string3)) {
            namedSQLQueryDefinition = new NamedSQLQueryDefinition(string, string2, string3, null, bl, string4, n2, n, flushMode, cacheMode, bl2, string5, null, bl3);
        } else {
            AnnotationValue annotationValue = annotationInstance.value("resultClass");
            if (annotationValue == null) {
                throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
            }
            NativeSQLQueryReturn[] nativeSQLQueryReturnArray = new NativeSQLQueryRootReturn[]{new NativeSQLQueryRootReturn("alias1", annotationValue.asString(), new HashMap<String, String[]>(), LockMode.READ)};
            namedSQLQueryDefinition = new NamedSQLQueryDefinition(string, string2, nativeSQLQueryReturnArray, null, bl, string4, n2, n, flushMode, cacheMode, bl2, string5, null, bl3);
        }
        metadataImplementor.addNamedNativeQuery(namedSQLQueryDefinition);
        LOG.debugf("Binding named native query: %s => %s", (Object)string, (Object)string2);
    }

    private static boolean getBoolean(AnnotationInstance[] annotationInstanceArray, String string, String string2) {
        String string3 = QueryBinder.getString(annotationInstanceArray, string);
        if (string3 == null || string3.equalsIgnoreCase("false")) {
            return false;
        }
        if (string3.equalsIgnoreCase("true")) {
            return true;
        }
        throw new AnnotationException("Not a boolean in hint: " + string2 + ":" + string);
    }

    private static CacheMode getCacheMode(AnnotationInstance[] annotationInstanceArray, String string, String string2) {
        String string3 = QueryBinder.getString(annotationInstanceArray, string);
        if (string3 == null) {
            return null;
        }
        if (string3.equalsIgnoreCase(CacheMode.GET.toString())) {
            return CacheMode.GET;
        }
        if (string3.equalsIgnoreCase(CacheMode.IGNORE.toString())) {
            return CacheMode.IGNORE;
        }
        if (string3.equalsIgnoreCase(CacheMode.NORMAL.toString())) {
            return CacheMode.NORMAL;
        }
        if (string3.equalsIgnoreCase(CacheMode.PUT.toString())) {
            return CacheMode.PUT;
        }
        if (string3.equalsIgnoreCase(CacheMode.REFRESH.toString())) {
            return CacheMode.REFRESH;
        }
        throw new AnnotationException("Unknown CacheMode in hint: " + string2 + ":" + string);
    }

    private static FlushMode getFlushMode(AnnotationInstance[] annotationInstanceArray, String string, String string2) {
        String string3 = QueryBinder.getString(annotationInstanceArray, string);
        if (string3 == null) {
            return null;
        }
        if (string3.equalsIgnoreCase(FlushMode.ALWAYS.toString())) {
            return FlushMode.ALWAYS;
        }
        if (string3.equalsIgnoreCase(FlushMode.AUTO.toString())) {
            return FlushMode.AUTO;
        }
        if (string3.equalsIgnoreCase(FlushMode.COMMIT.toString())) {
            return FlushMode.COMMIT;
        }
        if (string3.equalsIgnoreCase(FlushMode.NEVER.toString())) {
            return FlushMode.MANUAL;
        }
        if (string3.equalsIgnoreCase(FlushMode.MANUAL.toString())) {
            return FlushMode.MANUAL;
        }
        throw new AnnotationException("Unknown FlushMode in hint: " + string2 + ":" + string);
    }

    private static Integer getInteger(AnnotationInstance[] annotationInstanceArray, String string, String string2) {
        String string3 = QueryBinder.getString(annotationInstanceArray, string);
        if (string3 == null) {
            return null;
        }
        try {
            return Integer.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AnnotationException("Not an integer in hint: " + string2 + ":" + string, numberFormatException);
        }
    }

    private static String getString(AnnotationInstance[] annotationInstanceArray, String string) {
        for (AnnotationInstance annotationInstance : annotationInstanceArray) {
            if (!string.equals(JandexHelper.getValue(annotationInstance, "name", String.class))) continue;
            return JandexHelper.getValue(annotationInstance, "value", String.class);
        }
        return null;
    }

    private static Integer getTimeout(AnnotationInstance[] annotationInstanceArray, String string) {
        Integer n = QueryBinder.getInteger(annotationInstanceArray, "javax.persistence.query.timeout", string);
        if (n == null) {
            return QueryBinder.getInteger(annotationInstanceArray, "org.hibernate.timeout", string);
        }
        return (n + 500) / 1000;
    }
}

