/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.GenerationType;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.EnumConversionHelper;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdGeneratorBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IdGeneratorBinder.class.getName());

    private IdGeneratorBinder() {
    }

    public static void bind(AnnotationBindingContext annotationBindingContext) {
        List list = annotationBindingContext.getIndex().getAnnotations(JPADotNames.SEQUENCE_GENERATOR);
        for (AnnotationInstance annotationInstance : list) {
            IdGeneratorBinder.bindSequenceGenerator(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(JPADotNames.TABLE_GENERATOR);
        for (AnnotationInstance annotationInstance : list) {
            IdGeneratorBinder.bindTableGenerator(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.GENERIC_GENERATOR);
        for (AnnotationInstance annotationInstance : list) {
            IdGeneratorBinder.bindGenericGenerator(annotationBindingContext.getMetadataImplementor(), annotationInstance);
        }
        list = annotationBindingContext.getIndex().getAnnotations(HibernateDotNames.GENERIC_GENERATORS);
        for (AnnotationInstance annotationInstance : list) {
            for (AnnotationInstance annotationInstance2 : JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class)) {
                IdGeneratorBinder.bindGenericGenerator(annotationBindingContext.getMetadataImplementor(), annotationInstance2);
            }
        }
    }

    private static void addStringParameter(AnnotationInstance annotationInstance, String string, Map<String, String> map, String string2) {
        String string3 = JandexHelper.getValue(annotationInstance, string, String.class);
        if (StringHelper.isNotEmpty(string3)) {
            map.put(string2, string3);
        }
    }

    private static void bindGenericGenerator(MetadataImplementor metadataImplementor, AnnotationInstance annotationInstance) {
        AnnotationInstance[] annotationInstanceArray;
        String string = JandexHelper.getValue(annotationInstance, "name", String.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (AnnotationInstance annotationInstance2 : annotationInstanceArray = JandexHelper.getValue(annotationInstance, "parameters", AnnotationInstance[].class)) {
            hashMap.put(JandexHelper.getValue(annotationInstance2, "name", String.class), JandexHelper.getValue(annotationInstance2, "value", String.class));
        }
        metadataImplementor.addIdGenerator(new IdGenerator(string, JandexHelper.getValue(annotationInstance, "strategy", String.class), hashMap));
        LOG.tracef("Add generic generator with name: %s", (Object)string);
    }

    private static void bindSequenceGenerator(MetadataImplementor metadataImplementor, AnnotationInstance annotationInstance) {
        String string = JandexHelper.getValue(annotationInstance, "name", String.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IdGeneratorBinder.addStringParameter(annotationInstance, "sequenceName", hashMap, "sequence_name");
        boolean bl = metadataImplementor.getOptions().useNewIdentifierGenerators();
        String string2 = EnumConversionHelper.generationTypeToGeneratorStrategyName(GenerationType.SEQUENCE, bl);
        if (bl) {
            IdGeneratorBinder.addStringParameter(annotationInstance, "catalog", hashMap, "catalog");
            IdGeneratorBinder.addStringParameter(annotationInstance, "schema", hashMap, "schema");
            hashMap.put("increment_size", String.valueOf(JandexHelper.getValue(annotationInstance, "allocationSize", Integer.class)));
            hashMap.put("initial_value", String.valueOf(JandexHelper.getValue(annotationInstance, "initialValue", Integer.class)));
        } else {
            if (JandexHelper.getValue(annotationInstance, "initialValue", Integer.class) != 1) {
                LOG.unsupportedInitialValue("hibernate.id.new_generator_mappings");
            }
            hashMap.put("max_lo", String.valueOf(JandexHelper.getValue(annotationInstance, "allocationSize", Integer.class) - 1));
        }
        metadataImplementor.addIdGenerator(new IdGenerator(string, string2, hashMap));
        LOG.tracef("Add sequence generator with name: %s", (Object)string);
    }

    private static void bindTableGenerator(MetadataImplementor metadataImplementor, AnnotationInstance annotationInstance) {
        String string = JandexHelper.getValue(annotationInstance, "name", String.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IdGeneratorBinder.addStringParameter(annotationInstance, "catalog", hashMap, "catalog");
        IdGeneratorBinder.addStringParameter(annotationInstance, "schema", hashMap, "schema");
        boolean bl = metadataImplementor.getOptions().useNewIdentifierGenerators();
        String string2 = EnumConversionHelper.generationTypeToGeneratorStrategyName(GenerationType.TABLE, bl);
        if (bl) {
            hashMap.put("prefer_entity_table_as_segment_value", "true");
            IdGeneratorBinder.addStringParameter(annotationInstance, "table", hashMap, "table_name");
            IdGeneratorBinder.addStringParameter(annotationInstance, "pkColumnName", hashMap, "segment_column_name");
            IdGeneratorBinder.addStringParameter(annotationInstance, "pkColumnValue", hashMap, "segment_value");
            IdGeneratorBinder.addStringParameter(annotationInstance, "valueColumnName", hashMap, "value_column_name");
            hashMap.put("increment_size", String.valueOf(JandexHelper.getValue(annotationInstance, "allocationSize", String.class)));
            hashMap.put("initial_value", String.valueOf(JandexHelper.getValue(annotationInstance, "initialValue", String.class) + 1));
        } else {
            IdGeneratorBinder.addStringParameter(annotationInstance, "table", hashMap, "table");
            IdGeneratorBinder.addStringParameter(annotationInstance, "pkColumnName", hashMap, "primary_key_column");
            IdGeneratorBinder.addStringParameter(annotationInstance, "pkColumnValue", hashMap, "primary_key_value");
            IdGeneratorBinder.addStringParameter(annotationInstance, "valueColumnName", hashMap, "value_column");
            hashMap.put("max_lo", String.valueOf(JandexHelper.getValue(annotationInstance, "allocationSize", Integer.class) - 1));
        }
        if (JandexHelper.getValue(annotationInstance, "uniqueConstraints", AnnotationInstance[].class).length > 0) {
            LOG.ignoringTableGeneratorConstraints(string);
        }
        metadataImplementor.addIdGenerator(new IdGenerator(string, string2, hashMap));
        LOG.tracef("Add table generator with name: %s", (Object)string);
    }
}

