/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AccessType;
import javax.persistence.DiscriminatorType;
import javax.persistence.PersistenceException;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.ColumnValues;
import org.hibernate.metamodel.source.annotations.attribute.FormulaValue;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClass;
import org.hibernate.metamodel.source.annotations.entity.IdType;
import org.hibernate.metamodel.source.annotations.entity.TableSourceImpl;
import org.hibernate.metamodel.source.annotations.entity.UniqueConstraintSourceImpl;
import org.hibernate.metamodel.source.annotations.xml.PseudoJpaDotNames;
import org.hibernate.metamodel.source.binder.ConstraintSource;
import org.hibernate.metamodel.source.binder.JpaCallbackClass;
import org.hibernate.metamodel.source.binder.TableSource;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityClass
extends ConfiguredClass {
    private final IdType idType;
    private final InheritanceType inheritanceType;
    private final String explicitEntityName;
    private final String customLoaderQueryName;
    private final List<String> synchronizedTableNames;
    private final int batchSize;
    private final TableSource primaryTableSource;
    private final Set<TableSource> secondaryTableSources;
    private final Set<ConstraintSource> constraintSources;
    private boolean isMutable;
    private boolean isExplicitPolymorphism;
    private OptimisticLockStyle optimisticLockStyle;
    private String whereClause;
    private String rowId;
    private Caching caching;
    private boolean isDynamicInsert;
    private boolean isDynamicUpdate;
    private boolean isSelectBeforeUpdate;
    private String customPersister;
    private CustomSQL customInsert;
    private CustomSQL customUpdate;
    private CustomSQL customDelete;
    private boolean isLazy;
    private String proxy;
    private ColumnValues discriminatorColumnValues;
    private FormulaValue discriminatorFormula;
    private Class<?> discriminatorType;
    private String discriminatorMatchValue;
    private boolean isDiscriminatorForced = true;
    private boolean isDiscriminatorIncludedInSql = true;
    private final List<JpaCallbackClass> jpaCallbacks;

    public EntityClass(ClassInfo classInfo, EntityClass entityClass, AccessType accessType, InheritanceType inheritanceType, AnnotationBindingContext annotationBindingContext) {
        super(classInfo, accessType, entityClass, annotationBindingContext);
        this.inheritanceType = inheritanceType;
        this.idType = this.determineIdType();
        boolean bl = this.definesItsOwnTable();
        this.explicitEntityName = this.determineExplicitEntityName();
        this.constraintSources = new HashSet<ConstraintSource>();
        if (bl) {
            AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.TABLE);
            this.primaryTableSource = this.createTableSource(annotationInstance);
        } else {
            this.primaryTableSource = null;
        }
        this.secondaryTableSources = this.createSecondaryTableSources();
        this.customLoaderQueryName = this.determineCustomLoader();
        this.synchronizedTableNames = this.determineSynchronizedTableNames();
        this.batchSize = this.determineBatchSize();
        this.jpaCallbacks = this.determineEntityListeners();
        this.processHibernateEntitySpecificAnnotations();
        this.processCustomSqlAnnotations();
        this.processProxyGeneration();
        this.processDiscriminator();
    }

    public ColumnValues getDiscriminatorColumnValues() {
        return this.discriminatorColumnValues;
    }

    public FormulaValue getDiscriminatorFormula() {
        return this.discriminatorFormula;
    }

    public Class<?> getDiscriminatorType() {
        return this.discriminatorType;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public boolean isExplicitPolymorphism() {
        return this.isExplicitPolymorphism;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public String getRowId() {
        return this.rowId;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public TableSource getPrimaryTableSource() {
        if (this.definesItsOwnTable()) {
            return this.primaryTableSource;
        }
        return ((EntityClass)this.getParent()).getPrimaryTableSource();
    }

    public Set<TableSource> getSecondaryTableSources() {
        return this.secondaryTableSources;
    }

    public Set<ConstraintSource> getConstraintSources() {
        return this.constraintSources;
    }

    public String getExplicitEntityName() {
        return this.explicitEntityName;
    }

    public String getEntityName() {
        return this.getConfiguredClass().getSimpleName();
    }

    public boolean isDynamicInsert() {
        return this.isDynamicInsert;
    }

    public boolean isDynamicUpdate() {
        return this.isDynamicUpdate;
    }

    public boolean isSelectBeforeUpdate() {
        return this.isSelectBeforeUpdate;
    }

    public String getCustomLoaderQueryName() {
        return this.customLoaderQueryName;
    }

    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }

    public List<String> getSynchronizedTableNames() {
        return this.synchronizedTableNames;
    }

    public String getCustomPersister() {
        return this.customPersister;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public String getProxy() {
        return this.proxy;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isEntityRoot() {
        return this.getParent() == null;
    }

    public boolean isDiscriminatorForced() {
        return this.isDiscriminatorForced;
    }

    public boolean isDiscriminatorIncludedInSql() {
        return this.isDiscriminatorIncludedInSql;
    }

    public String getDiscriminatorMatchValue() {
        return this.discriminatorMatchValue;
    }

    public List<JpaCallbackClass> getJpaCallbacks() {
        return this.jpaCallbacks;
    }

    private String determineExplicitEntityName() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.ENTITY);
        return JandexHelper.getValue(annotationInstance, "name", String.class);
    }

    private boolean definesItsOwnTable() {
        return !InheritanceType.SINGLE_TABLE.equals((Object)this.inheritanceType) || this.isEntityRoot();
    }

    private IdType determineIdType() {
        List<AnnotationInstance> list = this.findIdAnnotations(JPADotNames.ID);
        List<AnnotationInstance> list2 = this.findIdAnnotations(JPADotNames.EMBEDDED_ID);
        if (!list.isEmpty() && !list2.isEmpty()) {
            throw new MappingException("@EmbeddedId and @Id cannot be used together. Check the configuration for " + this.getName() + ".");
        }
        if (!list2.isEmpty()) {
            if (list2.size() == 1) {
                return IdType.EMBEDDED;
            }
            throw new AnnotationException("Multiple @EmbeddedId annotations are not allowed");
        }
        if (!list.isEmpty()) {
            return list.size() == 1 ? IdType.SIMPLE : IdType.COMPOSED;
        }
        return IdType.NONE;
    }

    private List<AnnotationInstance> findIdAnnotations(DotName dotName) {
        ArrayList<AnnotationInstance> arrayList = new ArrayList<AnnotationInstance>();
        if (this.getClassInfo().annotations().containsKey(dotName)) {
            arrayList.addAll((Collection)this.getClassInfo().annotations().get(dotName));
        }
        for (ConfiguredClass configuredClass = this.getParent(); configuredClass != null; configuredClass = configuredClass.getParent()) {
            if (!configuredClass.getClassInfo().annotations().containsKey(dotName)) continue;
            arrayList.addAll((Collection)configuredClass.getClassInfo().annotations().get(dotName));
        }
        return arrayList;
    }

    private void processDiscriminator() {
        Object object;
        if (!InheritanceType.SINGLE_TABLE.equals((Object)this.inheritanceType)) {
            return;
        }
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.DISCRIMINATOR_VALUE);
        if (annotationInstance != null) {
            this.discriminatorMatchValue = annotationInstance.value().asString();
        }
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.DISCRIMINATOR_COLUMN);
        AnnotationInstance annotationInstance3 = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.DISCRIMINATOR_FORMULA);
        Class clazz = String.class;
        if (annotationInstance3 != null) {
            object = JandexHelper.getValue(annotationInstance3, "value", String.class);
            this.discriminatorFormula = new FormulaValue(this.getPrimaryTableSource().getExplicitTableName(), (String)object);
        }
        this.discriminatorColumnValues = new ColumnValues(null);
        this.discriminatorColumnValues.setNullable(false);
        if (annotationInstance2 != null) {
            object = Enum.valueOf(DiscriminatorType.class, annotationInstance2.value("discriminatorType").asEnum());
            switch (1.$SwitchMap$javax$persistence$DiscriminatorType[((Enum)object).ordinal()]) {
                case 1: {
                    clazz = String.class;
                    break;
                }
                case 2: {
                    clazz = Character.class;
                    break;
                }
                case 3: {
                    clazz = Integer.class;
                    break;
                }
                default: {
                    throw new AnnotationException("Unsupported discriminator type: " + object);
                }
            }
            this.discriminatorColumnValues.setName(JandexHelper.getValue(annotationInstance2, "name", String.class));
            this.discriminatorColumnValues.setLength(JandexHelper.getValue(annotationInstance2, "length", Integer.class));
            this.discriminatorColumnValues.setColumnDefinition(JandexHelper.getValue(annotationInstance2, "columnDefinition", String.class));
        }
        this.discriminatorType = clazz;
        object = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.DISCRIMINATOR_OPTIONS);
        if (object != null) {
            this.isDiscriminatorForced = object.value("force").asBoolean();
            this.isDiscriminatorIncludedInSql = object.value("insert").asBoolean();
        } else {
            this.isDiscriminatorForced = false;
            this.isDiscriminatorIncludedInSql = true;
        }
    }

    private void processHibernateEntitySpecificAnnotations() {
        String string;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.ENTITY);
        PolymorphismType polymorphismType = PolymorphismType.IMPLICIT;
        if (annotationInstance != null && annotationInstance.value("polymorphism") != null) {
            polymorphismType = PolymorphismType.valueOf(annotationInstance.value("polymorphism").asEnum());
        }
        this.isExplicitPolymorphism = polymorphismType == PolymorphismType.EXPLICIT;
        OptimisticLockType optimisticLockType = OptimisticLockType.VERSION;
        if (annotationInstance != null && annotationInstance.value("optimisticLock") != null) {
            optimisticLockType = OptimisticLockType.valueOf(annotationInstance.value("optimisticLock").asEnum());
        }
        this.optimisticLockStyle = OptimisticLockStyle.valueOf(optimisticLockType.name());
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.IMMUTABLE);
        this.isMutable = annotationInstance2 == null && annotationInstance != null && annotationInstance.value("mutable") != null && annotationInstance.value("mutable").asBoolean();
        AnnotationInstance annotationInstance3 = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.WHERE);
        this.whereClause = annotationInstance3 != null && annotationInstance3.value("clause") != null ? annotationInstance3.value("clause").asString() : null;
        AnnotationInstance annotationInstance4 = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.ROW_ID);
        this.rowId = annotationInstance4 != null && annotationInstance4.value() != null ? annotationInstance4.value().asString() : null;
        this.caching = this.determineCachingSettings();
        this.isDynamicInsert = annotationInstance != null && annotationInstance.value("dynamicInsert") != null && annotationInstance.value("dynamicInsert").asBoolean();
        this.isDynamicUpdate = annotationInstance != null && annotationInstance.value("dynamicUpdate") != null && annotationInstance.value("dynamicUpdate").asBoolean();
        this.isSelectBeforeUpdate = annotationInstance != null && annotationInstance.value("selectBeforeUpdate") != null && annotationInstance.value("selectBeforeUpdate").asBoolean();
        AnnotationInstance annotationInstance5 = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.PERSISTER);
        if (annotationInstance5 == null || annotationInstance5.value("impl") == null) {
            string = annotationInstance != null && annotationInstance.value("persister") != null ? annotationInstance.value("persister").asString() : null;
        } else {
            if (annotationInstance == null || annotationInstance.value("persister") != null) {
                // empty if block
            }
            string = annotationInstance5.value("impl").asString();
        }
        this.customPersister = string;
    }

    private Caching determineCachingSettings() {
        boolean bl;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.CACHE);
        if (annotationInstance != null) {
            org.hibernate.cache.spi.access.AccessType accessType = annotationInstance.value("usage") == null ? this.getLocalBindingContext().getMappingDefaults().getCacheAccessType() : CacheConcurrencyStrategy.parse(annotationInstance.value("usage").asEnum()).toAccessType();
            return new Caching(annotationInstance.value("region") == null ? this.getName() : annotationInstance.value("region").asString(), accessType, annotationInstance.value("include") != null && "all".equals(annotationInstance.value("include").asString()));
        }
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.CACHEABLE);
        boolean bl2 = true;
        if (annotationInstance2 != null && annotationInstance2.value() != null) {
            bl2 = annotationInstance2.value().asBoolean();
        }
        switch (this.getLocalBindingContext().getMetadataImplementor().getOptions().getSharedCacheMode()) {
            case ALL: {
                bl = true;
                break;
            }
            case ENABLE_SELECTIVE: {
                bl = bl2;
                break;
            }
            case DISABLE_SELECTIVE: {
                bl = annotationInstance2 == null || bl2;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            return null;
        }
        return new Caching(this.getName(), this.getLocalBindingContext().getMappingDefaults().getCacheAccessType(), true);
    }

    private TableSource createTableSource(AnnotationInstance annotationInstance) {
        String string = null;
        String string2 = null;
        if (annotationInstance != null) {
            string = JandexHelper.getValue(annotationInstance, "schema", String.class);
            string2 = JandexHelper.getValue(annotationInstance, "catalog", String.class);
        }
        String string3 = null;
        String string4 = null;
        if (annotationInstance != null) {
            string4 = JandexHelper.getValue(annotationInstance, "name", String.class);
            if (StringHelper.isNotEmpty(string4)) {
                string3 = string4;
            }
            this.createUniqueConstraints(annotationInstance, string3);
        }
        TableSourceImpl tableSourceImpl = annotationInstance == null || JPADotNames.TABLE.equals((Object)annotationInstance.name()) ? new TableSourceImpl(string, string2, string3, null) : new TableSourceImpl(string, string2, string3, string4);
        return tableSourceImpl;
    }

    private Set<TableSource> createSecondaryTableSources() {
        HashSet<TableSource> hashSet = new HashSet<TableSource>();
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.SECONDARY_TABLES);
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.SECONDARY_TABLE);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (annotationInstance2 != null) {
            arrayList.add(annotationInstance2);
        }
        if (annotationInstance != null) {
            arrayList.addAll(Arrays.asList((Object[])JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class)));
        }
        for (AnnotationInstance annotationInstance3 : arrayList) {
            hashSet.add(this.createTableSource(annotationInstance3));
        }
        return hashSet;
    }

    private void createUniqueConstraints(AnnotationInstance annotationInstance, String string) {
        AnnotationInstance[] annotationInstanceArray;
        AnnotationValue annotationValue = annotationInstance.value("uniqueConstraints");
        if (annotationValue == null) {
            return;
        }
        for (AnnotationInstance annotationInstance2 : annotationInstanceArray = annotationValue.asNestedArray()) {
            String string2 = annotationInstance2.value("name") == null ? null : annotationInstance2.value("name").asString();
            String[] stringArray = annotationInstance2.value("columnNames").asStringArray();
            UniqueConstraintSourceImpl uniqueConstraintSourceImpl = new UniqueConstraintSourceImpl(string2, string, Arrays.asList(stringArray));
            this.constraintSources.add(uniqueConstraintSourceImpl);
        }
    }

    private String determineCustomLoader() {
        String string = null;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.LOADER);
        if (annotationInstance != null) {
            string = annotationInstance.value("namedQuery").asString();
        }
        return string;
    }

    private CustomSQL createCustomSQL(AnnotationInstance annotationInstance) {
        boolean bl;
        if (annotationInstance == null) {
            return null;
        }
        String string = annotationInstance.value("sql").asString();
        boolean bl2 = bl = annotationInstance.value("callable") != null && annotationInstance.value("callable").asBoolean();
        ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = annotationInstance.value("check") == null ? (bl ? ExecuteUpdateResultCheckStyle.NONE : ExecuteUpdateResultCheckStyle.COUNT) : ExecuteUpdateResultCheckStyle.valueOf(annotationInstance.value("check").asEnum());
        return new CustomSQL(string, bl, executeUpdateResultCheckStyle);
    }

    private void processCustomSqlAnnotations() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.SQL_INSERT);
        this.customInsert = this.createCustomSQL(annotationInstance);
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.SQL_UPDATE);
        this.customUpdate = this.createCustomSQL(annotationInstance2);
        AnnotationInstance annotationInstance3 = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.SQL_DELETE);
        this.customDelete = this.createCustomSQL(annotationInstance3);
    }

    private List<String> determineSynchronizedTableNames() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.SYNCHRONIZE);
        if (annotationInstance != null) {
            String[] stringArray = annotationInstance.value().asStringArray();
            return Arrays.asList(stringArray);
        }
        return Collections.emptyList();
    }

    private void processProxyGeneration() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.PROXY);
        if (annotationInstance != null) {
            AnnotationValue annotationValue;
            boolean bl = this.isLazy = annotationInstance.value("lazy") == null || annotationInstance.value("lazy").asBoolean();
            this.proxy = this.isLazy ? ((annotationValue = annotationInstance.value("proxyClass")) == null ? this.getName() : annotationValue.asString()) : null;
        } else {
            this.isLazy = true;
            this.proxy = this.getName();
        }
    }

    private int determineBatchSize() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.BATCH_SIZE);
        return annotationInstance == null ? -1 : annotationInstance.value("size").asInt();
    }

    private List<JpaCallbackClass> determineEntityListeners() {
        String string;
        List list;
        ArrayList<JpaCallbackClass> arrayList = new ArrayList<JpaCallbackClass>();
        if (JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.EXCLUDE_DEFAULT_LISTENERS) == null) {
            list = this.getLocalBindingContext().getIndex().getAnnotations(PseudoJpaDotNames.DEFAULT_ENTITY_LISTENERS);
            for (AnnotationInstance annotationInstance : list) {
                for (Type type : annotationInstance.value().asClassArray()) {
                    string = type.name().toString();
                    try {
                        this.processDefaultJpaCallbacks(string, arrayList);
                    }
                    catch (PersistenceException persistenceException) {
                        throw new PersistenceException(persistenceException.getMessage() + "default entity listener " + string);
                    }
                }
            }
        }
        if ((list = (List)this.getClassInfo().annotations().get(JPADotNames.ENTITY_LISTENERS)) != null) {
            for (AnnotationInstance annotationInstance : list) {
                for (Type type : annotationInstance.value().asClassArray()) {
                    string = type.name().toString();
                    try {
                        this.processJpaCallbacks(string, true, arrayList);
                    }
                    catch (PersistenceException persistenceException) {
                        throw new PersistenceException(persistenceException.getMessage() + "entity listener " + string);
                    }
                }
            }
        }
        try {
            this.processJpaCallbacks(this.getName(), false, arrayList);
        }
        catch (PersistenceException persistenceException) {
            throw new PersistenceException(persistenceException.getMessage() + "entity/mapped superclass " + this.getClassInfo().name().toString());
        }
        return arrayList;
    }

    private void processDefaultJpaCallbacks(String string, List<JpaCallbackClass> list) {
        Object object;
        ClassInfo classInfo = this.getLocalBindingContext().getClassInfo(string);
        if (JandexHelper.getSingleAnnotation(classInfo, JPADotNames.EXCLUDE_SUPERCLASS_LISTENERS) != null && (object = classInfo.superName()) != null) {
            this.processDefaultJpaCallbacks(string, list);
        }
        object = classInfo.name().toString();
        HashMap hashMap = new HashMap();
        this.createDefaultCallback(PrePersist.class, PseudoJpaDotNames.DEFAULT_PRE_PERSIST, (String)object, hashMap);
        this.createDefaultCallback(PreRemove.class, PseudoJpaDotNames.DEFAULT_PRE_REMOVE, (String)object, hashMap);
        this.createDefaultCallback(PreUpdate.class, PseudoJpaDotNames.DEFAULT_PRE_UPDATE, (String)object, hashMap);
        this.createDefaultCallback(PostLoad.class, PseudoJpaDotNames.DEFAULT_POST_LOAD, (String)object, hashMap);
        this.createDefaultCallback(PostPersist.class, PseudoJpaDotNames.DEFAULT_POST_PERSIST, (String)object, hashMap);
        this.createDefaultCallback(PostRemove.class, PseudoJpaDotNames.DEFAULT_POST_REMOVE, (String)object, hashMap);
        this.createDefaultCallback(PostUpdate.class, PseudoJpaDotNames.DEFAULT_POST_UPDATE, (String)object, hashMap);
        if (!hashMap.isEmpty()) {
            list.add(new JpaCallbackClassImpl(string, hashMap, true));
        }
    }

    private void processJpaCallbacks(String string, boolean bl, List<JpaCallbackClass> list) {
        Object object;
        ClassInfo classInfo = this.getLocalBindingContext().getClassInfo(string);
        if (JandexHelper.getSingleAnnotation(classInfo, JPADotNames.EXCLUDE_SUPERCLASS_LISTENERS) != null && (object = classInfo.superName()) != null) {
            this.processJpaCallbacks(string, bl, list);
        }
        object = new HashMap();
        this.createCallback(PrePersist.class, JPADotNames.PRE_PERSIST, (Map<Class<?>, String>)object, classInfo, bl);
        this.createCallback(PreRemove.class, JPADotNames.PRE_REMOVE, (Map<Class<?>, String>)object, classInfo, bl);
        this.createCallback(PreUpdate.class, JPADotNames.PRE_UPDATE, (Map<Class<?>, String>)object, classInfo, bl);
        this.createCallback(PostLoad.class, JPADotNames.POST_LOAD, (Map<Class<?>, String>)object, classInfo, bl);
        this.createCallback(PostPersist.class, JPADotNames.POST_PERSIST, (Map<Class<?>, String>)object, classInfo, bl);
        this.createCallback(PostRemove.class, JPADotNames.POST_REMOVE, (Map<Class<?>, String>)object, classInfo, bl);
        this.createCallback(PostUpdate.class, JPADotNames.POST_UPDATE, (Map<Class<?>, String>)object, classInfo, bl);
        if (!object.isEmpty()) {
            list.add(new JpaCallbackClassImpl(string, (Map)object, bl));
        }
    }

    private void createDefaultCallback(Class clazz, DotName dotName, String string, Map<Class<?>, String> map) {
        for (AnnotationInstance annotationInstance : this.getLocalBindingContext().getIndex().getAnnotations(dotName)) {
            MethodInfo methodInfo = (MethodInfo)annotationInstance.target();
            this.validateMethod(methodInfo, clazz, map, true);
            if (!methodInfo.declaringClass().name().toString().equals(string)) continue;
            if (methodInfo.args().length != 1) {
                throw new PersistenceException(String.format("Callback method %s must have exactly one argument defined as either Object or %s in ", methodInfo.name(), this.getEntityName()));
            }
            map.put(clazz, methodInfo.name());
        }
    }

    private void createCallback(Class clazz, DotName dotName, Map<Class<?>, String> map, ClassInfo classInfo, boolean bl) {
        Map map2 = classInfo.annotations();
        List list = (List)map2.get(dotName);
        if (list == null) {
            return;
        }
        for (AnnotationInstance annotationInstance : list) {
            MethodInfo methodInfo = (MethodInfo)annotationInstance.target();
            this.validateMethod(methodInfo, clazz, map, bl);
            map.put(clazz, methodInfo.name());
        }
    }

    private void validateMethod(MethodInfo methodInfo, Class clazz, Map<Class<?>, String> map, boolean bl) {
        if (methodInfo.returnType().kind() != Type.Kind.VOID) {
            throw new PersistenceException("Callback method " + methodInfo.name() + " must have a void return type in ");
        }
        if (Modifier.isStatic(methodInfo.flags()) || Modifier.isFinal(methodInfo.flags())) {
            throw new PersistenceException("Callback method " + methodInfo.name() + " must not be static or final in ");
        }
        Type[] typeArray = methodInfo.args();
        if (bl) {
            if (typeArray.length != 1) {
                throw new PersistenceException("Callback method " + methodInfo.name() + " must have exactly one argument in ");
            }
            String string = typeArray[0].name().toString();
            if (!string.equals(Object.class.getName()) && !string.equals(this.getName())) {
                throw new PersistenceException("The argument for callback method " + methodInfo.name() + " must be defined as either Object or " + this.getEntityName() + " in ");
            }
        } else if (typeArray.length != 0) {
            throw new PersistenceException("Callback method " + methodInfo.name() + " must have no arguments in ");
        }
        if (map.containsKey(clazz)) {
            throw new PersistenceException("Only one method may be annotated as a " + clazz.getSimpleName() + " callback method in ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JpaCallbackClassImpl
    implements JpaCallbackClass {
        private final Map<Class<?>, String> callbacksByType;
        private final String name;
        private final boolean isListener;

        private JpaCallbackClassImpl(String string, Map<Class<?>, String> map, boolean bl) {
            this.name = string;
            this.callbacksByType = map;
            this.isListener = bl;
        }

        @Override
        public String getCallbackMethod(Class<?> clazz) {
            return this.callbacksByType.get(clazz);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isListener() {
            return this.isListener;
        }
    }
}

