/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.AccessType;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.entity.EmbeddableClass;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddableHierarchy
implements Iterable<EmbeddableClass> {
    private final AccessType defaultAccessType;
    private final List<EmbeddableClass> embeddables;

    public static EmbeddableHierarchy createEmbeddableHierarchy(Class<?> clazz, String string, AccessType accessType, AnnotationBindingContext annotationBindingContext) {
        ClassInfo classInfo = annotationBindingContext.getClassInfo(clazz.getName());
        if (classInfo == null) {
            throw new AssertionFailure(String.format("The specified class %s cannot be found in the annotation index", clazz.getName()));
        }
        if (JandexHelper.getSingleAnnotation(classInfo, JPADotNames.EMBEDDABLE) == null) {
            throw new AssertionFailure(String.format("The specified class %s is not annotated with @Embeddable even though it is as embeddable", clazz.getName()));
        }
        ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
        for (Class<?> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            ClassInfo classInfo2 = annotationBindingContext.getIndex().getClassByName(DotName.createSimple((String)clazz2.getName()));
            if (classInfo2 == null) continue;
            arrayList.add(0, classInfo2);
        }
        return new EmbeddableHierarchy(arrayList, string, annotationBindingContext, accessType);
    }

    private EmbeddableHierarchy(List<ClassInfo> list, String string, AnnotationBindingContext annotationBindingContext, AccessType accessType) {
        this.defaultAccessType = accessType;
        annotationBindingContext.resolveAllTypes(list.get(list.size() - 1).name().toString());
        this.embeddables = new ArrayList<EmbeddableClass>();
        EmbeddableClass embeddableClass = null;
        for (ClassInfo classInfo : list) {
            EmbeddableClass embeddableClass2 = new EmbeddableClass(classInfo, string, embeddableClass, accessType, annotationBindingContext);
            this.embeddables.add(embeddableClass2);
            embeddableClass = embeddableClass2;
        }
    }

    public AccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    @Override
    public Iterator<EmbeddableClass> iterator() {
        return this.embeddables.iterator();
    }

    public EmbeddableClass getLeaf() {
        return this.embeddables.get(this.embeddables.size() - 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EmbeddableHierarchy");
        stringBuilder.append("{defaultAccessType=").append((Object)this.defaultAccessType);
        stringBuilder.append(", embeddables=").append(this.embeddables);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

