/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import javax.persistence.AccessType;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClass;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;

public class EmbeddableClass
extends ConfiguredClass {
    private final String embeddedAttributeName;
    private final String parentReferencingAttributeName;

    public EmbeddableClass(ClassInfo classInfo, String string, ConfiguredClass configuredClass, AccessType accessType, AnnotationBindingContext annotationBindingContext) {
        super(classInfo, accessType, configuredClass, annotationBindingContext);
        this.embeddedAttributeName = string;
        this.parentReferencingAttributeName = this.checkParentAnnotation();
    }

    private String checkParentAnnotation() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.PARENT);
        if (annotationInstance == null) {
            return null;
        }
        return JandexHelper.getPropertyName(annotationInstance.target());
    }

    public String getEmbeddedAttributeName() {
        return this.embeddedAttributeName;
    }

    public String getParentReferencingAttributeName() {
        return this.parentReferencingAttributeName;
    }
}

