/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedMember;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.AccessType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.ReflectionHelper;
import org.hibernate.metamodel.source.annotations.attribute.AssociationAttribute;
import org.hibernate.metamodel.source.annotations.attribute.AttributeNature;
import org.hibernate.metamodel.source.annotations.attribute.AttributeOverride;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClassType;
import org.hibernate.metamodel.source.annotations.entity.EmbeddableClass;
import org.hibernate.metamodel.source.annotations.entity.EmbeddableHierarchy;
import org.hibernate.metamodel.source.annotations.entity.EntityBindingContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredClass {
    public static final Logger LOG = Logger.getLogger(ConfiguredClass.class.getName());
    private final ConfiguredClass parent;
    private final ClassInfo classInfo;
    private final Class<?> clazz;
    private final AccessType classAccessType;
    private final ConfiguredClassType configuredClassType;
    private final Map<String, BasicAttribute> idAttributeMap;
    private final Map<String, AssociationAttribute> associationAttributeMap;
    private final Map<String, BasicAttribute> simpleAttributeMap;
    private BasicAttribute versionAttribute;
    private final Map<String, EmbeddableClass> embeddedClasses = new HashMap<String, EmbeddableClass>();
    private final Map<String, AttributeOverride> attributeOverrideMap;
    private final Set<String> transientFieldNames = new HashSet<String>();
    private final Set<String> transientMethodNames = new HashSet<String>();
    private final String customTuplizer;
    private final EntityBindingContext localBindingContext;

    public ConfiguredClass(ClassInfo classInfo, AccessType accessType, ConfiguredClass configuredClass, AnnotationBindingContext annotationBindingContext) {
        this.parent = configuredClass;
        this.classInfo = classInfo;
        this.clazz = annotationBindingContext.locateClassByName(classInfo.toString());
        this.configuredClassType = this.determineType();
        this.classAccessType = this.determineClassAccessType(accessType);
        this.customTuplizer = this.determineCustomTuplizer();
        this.simpleAttributeMap = new TreeMap<String, BasicAttribute>();
        this.idAttributeMap = new TreeMap<String, BasicAttribute>();
        this.associationAttributeMap = new TreeMap<String, AssociationAttribute>();
        this.localBindingContext = new EntityBindingContext(annotationBindingContext, this);
        this.collectAttributes();
        this.attributeOverrideMap = Collections.unmodifiableMap(this.findAttributeOverrides());
    }

    public String getName() {
        return this.clazz.getName();
    }

    public Class<?> getConfiguredClass() {
        return this.clazz;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public ConfiguredClass getParent() {
        return this.parent;
    }

    public EntityBindingContext getLocalBindingContext() {
        return this.localBindingContext;
    }

    public Iterable<BasicAttribute> getSimpleAttributes() {
        return this.simpleAttributeMap.values();
    }

    public Iterable<BasicAttribute> getIdAttributes() {
        return this.idAttributeMap.values();
    }

    public BasicAttribute getVersionAttribute() {
        return this.versionAttribute;
    }

    public Iterable<AssociationAttribute> getAssociationAttributes() {
        return this.associationAttributeMap.values();
    }

    public Map<String, EmbeddableClass> getEmbeddedClasses() {
        return this.embeddedClasses;
    }

    public Map<String, AttributeOverride> getAttributeOverrideMap() {
        return this.attributeOverrideMap;
    }

    public AccessType getClassAccessType() {
        return this.classAccessType;
    }

    public String getCustomTuplizer() {
        return this.customTuplizer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ConfiguredClass");
        stringBuilder.append("{clazz=").append(this.clazz.getSimpleName());
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private ConfiguredClassType determineType() {
        if (this.classInfo.annotations().containsKey(JPADotNames.ENTITY)) {
            return ConfiguredClassType.ENTITY;
        }
        if (this.classInfo.annotations().containsKey(JPADotNames.MAPPED_SUPERCLASS)) {
            return ConfiguredClassType.MAPPED_SUPERCLASS;
        }
        if (this.classInfo.annotations().containsKey(JPADotNames.EMBEDDABLE)) {
            return ConfiguredClassType.EMBEDDABLE;
        }
        return ConfiguredClassType.NON_ENTITY;
    }

    private AccessType determineClassAccessType(AccessType accessType) {
        AccessType accessType2 = accessType;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.ACCESS);
        if (annotationInstance != null && annotationInstance.target().getClass().equals(ClassInfo.class)) {
            accessType2 = JandexHelper.getEnumValue(annotationInstance, "value", AccessType.class);
        }
        return accessType2;
    }

    private void collectAttributes() {
        AccessibleObject[] accessibleObjectArray2;
        this.findTransientFieldAndMethodNames();
        ResolvedTypeWithMembers resolvedTypeWithMembers = this.localBindingContext.resolveMemberTypes(this.localBindingContext.getResolvedType(this.clazz));
        for (AccessibleObject[] accessibleObjectArray2 : resolvedTypeWithMembers.allTypesAndOverrides()) {
            if (!accessibleObjectArray2.getType().getErasedType().equals(this.clazz)) continue;
            resolvedTypeWithMembers = this.localBindingContext.resolveMemberTypes(accessibleObjectArray2.getType());
            break;
        }
        if (resolvedTypeWithMembers == null) {
            throw new AssertionFailure("Unable to resolve types for " + this.clazz.getName());
        }
        Set<String> set = this.createExplicitlyConfiguredAccessProperties(resolvedTypeWithMembers);
        if (AccessType.FIELD.equals((Object)this.classAccessType)) {
            accessibleObjectArray2 = this.clazz.getDeclaredFields();
            Field.setAccessible(accessibleObjectArray2, true);
            for (AccessibleObject accessibleObject : accessibleObjectArray2) {
                if (!this.isPersistentMember(this.transientFieldNames, set, (Member)((Object)accessibleObject))) continue;
                this.createMappedAttribute((Member)((Object)accessibleObject), resolvedTypeWithMembers, AccessType.FIELD);
            }
        } else {
            accessibleObjectArray2 = this.clazz.getDeclaredMethods();
            Method.setAccessible(accessibleObjectArray2, true);
            for (AccessibleObject accessibleObject : accessibleObjectArray2) {
                if (!this.isPersistentMember(this.transientMethodNames, set, (Member)((Object)accessibleObject))) continue;
                this.createMappedAttribute((Member)((Object)accessibleObject), resolvedTypeWithMembers, AccessType.PROPERTY);
            }
        }
    }

    private boolean isPersistentMember(Set<String> set, Set<String> set2, Member member) {
        if (!ReflectionHelper.isProperty(member)) {
            return false;
        }
        if (set.contains(member.getName())) {
            return false;
        }
        return !set2.contains(ReflectionHelper.getPropertyName(member));
    }

    private Set<String> createExplicitlyConfiguredAccessProperties(ResolvedTypeWithMembers resolvedTypeWithMembers) {
        HashSet<String> hashSet = new HashSet<String>();
        List list = (List)this.classInfo.annotations().get(JPADotNames.ACCESS);
        if (list == null) {
            return hashSet;
        }
        for (AnnotationInstance annotationInstance : list) {
            AccessibleObject accessibleObject;
            AccessibleObject accessibleObject2;
            AccessType accessType;
            AnnotationTarget annotationTarget = annotationInstance.target();
            if (!annotationTarget.getClass().equals(MethodInfo.class) && !annotationTarget.getClass().equals(FieldInfo.class) || !this.isExplicitAttributeAccessAnnotationPlacedCorrectly(annotationTarget, accessType = JandexHelper.getEnumValue(annotationInstance, "value", AccessType.class))) continue;
            if (annotationTarget instanceof MethodInfo) {
                try {
                    accessibleObject2 = this.clazz.getMethod(((MethodInfo)annotationTarget).name(), new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new HibernateException("Unable to load method " + ((MethodInfo)annotationTarget).name() + " of class " + this.clazz.getName());
                }
                accessibleObject = accessibleObject2;
                accessType = AccessType.PROPERTY;
            } else {
                try {
                    accessibleObject2 = this.clazz.getField(((FieldInfo)annotationTarget).name());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new HibernateException("Unable to load field " + ((FieldInfo)annotationTarget).name() + " of class " + this.clazz.getName());
                }
                accessibleObject = accessibleObject2;
                accessType = AccessType.FIELD;
            }
            if (!ReflectionHelper.isProperty(accessibleObject)) continue;
            this.createMappedAttribute((Member)((Object)accessibleObject), resolvedTypeWithMembers, accessType);
            hashSet.add(ReflectionHelper.getPropertyName(accessibleObject));
        }
        return hashSet;
    }

    private boolean isExplicitAttributeAccessAnnotationPlacedCorrectly(AnnotationTarget annotationTarget, AccessType accessType) {
        if (AccessType.FIELD.equals((Object)this.classAccessType)) {
            if (!(annotationTarget instanceof MethodInfo)) {
                LOG.tracef("The access type of class %s is AccessType.FIELD. To override the access for an attribute @Access has to be placed on the property (getter)", (Object)this.classInfo.name().toString());
                return false;
            }
            if (!AccessType.PROPERTY.equals((Object)accessType)) {
                LOG.tracef("The access type of class %s is AccessType.FIELD. To override the access for an attribute @Access has to be placed on the property (getter) with an access type of AccessType.PROPERTY. Using AccessType.FIELD on the property has no effect", (Object)this.classInfo.name().toString());
                return false;
            }
        }
        if (AccessType.PROPERTY.equals((Object)this.classAccessType)) {
            if (!(annotationTarget instanceof FieldInfo)) {
                LOG.tracef("The access type of class %s is AccessType.PROPERTY. To override the access for a field @Access has to be placed on the field ", (Object)this.classInfo.name().toString());
                return false;
            }
            if (!AccessType.FIELD.equals((Object)accessType)) {
                LOG.tracef("The access type of class %s is AccessType.PROPERTY. To override the access for a field @Access has to be placed on the field with an access type of AccessType.FIELD. Using AccessType.PROPERTY on the field has no effect", (Object)this.classInfo.name().toString());
                return false;
            }
        }
        return true;
    }

    private void createMappedAttribute(Member member, ResolvedTypeWithMembers resolvedTypeWithMembers, AccessType accessType) {
        String string = ReflectionHelper.getPropertyName(member);
        Object[] objectArray = member instanceof Field ? resolvedTypeWithMembers.getMemberFields() : resolvedTypeWithMembers.getMemberMethods();
        Class clazz = (Class)this.findResolvedType(member.getName(), (ResolvedMember[])objectArray);
        Map<DotName, List<AnnotationInstance>> map = JandexHelper.getMemberAnnotations(this.classInfo, member.getName());
        AttributeNature attributeNature = this.determineAttributeNature(map);
        String string2 = accessType.toString().toLowerCase();
        switch (attributeNature) {
            case BASIC: {
                BasicAttribute basicAttribute = BasicAttribute.createSimpleAttribute(string, clazz, map, string2, this.getLocalBindingContext());
                if (basicAttribute.isId()) {
                    this.idAttributeMap.put(string, basicAttribute);
                    break;
                }
                if (basicAttribute.isVersioned()) {
                    if (this.versionAttribute == null) {
                        this.versionAttribute = basicAttribute;
                        break;
                    }
                    throw new MappingException("Multiple version attributes", this.localBindingContext.getOrigin());
                }
                this.simpleAttributeMap.put(string, basicAttribute);
                break;
            }
            case ELEMENT_COLLECTION: {
                throw new NotYetImplementedException("Element collections must still be implemented.");
            }
            case EMBEDDED_ID: {
                throw new NotYetImplementedException("Embedded ids must still be implemented.");
            }
            case EMBEDDED: {
                AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.TARGET);
                if (annotationInstance != null) {
                    clazz = this.localBindingContext.locateClassByName(JandexHelper.getValue(annotationInstance, "value", String.class));
                }
                this.resolveEmbeddable(string, clazz);
                break;
            }
            default: {
                AssociationAttribute associationAttribute = AssociationAttribute.createAssociationAttribute(string, clazz, attributeNature, string2, map, this.getLocalBindingContext());
                this.associationAttributeMap.put(string, associationAttribute);
            }
        }
    }

    private void resolveEmbeddable(String string, Class<?> clazz) {
        ClassInfo classInfo = this.localBindingContext.getClassInfo(clazz.getName());
        if (classInfo == null) {
            String string2 = String.format("Attribute '%s#%s' is annotated with @Embedded, but '%s' does not seem to be annotated with @Embeddable. Are all annotated classes added to the configuration?", this.getConfiguredClass().getSimpleName(), string, clazz.getSimpleName());
            throw new AnnotationException(string2);
        }
        this.localBindingContext.resolveAllTypes(clazz.getName());
        EmbeddableHierarchy embeddableHierarchy = EmbeddableHierarchy.createEmbeddableHierarchy(this.localBindingContext.locateClassByName(classInfo.toString()), string, this.classAccessType, this.localBindingContext);
        this.embeddedClasses.put(string, embeddableHierarchy.getLeaf());
    }

    private AttributeNature determineAttributeNature(Map<DotName, List<AnnotationInstance>> map) {
        AnnotationInstance annotationInstance;
        AnnotationInstance annotationInstance2;
        AnnotationInstance annotationInstance3;
        AnnotationInstance annotationInstance4;
        AnnotationInstance annotationInstance5;
        AnnotationInstance annotationInstance6;
        EnumMap<AttributeNature, AnnotationInstance> enumMap = new EnumMap<AttributeNature, AnnotationInstance>(AttributeNature.class);
        AnnotationInstance annotationInstance7 = JandexHelper.getSingleAnnotation(map, JPADotNames.ONE_TO_ONE);
        if (annotationInstance7 != null) {
            enumMap.put(AttributeNature.ONE_TO_ONE, annotationInstance7);
        }
        if ((annotationInstance6 = JandexHelper.getSingleAnnotation(map, JPADotNames.ONE_TO_MANY)) != null) {
            enumMap.put(AttributeNature.ONE_TO_MANY, annotationInstance6);
        }
        if ((annotationInstance5 = JandexHelper.getSingleAnnotation(map, JPADotNames.MANY_TO_ONE)) != null) {
            enumMap.put(AttributeNature.MANY_TO_ONE, annotationInstance5);
        }
        if ((annotationInstance4 = JandexHelper.getSingleAnnotation(map, JPADotNames.MANY_TO_MANY)) != null) {
            enumMap.put(AttributeNature.MANY_TO_MANY, annotationInstance4);
        }
        if ((annotationInstance3 = JandexHelper.getSingleAnnotation(map, JPADotNames.EMBEDDED)) != null) {
            enumMap.put(AttributeNature.EMBEDDED, annotationInstance3);
        }
        if ((annotationInstance2 = JandexHelper.getSingleAnnotation(map, JPADotNames.EMBEDDED_ID)) != null) {
            enumMap.put(AttributeNature.EMBEDDED_ID, annotationInstance2);
        }
        if ((annotationInstance = JandexHelper.getSingleAnnotation(map, JPADotNames.ELEMENT_COLLECTION)) != null) {
            enumMap.put(AttributeNature.ELEMENT_COLLECTION, annotationInstance);
        }
        if (enumMap.size() == 0) {
            return AttributeNature.BASIC;
        }
        if (enumMap.size() == 1) {
            return enumMap.keySet().iterator().next();
        }
        throw new AnnotationException("More than one association type configured for property  " + this.getName() + " of class " + this.getName());
    }

    private Type findResolvedType(String string, ResolvedMember[] resolvedMemberArray) {
        for (ResolvedMember resolvedMember : resolvedMemberArray) {
            if (!resolvedMember.getName().equals(string)) continue;
            return resolvedMember.getType().getErasedType();
        }
        throw new AssertionFailure(String.format("Unable to resolve type of attribute %s of class %s", string, this.classInfo.name().toString()));
    }

    private void findTransientFieldAndMethodNames() {
        List list = (List)this.classInfo.annotations().get(JPADotNames.TRANSIENT);
        if (list == null) {
            return;
        }
        for (AnnotationInstance annotationInstance : list) {
            AnnotationTarget annotationTarget = annotationInstance.target();
            if (annotationTarget instanceof FieldInfo) {
                this.transientFieldNames.add(((FieldInfo)annotationTarget).name());
                continue;
            }
            this.transientMethodNames.add(((MethodInfo)annotationTarget).name());
        }
    }

    private Map<String, AttributeOverride> findAttributeOverrides() {
        AnnotationInstance[] annotationInstanceArray;
        String string;
        HashMap<String, AttributeOverride> hashMap = new HashMap<String, AttributeOverride>();
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.ATTRIBUTE_OVERRIDE);
        if (annotationInstance != null) {
            string = this.createPathPrefix(annotationInstance.target());
            annotationInstanceArray = new AttributeOverride(string, annotationInstance);
            hashMap.put(annotationInstanceArray.getAttributePath(), (AttributeOverride)annotationInstanceArray);
        }
        if ((string = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.ATTRIBUTE_OVERRIDES)) != null) {
            for (AnnotationInstance annotationInstance2 : annotationInstanceArray = string.value().asNestedArray()) {
                String string2 = this.createPathPrefix(string.target());
                AttributeOverride attributeOverride = new AttributeOverride(string2, annotationInstance2);
                hashMap.put(attributeOverride.getAttributePath(), attributeOverride);
            }
        }
        return hashMap;
    }

    private String createPathPrefix(AnnotationTarget annotationTarget) {
        String string = null;
        if (annotationTarget instanceof FieldInfo || annotationTarget instanceof MethodInfo) {
            string = JandexHelper.getPropertyName(annotationTarget);
        }
        return string;
    }

    private List<AnnotationInstance> findAssociationOverrides() {
        ArrayList<AnnotationInstance> arrayList = new ArrayList<AnnotationInstance>();
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.ASSOCIATION_OVERRIDE);
        if (annotationInstance != null) {
            arrayList.add(annotationInstance);
        }
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.ASSOCIATION_OVERRIDES);
        if (annotationInstance != null) {
            AnnotationInstance[] annotationInstanceArray = annotationInstance2.value().asNestedArray();
            Collections.addAll(arrayList, annotationInstanceArray);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private String determineCustomTuplizer() {
        void var4_7;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.classInfo, HibernateDotNames.TUPLIZERS);
        if (annotationInstance == null) {
            return null;
        }
        AnnotationInstance[] annotationInstanceArray = JandexHelper.getValue(annotationInstance, "value", AnnotationInstance[].class);
        AnnotationInstance annotationInstance2 = null;
        for (AnnotationInstance annotationInstance3 : annotationInstanceArray) {
            if (EntityMode.valueOf(annotationInstance3.value("entityModeType").asEnum()) != EntityMode.POJO) continue;
            annotationInstance2 = annotationInstance3;
            break;
        }
        Object var4_5 = null;
        if (annotationInstance2 != null) {
            String string = annotationInstance2.value("impl").asString();
        }
        return var4_7;
    }
}

