/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.annotations.attribute.AssociationAttribute;
import org.hibernate.metamodel.source.annotations.attribute.AttributeOverride;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.hibernate.metamodel.source.annotations.attribute.SingularAttributeSourceImpl;
import org.hibernate.metamodel.source.annotations.attribute.ToOneAttributeSourceImpl;
import org.hibernate.metamodel.source.annotations.entity.EmbeddableClass;
import org.hibernate.metamodel.source.binder.AttributeSource;
import org.hibernate.metamodel.source.binder.ComponentAttributeSource;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAttributeSourceImpl
implements ComponentAttributeSource {
    private static final String PATH_SEPERATOR = ".";
    private final EmbeddableClass embeddableClass;
    private final ValueHolder<Class<?>> classReference;
    private final Map<String, AttributeOverride> attributeOverrides;
    private final String path;

    public ComponentAttributeSourceImpl(EmbeddableClass embeddableClass, String string, Map<String, AttributeOverride> map) {
        this.embeddableClass = embeddableClass;
        this.classReference = new ValueHolder(embeddableClass.getConfiguredClass());
        this.attributeOverrides = map;
        this.path = StringHelper.isEmpty(string) ? embeddableClass.getEmbeddedAttributeName() : string + PATH_SEPERATOR + embeddableClass.getEmbeddedAttributeName();
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.COMPONENT;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public String getClassName() {
        return this.embeddableClass.getConfiguredClass().getName();
    }

    @Override
    public ValueHolder<Class<?>> getClassReference() {
        return this.classReference;
    }

    @Override
    public String getName() {
        return this.embeddableClass.getEmbeddedAttributeName();
    }

    @Override
    public String getExplicitTuplizerClassName() {
        return this.embeddableClass.getCustomTuplizer();
    }

    @Override
    public String getPropertyAccessorName() {
        return this.embeddableClass.getClassAccessType().toString().toLowerCase();
    }

    @Override
    public LocalBindingContext getLocalBindingContext() {
        return this.embeddableClass.getLocalBindingContext();
    }

    @Override
    public Iterable<AttributeSource> attributeSources() {
        ArrayList<AttributeSource> arrayList = new ArrayList<AttributeSource>();
        for (BasicAttribute object : this.embeddableClass.getSimpleAttributes()) {
            AttributeOverride attributeOverride = null;
            String string = this.getPath() + PATH_SEPERATOR + object.getName();
            if (this.attributeOverrides.containsKey(string)) {
                attributeOverride = this.attributeOverrides.get(string);
            }
            arrayList.add(new SingularAttributeSourceImpl(object, attributeOverride));
        }
        for (EmbeddableClass embeddableClass : this.embeddableClass.getEmbeddedClasses().values()) {
            arrayList.add(new ComponentAttributeSourceImpl(embeddableClass, this.getPath(), this.createAggregatedOverrideMap()));
        }
        for (AssociationAttribute associationAttribute : this.embeddableClass.getAssociationAttributes()) {
            arrayList.add(new ToOneAttributeSourceImpl(associationAttribute));
        }
        return arrayList;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getParentReferenceAttributeName() {
        return this.embeddableClass.getParentReferencingAttributeName();
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Collections.emptySet();
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return null;
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return null;
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public PropertyGeneration getGeneration() {
        return null;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return true;
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return true;
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return true;
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ComponentAttributeSourceImpl");
        stringBuilder.append("{embeddableClass=").append(this.embeddableClass.getConfiguredClass().getSimpleName());
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private Map<String, AttributeOverride> createAggregatedOverrideMap() {
        HashMap<String, AttributeOverride> hashMap = new HashMap<String, AttributeOverride>(this.attributeOverrides);
        for (Map.Entry<String, AttributeOverride> entry : this.embeddableClass.getAttributeOverrideMap().entrySet()) {
            String string = this.getPath() + PATH_SEPERATOR + entry.getKey();
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, entry.getValue());
        }
        return hashMap;
    }
}

