/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute.type;

import java.util.Calendar;
import java.util.Date;
import javax.persistence.TemporalType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.MappedAttribute;
import org.hibernate.metamodel.source.annotations.attribute.type.AbstractAttributeTypeResolver;
import org.hibernate.type.StandardBasicTypes;
import org.jboss.jandex.AnnotationInstance;

public class TemporalTypeResolver
extends AbstractAttributeTypeResolver {
    private final MappedAttribute mappedAttribute;
    private final boolean isMapKey;

    public TemporalTypeResolver(MappedAttribute mappedAttribute) {
        if (mappedAttribute == null) {
            throw new AssertionFailure("MappedAttribute is null");
        }
        this.mappedAttribute = mappedAttribute;
        this.isMapKey = false;
    }

    public String resolveHibernateTypeName(AnnotationInstance annotationInstance) {
        if (TemporalTypeResolver.isTemporalType(this.mappedAttribute.getAttributeType())) {
            String string;
            if (annotationInstance == null) {
                throw new AnnotationException("Attribute " + this.mappedAttribute.getName() + " is a Temporal type, but no @Temporal annotation found.");
            }
            TemporalType temporalType = JandexHelper.getEnumValue(annotationInstance, "value", TemporalType.class);
            boolean bl = Date.class.isAssignableFrom(this.mappedAttribute.getAttributeType());
            switch (temporalType) {
                case DATE: {
                    string = bl ? StandardBasicTypes.DATE.getName() : StandardBasicTypes.CALENDAR_DATE.getName();
                    break;
                }
                case TIME: {
                    string = StandardBasicTypes.TIME.getName();
                    if (bl) break;
                    throw new NotYetImplementedException("Calendar cannot persist TIME only");
                }
                case TIMESTAMP: {
                    string = bl ? StandardBasicTypes.TIMESTAMP.getName() : StandardBasicTypes.CALENDAR.getName();
                    break;
                }
                default: {
                    throw new AssertionFailure("Unknown temporal type: " + (Object)((Object)temporalType));
                }
            }
            return string;
        }
        if (annotationInstance != null) {
            throw new AnnotationException("@Temporal should only be set on a java.util.Date or java.util.Calendar property: " + this.mappedAttribute.getName());
        }
        return null;
    }

    protected AnnotationInstance getTypeDeterminingAnnotationInstance() {
        return JandexHelper.getSingleAnnotation(this.mappedAttribute.annotations(), JPADotNames.TEMPORAL);
    }

    private static boolean isTemporalType(Class clazz) {
        return Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz);
    }
}

