/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute.type;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.MappedAttribute;
import org.hibernate.metamodel.source.annotations.attribute.type.AbstractAttributeTypeResolver;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.WrappedMaterializedBlobType;
import org.jboss.jandex.AnnotationInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LobTypeResolver
extends AbstractAttributeTypeResolver {
    private final MappedAttribute mappedAttribute;

    public LobTypeResolver(MappedAttribute mappedAttribute) {
        if (mappedAttribute == null) {
            throw new AssertionFailure("MappedAttribute is null");
        }
        this.mappedAttribute = mappedAttribute;
    }

    @Override
    protected AnnotationInstance getTypeDeterminingAnnotationInstance() {
        return JandexHelper.getSingleAnnotation(this.mappedAttribute.annotations(), JPADotNames.LOB);
    }

    @Override
    public String resolveHibernateTypeName(AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        String string = null;
        string = Clob.class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? StandardBasicTypes.CLOB.getName() : (Blob.class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? StandardBasicTypes.BLOB.getName() : (String.class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? StandardBasicTypes.MATERIALIZED_CLOB.getName() : (Character[].class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? CharacterArrayClobType.class.getName() : (char[].class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? PrimitiveCharacterArrayClobType.class.getName() : (Byte[].class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? WrappedMaterializedBlobType.class.getName() : (byte[].class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? StandardBasicTypes.MATERIALIZED_BLOB.getName() : (Serializable.class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? SerializableToBlobType.class.getName() : "blob")))))));
        return string;
    }

    @Override
    protected Map<String, String> resolveHibernateTypeParameters(AnnotationInstance annotationInstance) {
        if (this.getExplicitHibernateTypeName().equals(SerializableToBlobType.class.getName())) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("classname", this.mappedAttribute.getAttributeType().getName());
            return hashMap;
        }
        return null;
    }
}

