/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolver;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeAttributeTypeResolver
implements AttributeTypeResolver {
    private List<AttributeTypeResolver> resolvers = new ArrayList<AttributeTypeResolver>();
    private final AttributeTypeResolverImpl explicitHibernateTypeResolver;

    public CompositeAttributeTypeResolver(AttributeTypeResolverImpl attributeTypeResolverImpl) {
        if (attributeTypeResolverImpl == null) {
            throw new AssertionFailure("The Given AttributeTypeResolver is null.");
        }
        this.explicitHibernateTypeResolver = attributeTypeResolverImpl;
    }

    public void addHibernateTypeResolver(AttributeTypeResolver attributeTypeResolver) {
        if (attributeTypeResolver == null) {
            throw new AssertionFailure("The Given AttributeTypeResolver is null.");
        }
        this.resolvers.add(attributeTypeResolver);
    }

    @Override
    public String getExplicitHibernateTypeName() {
        String string;
        block1: {
            AttributeTypeResolver attributeTypeResolver;
            string = this.explicitHibernateTypeResolver.getExplicitHibernateTypeName();
            if (!StringHelper.isEmpty(string)) break block1;
            Iterator<AttributeTypeResolver> iterator = this.resolvers.iterator();
            while (iterator.hasNext() && !StringHelper.isNotEmpty(string = (attributeTypeResolver = iterator.next()).getExplicitHibernateTypeName())) {
            }
        }
        return string;
    }

    @Override
    public Map<String, String> getExplicitHibernateTypeParameters() {
        Map<String, String> map;
        block1: {
            AttributeTypeResolver attributeTypeResolver;
            map = this.explicitHibernateTypeResolver.getExplicitHibernateTypeParameters();
            if (!CollectionHelper.isEmpty(map)) break block1;
            Iterator<AttributeTypeResolver> iterator = this.resolvers.iterator();
            while (iterator.hasNext() && !CollectionHelper.isNotEmpty(map = (attributeTypeResolver = iterator.next()).getExplicitHibernateTypeParameters())) {
            }
        }
        return map;
    }
}

