/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.source.annotations.attribute.AttributeOverride;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.hibernate.metamodel.source.annotations.attribute.SingularAttributeSourceImpl;
import org.hibernate.metamodel.source.binder.IdentifierSource;
import org.hibernate.metamodel.source.binder.SimpleIdentifierSource;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIdentifierSourceImpl
implements SimpleIdentifierSource {
    private final BasicAttribute attribute;
    private final Map<String, AttributeOverride> attributeOverrideMap;

    public SimpleIdentifierSourceImpl(BasicAttribute basicAttribute, Map<String, AttributeOverride> map) {
        if (!basicAttribute.isId()) {
            throw new AssertionFailure(String.format("A non id attribute was passed to SimpleIdentifierSourceImpl: %s", basicAttribute.toString()));
        }
        this.attribute = basicAttribute;
        this.attributeOverrideMap = map;
    }

    @Override
    public IdentifierSource.Nature getNature() {
        return IdentifierSource.Nature.SIMPLE;
    }

    @Override
    public SingularAttributeSource getIdentifierAttributeSource() {
        return new SingularAttributeSourceImpl(this.attribute);
    }

    @Override
    public IdGenerator getIdentifierGeneratorDescriptor() {
        return this.attribute.getIdGenerator();
    }
}

