/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.List;
import java.util.Map;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.ColumnValues;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolver;
import org.hibernate.metamodel.source.annotations.entity.EntityBindingContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappedAttribute
implements Comparable<MappedAttribute> {
    private final Map<DotName, List<AnnotationInstance>> annotations;
    private final String name;
    private final Class<?> attributeType;
    private final String accessType;
    private ColumnValues columnValues;
    private final boolean isId;
    private final boolean isOptimisticLockable;
    private final EntityBindingContext context;

    MappedAttribute(String string, Class<?> clazz, String string2, Map<DotName, List<AnnotationInstance>> map, EntityBindingContext entityBindingContext) {
        this.context = entityBindingContext;
        this.annotations = map;
        this.name = string;
        this.attributeType = clazz;
        this.accessType = string2;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(map, JPADotNames.ID);
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(map, JPADotNames.EMBEDDED_ID);
        this.isId = annotationInstance != null || annotationInstance2 != null;
        AnnotationInstance annotationInstance3 = JandexHelper.getSingleAnnotation(map, JPADotNames.COLUMN);
        this.columnValues = new ColumnValues(annotationInstance3);
        this.isOptimisticLockable = this.checkOptimisticLockAnnotation();
    }

    public String getName() {
        return this.name;
    }

    public final Class<?> getAttributeType() {
        return this.attributeType;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public EntityBindingContext getContext() {
        return this.context;
    }

    public Map<DotName, List<AnnotationInstance>> annotations() {
        return this.annotations;
    }

    public ColumnValues getColumnValues() {
        return this.columnValues;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isOptimisticLockable() {
        return this.isOptimisticLockable;
    }

    @Override
    public int compareTo(MappedAttribute mappedAttribute) {
        return this.name.compareTo(mappedAttribute.getName());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MappedAttribute");
        stringBuilder.append("{name='").append(this.name).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public abstract AttributeTypeResolver getHibernateTypeResolver();

    public abstract boolean isLazy();

    public abstract boolean isOptional();

    public abstract boolean isInsertable();

    public abstract boolean isUpdatable();

    public abstract PropertyGeneration getPropertyGeneration();

    private boolean checkOptimisticLockAnnotation() {
        boolean bl = true;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.OPTIMISTIC_LOCK);
        if (annotationInstance != null) {
            boolean bl2 = annotationInstance.value("excluded").asBoolean();
            bl = !bl2;
        }
        return bl;
    }
}

