/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ColumnValues {
    private String name = "";
    private boolean unique = false;
    private boolean nullable = true;
    private boolean insertable = true;
    private boolean updatable = true;
    private String columnDefinition = "";
    private String table = null;
    private int length = 255;
    private int precision = 0;
    private int scale = 0;

    ColumnValues() {
        this(null);
    }

    public ColumnValues(AnnotationInstance annotationInstance) {
        if (annotationInstance != null && !JPADotNames.COLUMN.equals((Object)annotationInstance.name())) {
            throw new AssertionFailure("A @Column annotation needs to be passed to the constructor");
        }
        this.applyColumnValues(annotationInstance);
    }

    private void applyColumnValues(AnnotationInstance annotationInstance) {
        AnnotationValue annotationValue;
        AnnotationValue annotationValue2;
        AnnotationValue annotationValue3;
        AnnotationValue annotationValue4;
        AnnotationValue annotationValue5;
        AnnotationValue annotationValue6;
        AnnotationValue annotationValue7;
        AnnotationValue annotationValue8;
        AnnotationValue annotationValue9;
        if (annotationInstance == null) {
            return;
        }
        AnnotationValue annotationValue10 = annotationInstance.value("name");
        if (annotationValue10 != null) {
            this.name = annotationValue10.asString();
        }
        if ((annotationValue9 = annotationInstance.value("unique")) != null) {
            this.unique = annotationValue10.asBoolean();
        }
        if ((annotationValue8 = annotationInstance.value("nullable")) != null) {
            this.nullable = annotationValue8.asBoolean();
        }
        if ((annotationValue7 = annotationInstance.value("insertable")) != null) {
            this.insertable = annotationValue7.asBoolean();
        }
        if ((annotationValue6 = annotationInstance.value("updatable")) != null) {
            this.updatable = annotationValue6.asBoolean();
        }
        if ((annotationValue5 = annotationInstance.value("columnDefinition")) != null) {
            this.columnDefinition = annotationValue5.asString();
        }
        if ((annotationValue4 = annotationInstance.value("table")) != null) {
            this.table = annotationValue4.asString();
        }
        if ((annotationValue3 = annotationInstance.value("length")) != null) {
            this.length = annotationValue3.asInt();
        }
        if ((annotationValue2 = annotationInstance.value("precision")) != null) {
            this.precision = annotationValue2.asInt();
        }
        if ((annotationValue = annotationInstance.value("scale")) != null) {
            this.scale = annotationValue.asInt();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public final boolean isNullable() {
        return this.nullable;
    }

    public final boolean isInsertable() {
        return this.insertable;
    }

    public final boolean isUpdatable() {
        return this.updatable;
    }

    public final String getColumnDefinition() {
        return this.columnDefinition;
    }

    public final String getTable() {
        return this.table;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public void setInsertable(boolean bl) {
        this.insertable = bl;
    }

    public void setUpdatable(boolean bl) {
        this.updatable = bl;
    }

    public void setColumnDefinition(String string) {
        this.columnDefinition = string;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColumnValues");
        stringBuilder.append("{name='").append(this.name).append('\'');
        stringBuilder.append(", unique=").append(this.unique);
        stringBuilder.append(", nullable=").append(this.nullable);
        stringBuilder.append(", insertable=").append(this.insertable);
        stringBuilder.append(", updatable=").append(this.updatable);
        stringBuilder.append(", columnDefinition='").append(this.columnDefinition).append('\'');
        stringBuilder.append(", table='").append(this.table).append('\'');
        stringBuilder.append(", length=").append(this.length);
        stringBuilder.append(", precision=").append(this.precision);
        stringBuilder.append(", scale=").append(this.scale);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ColumnValues columnValues = (ColumnValues)object;
        if (this.insertable != columnValues.insertable) {
            return false;
        }
        if (this.length != columnValues.length) {
            return false;
        }
        if (this.nullable != columnValues.nullable) {
            return false;
        }
        if (this.precision != columnValues.precision) {
            return false;
        }
        if (this.scale != columnValues.scale) {
            return false;
        }
        if (this.unique != columnValues.unique) {
            return false;
        }
        if (this.updatable != columnValues.updatable) {
            return false;
        }
        if (this.columnDefinition != null ? !this.columnDefinition.equals(columnValues.columnDefinition) : columnValues.columnDefinition != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(columnValues.name) : columnValues.name != null) {
            return false;
        }
        return !(this.table != null ? !this.table.equals(columnValues.table) : columnValues.table != null);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 31 * n + (this.unique ? 1 : 0);
        n = 31 * n + (this.nullable ? 1 : 0);
        n = 31 * n + (this.insertable ? 1 : 0);
        n = 31 * n + (this.updatable ? 1 : 0);
        n = 31 * n + (this.columnDefinition != null ? this.columnDefinition.hashCode() : 0);
        n = 31 * n + (this.table != null ? this.table.hashCode() : 0);
        n = 31 * n + this.length;
        n = 31 * n + this.precision;
        n = 31 * n + this.scale;
        return n;
    }
}

