/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.FetchType;
import javax.persistence.GenerationType;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.annotations.EnumConversionHelper;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.MappedAttribute;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolver;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolverImpl;
import org.hibernate.metamodel.source.annotations.attribute.type.CompositeAttributeTypeResolver;
import org.hibernate.metamodel.source.annotations.attribute.type.EnumeratedTypeResolver;
import org.hibernate.metamodel.source.annotations.attribute.type.LobTypeResolver;
import org.hibernate.metamodel.source.annotations.attribute.type.TemporalTypeResolver;
import org.hibernate.metamodel.source.annotations.entity.EntityBindingContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttribute
extends MappedAttribute {
    private final IdGenerator idGenerator;
    private final boolean isVersioned;
    private boolean isLazy = false;
    private boolean isOptional = true;
    private PropertyGeneration propertyGeneration;
    private boolean isInsertable = true;
    private boolean isUpdatable = true;
    private final String customWriteFragment;
    private final String customReadFragment;
    private final String checkCondition;
    private AttributeTypeResolver resolver;

    public static BasicAttribute createSimpleAttribute(String string, Class<?> clazz, Map<DotName, List<AnnotationInstance>> map, String string2, EntityBindingContext entityBindingContext) {
        return new BasicAttribute(string, clazz, string2, map, entityBindingContext);
    }

    BasicAttribute(String string, Class<?> clazz, String string2, Map<DotName, List<AnnotationInstance>> map, EntityBindingContext entityBindingContext) {
        super(string, clazz, string2, map, entityBindingContext);
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(map, JPADotNames.VERSION);
        boolean bl = this.isVersioned = annotationInstance != null;
        if (this.isId()) {
            this.getColumnValues().setUnique(true);
            this.getColumnValues().setNullable(false);
            this.idGenerator = this.checkGeneratedValueAnnotation();
        } else {
            this.idGenerator = null;
        }
        this.checkBasicAnnotation();
        this.checkGeneratedAnnotation();
        List<AnnotationInstance> list = this.getAllColumnTransformerAnnotations();
        String[] stringArray = this.createCustomReadWrite(list);
        this.customReadFragment = stringArray[0];
        this.customWriteFragment = stringArray[1];
        this.checkCondition = this.parseCheckAnnotation();
    }

    public boolean isVersioned() {
        return this.isVersioned;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    @Override
    public PropertyGeneration getPropertyGeneration() {
        return this.propertyGeneration;
    }

    public String getCustomWriteFragment() {
        return this.customWriteFragment;
    }

    public String getCustomReadFragment() {
        return this.customReadFragment;
    }

    public String getCheckCondition() {
        return this.checkCondition;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SimpleAttribute");
        stringBuilder.append("{name=").append(this.getName());
        return stringBuilder.toString();
    }

    private void checkBasicAnnotation() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), JPADotNames.BASIC);
        if (annotationInstance != null) {
            FetchType fetchType = FetchType.LAZY;
            AnnotationValue annotationValue = annotationInstance.value("fetch");
            if (annotationValue != null) {
                fetchType = Enum.valueOf(FetchType.class, annotationValue.asEnum());
            }
            this.isLazy = fetchType == FetchType.LAZY;
            AnnotationValue annotationValue2 = annotationInstance.value("optional");
            if (annotationValue2 != null) {
                this.isOptional = annotationValue2.asBoolean();
            }
        }
    }

    private void checkGeneratedAnnotation() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.GENERATED);
        if (annotationInstance != null) {
            GenerationTime generationTime;
            this.isInsertable = false;
            AnnotationValue annotationValue = annotationInstance.value();
            if (annotationValue != null && GenerationTime.ALWAYS.equals((Object)(generationTime = Enum.valueOf(GenerationTime.class, annotationValue.asEnum())))) {
                this.isUpdatable = false;
                this.propertyGeneration = PropertyGeneration.parse(generationTime.toString().toLowerCase());
            }
        }
    }

    private List<AnnotationInstance> getAllColumnTransformerAnnotations() {
        AnnotationInstance[] annotationInstanceArray;
        ArrayList<AnnotationInstance> arrayList = new ArrayList<AnnotationInstance>();
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.COLUMN_TRANSFORMERS);
        if (annotationInstance != null) {
            annotationInstanceArray = ((AnnotationInstance)arrayList.get(0)).value().asNestedArray();
            arrayList.addAll(Arrays.asList(annotationInstanceArray));
        }
        if ((annotationInstanceArray = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.COLUMN_TRANSFORMER)) != null) {
            arrayList.add((AnnotationInstance)annotationInstanceArray);
        }
        return arrayList;
    }

    private String[] createCustomReadWrite(List<AnnotationInstance> list) {
        String[] stringArray = new String[2];
        boolean bl = false;
        for (AnnotationInstance annotationInstance : list) {
            String string;
            String string2 = string = annotationInstance.value("forColumn") == null ? null : annotationInstance.value("forColumn").asString();
            if (string != null && !string.equals(this.getName())) continue;
            if (bl) {
                throw new AnnotationException("Multiple definition of read/write conditions for column " + this.getName());
            }
            stringArray[0] = annotationInstance.value("read") == null ? null : annotationInstance.value("read").asString();
            stringArray[1] = annotationInstance.value("write") == null ? null : annotationInstance.value("write").asString();
            bl = true;
        }
        return stringArray;
    }

    private String parseCheckAnnotation() {
        String string = null;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.CHECK);
        if (annotationInstance != null) {
            string = annotationInstance.value("constraints").toString();
        }
        return string;
    }

    private IdGenerator checkGeneratedValueAnnotation() {
        IdGenerator idGenerator = null;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), JPADotNames.GENERATED_VALUE);
        if (annotationInstance != null) {
            String string = JandexHelper.getValue(annotationInstance, "generator", String.class);
            if (StringHelper.isNotEmpty(string)) {
                idGenerator = this.getContext().getMetadataImplementor().getIdGenerator(string);
                if (idGenerator == null) {
                    throw new MappingException(String.format("Unable to find named generator %s", string), null);
                }
            } else {
                GenerationType generationType = JandexHelper.getEnumValue(annotationInstance, "strategy", GenerationType.class);
                String string2 = EnumConversionHelper.generationTypeToGeneratorStrategyName(generationType, this.getContext().getMetadataImplementor().getOptions().useNewIdentifierGenerators());
                idGenerator = new IdGenerator(null, string2, null);
            }
        }
        return idGenerator;
    }

    @Override
    public AttributeTypeResolver getHibernateTypeResolver() {
        if (this.resolver == null) {
            this.resolver = this.getDefaultHibernateTypeResolver();
        }
        return this.resolver;
    }

    private AttributeTypeResolver getDefaultHibernateTypeResolver() {
        CompositeAttributeTypeResolver compositeAttributeTypeResolver = new CompositeAttributeTypeResolver(new AttributeTypeResolverImpl(this));
        compositeAttributeTypeResolver.addHibernateTypeResolver(new TemporalTypeResolver(this));
        compositeAttributeTypeResolver.addHibernateTypeResolver(new LobTypeResolver(this));
        compositeAttributeTypeResolver.addHibernateTypeResolver(new EnumeratedTypeResolver(this));
        return compositeAttributeTypeResolver;
    }
}

