/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import org.hibernate.AssertionFailure;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.ColumnValues;
import org.jboss.jandex.AnnotationInstance;

public class AttributeOverride {
    private static final String PROPERTY_PATH_SEPARATOR = ".";
    private final ColumnValues columnValues;
    private final String attributePath;

    public AttributeOverride(AnnotationInstance annotationInstance) {
        this(null, annotationInstance);
    }

    public AttributeOverride(String string, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            throw new IllegalArgumentException("An AnnotationInstance needs to be passed");
        }
        if (!JPADotNames.ATTRIBUTE_OVERRIDE.equals((Object)annotationInstance.name())) {
            throw new AssertionFailure("A @AttributeOverride annotation needs to be passed to the constructor");
        }
        this.columnValues = new ColumnValues(JandexHelper.getValue(annotationInstance, "column", AnnotationInstance.class));
        this.attributePath = this.createAttributePath(string, JandexHelper.getValue(annotationInstance, "name", String.class));
    }

    public ColumnValues getColumnValues() {
        return this.columnValues;
    }

    public String getAttributePath() {
        return this.attributePath;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AttributeOverride");
        stringBuilder.append("{columnValues=").append(this.columnValues);
        stringBuilder.append(", attributePath='").append(this.attributePath).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AttributeOverride attributeOverride = (AttributeOverride)object;
        if (this.attributePath != null ? !this.attributePath.equals(attributeOverride.attributePath) : attributeOverride.attributePath != null) {
            return false;
        }
        return !(this.columnValues != null ? !this.columnValues.equals(attributeOverride.columnValues) : attributeOverride.columnValues != null);
    }

    public int hashCode() {
        int n = this.columnValues != null ? this.columnValues.hashCode() : 0;
        n = 31 * n + (this.attributePath != null ? this.attributePath.hashCode() : 0);
        return n;
    }

    private String createAttributePath(String string, String string2) {
        String string3 = "";
        if (StringHelper.isNotEmpty(string)) {
            string3 = string3 + string;
        }
        if (StringHelper.isNotEmpty(string3) && !string3.endsWith(PROPERTY_PATH_SEPARATOR)) {
            string3 = string3 + PROPERTY_PATH_SEPARATOR;
        }
        string3 = string3 + string2;
        return string3;
    }
}

