/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.hibernate.FetchMode;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.annotations.EnumConversionHelper;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.AttributeNature;
import org.hibernate.metamodel.source.annotations.attribute.MappedAttribute;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolver;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolverImpl;
import org.hibernate.metamodel.source.annotations.attribute.type.CompositeAttributeTypeResolver;
import org.hibernate.metamodel.source.annotations.entity.EntityBindingContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationAttribute
extends MappedAttribute {
    private final AttributeNature associationNature;
    private final boolean ignoreNotFound;
    private final String referencedEntityType;
    private final String mappedBy;
    private final Set<CascadeType> cascadeTypes;
    private final boolean isOptional;
    private final boolean isLazy;
    private final boolean isOrphanRemoval;
    private final FetchMode fetchMode;
    private final boolean mapsId;
    private final String referencedIdAttributeName;
    private boolean isInsertable = true;
    private boolean isUpdatable = true;
    private AttributeTypeResolver resolver;

    public static AssociationAttribute createAssociationAttribute(String string, Class<?> clazz, AttributeNature attributeNature, String string2, Map<DotName, List<AnnotationInstance>> map, EntityBindingContext entityBindingContext) {
        return new AssociationAttribute(string, clazz, attributeNature, string2, map, entityBindingContext);
    }

    private AssociationAttribute(String string, Class<?> clazz, AttributeNature attributeNature, String string2, Map<DotName, List<AnnotationInstance>> map, EntityBindingContext entityBindingContext) {
        super(string, clazz, string2, map, entityBindingContext);
        this.associationNature = attributeNature;
        this.ignoreNotFound = this.ignoreNotFound();
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(map, attributeNature.getAnnotationDotName());
        this.referencedEntityType = this.determineReferencedEntityType(annotationInstance);
        this.mappedBy = this.determineMappedByAttributeName(annotationInstance);
        this.isOptional = this.determineOptionality(annotationInstance);
        this.isLazy = this.determineFetchType(annotationInstance);
        this.isOrphanRemoval = this.determineOrphanRemoval(annotationInstance);
        this.cascadeTypes = this.determineCascadeTypes(annotationInstance);
        this.fetchMode = this.determineFetchMode();
        this.referencedIdAttributeName = this.determineMapsId();
        this.mapsId = this.referencedIdAttributeName != null;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public String getReferencedEntityType() {
        return this.referencedEntityType;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public AttributeNature getAssociationNature() {
        return this.associationNature;
    }

    public Set<CascadeType> getCascadeTypes() {
        return this.cascadeTypes;
    }

    public boolean isOrphanRemoval() {
        return this.isOrphanRemoval;
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public String getReferencedIdAttributeName() {
        return this.referencedIdAttributeName;
    }

    public boolean mapsId() {
        return this.mapsId;
    }

    @Override
    public AttributeTypeResolver getHibernateTypeResolver() {
        if (this.resolver == null) {
            this.resolver = this.getDefaultHibernateTypeResolver();
        }
        return this.resolver;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    @Override
    public PropertyGeneration getPropertyGeneration() {
        return PropertyGeneration.NEVER;
    }

    private AttributeTypeResolver getDefaultHibernateTypeResolver() {
        return new CompositeAttributeTypeResolver(new AttributeTypeResolverImpl(this));
    }

    private boolean ignoreNotFound() {
        AnnotationValue annotationValue;
        NotFoundAction notFoundAction = NotFoundAction.EXCEPTION;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.NOT_FOUND);
        if (annotationInstance != null && (annotationValue = annotationInstance.value("action")) != null) {
            notFoundAction = Enum.valueOf(NotFoundAction.class, annotationValue.asEnum());
        }
        return NotFoundAction.IGNORE.equals((Object)notFoundAction);
    }

    private boolean determineOptionality(AnnotationInstance annotationInstance) {
        boolean bl = true;
        AnnotationValue annotationValue = annotationInstance.value("optional");
        if (annotationValue != null) {
            bl = annotationValue.asBoolean();
        }
        return bl;
    }

    private boolean determineOrphanRemoval(AnnotationInstance annotationInstance) {
        boolean bl = false;
        AnnotationValue annotationValue = annotationInstance.value("orphanRemoval");
        if (annotationValue != null) {
            bl = annotationValue.asBoolean();
        }
        return bl;
    }

    private boolean determineFetchType(AnnotationInstance annotationInstance) {
        FetchType fetchType;
        boolean bl = false;
        AnnotationValue annotationValue = annotationInstance.value("fetch");
        if (annotationValue != null && FetchType.LAZY.equals((Object)(fetchType = Enum.valueOf(FetchType.class, annotationValue.asEnum())))) {
            bl = true;
        }
        return bl;
    }

    private String determineReferencedEntityType(AnnotationInstance annotationInstance) {
        AnnotationValue annotationValue;
        String string = this.getAttributeType().getName();
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.TARGET);
        if (annotationInstance2 != null) {
            string = annotationInstance2.value().asClass().name().toString();
        }
        if ((annotationValue = annotationInstance.value("targetEntity")) != null) {
            string = annotationValue.asClass().name().toString();
        }
        return string;
    }

    private String determineMappedByAttributeName(AnnotationInstance annotationInstance) {
        String string = null;
        AnnotationValue annotationValue = annotationInstance.value("mappedBy");
        if (annotationValue != null) {
            string = annotationValue.asString();
        }
        return string;
    }

    private Set<CascadeType> determineCascadeTypes(AnnotationInstance annotationInstance) {
        HashSet<CascadeType> hashSet = new HashSet<CascadeType>();
        AnnotationValue annotationValue = annotationInstance.value("cascade");
        if (annotationValue != null) {
            String[] stringArray;
            for (String string : stringArray = annotationValue.asEnumArray()) {
                hashSet.add(Enum.valueOf(CascadeType.class, string));
            }
        }
        return hashSet;
    }

    private FetchMode determineFetchMode() {
        FetchMode fetchMode = FetchMode.DEFAULT;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.FETCH);
        if (annotationInstance != null) {
            org.hibernate.annotations.FetchMode fetchMode2 = JandexHelper.getEnumValue(annotationInstance, "value", org.hibernate.annotations.FetchMode.class);
            fetchMode = EnumConversionHelper.annotationFetchModeToHibernateFetchMode(fetchMode2);
        }
        return fetchMode;
    }

    private String determineMapsId() {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(this.annotations(), JPADotNames.MAPS_ID);
        if (annotationInstance == null) {
            return null;
        }
        if (!AttributeNature.MANY_TO_ONE.equals((Object)this.getAssociationNature()) && !AttributeNature.MANY_TO_ONE.equals((Object)this.getAssociationNature())) {
            throw new MappingException("@MapsId can only be specified on a many-to-one or one-to-one associations", this.getContext().getOrigin());
        }
        String string = JandexHelper.getValue(annotationInstance, "value", String.class);
        return string;
    }
}

