/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static String getPropertyName(Member member) {
        String string = null;
        if (member instanceof Field) {
            string = member.getName();
        }
        if (member instanceof Method) {
            String string2 = member.getName();
            if (string2.startsWith("is")) {
                string = Introspector.decapitalize(string2.substring(2));
            } else if (string2.startsWith("has")) {
                string = Introspector.decapitalize(string2.substring(3));
            } else if (string2.startsWith("get")) {
                string = Introspector.decapitalize(string2.substring(3));
            }
        }
        return string;
    }

    public static boolean isProperty(Member member) {
        if (member instanceof Method) {
            Method method = (Method)member;
            return !method.isSynthetic() && !method.isBridge() && !Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0 && (method.getName().startsWith("get") || method.getName().startsWith("is"));
        }
        return !Modifier.isTransient(member.getModifiers()) && !member.isSynthetic();
    }
}

