/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JandexHelper {
    private static final Map<String, Object> DEFAULT_VALUES_BY_ELEMENT = new HashMap<String, Object>();

    private JandexHelper() {
    }

    public static <T> T getValue(AnnotationInstance annotationInstance, String string, Class<T> clazz) throws AssertionFailure {
        if (Class.class.equals(clazz)) {
            throw new AssertionFailure("Annotation parameters of type Class should be retrieved as strings (fully qualified class names)");
        }
        AnnotationValue annotationValue = annotationInstance.value(string);
        try {
            if (annotationValue != null) {
                return JandexHelper.explicitAnnotationParameter(annotationValue, clazz);
            }
            return JandexHelper.defaultAnnotationParameter(JandexHelper.getDefaultValue(annotationInstance, string), clazz);
        }
        catch (ClassCastException classCastException) {
            throw new AssertionFailure(String.format("the annotation property %s of annotation %s is not of type %s", string, annotationInstance.name(), clazz.getName()));
        }
    }

    public static <T extends Enum<T>> T getEnumValue(AnnotationInstance annotationInstance, String string, Class<T> clazz) {
        AnnotationValue annotationValue = annotationInstance.value(string);
        if (annotationValue == null) {
            return (T)((Enum)JandexHelper.getDefaultValue(annotationInstance, string));
        }
        return Enum.valueOf(clazz, annotationValue.asEnum());
    }

    public static String getPropertyName(AnnotationTarget annotationTarget) {
        String string;
        if (!(annotationTarget instanceof MethodInfo) && !(annotationTarget instanceof FieldInfo)) {
            throw new AssertionFailure("Unexpected annotation target " + annotationTarget.toString());
        }
        if (annotationTarget instanceof FieldInfo) {
            return ((FieldInfo)annotationTarget).name();
        }
        String string2 = ((MethodInfo)annotationTarget).name();
        if (string2.startsWith("is")) {
            string = Introspector.decapitalize(string2.substring(2));
        } else if (string2.startsWith("has")) {
            string = Introspector.decapitalize(string2.substring(3));
        } else if (string2.startsWith("get")) {
            string = Introspector.decapitalize(string2.substring(3));
        } else {
            throw new AssertionFailure("Expected a method following the Java Bean notation");
        }
        return string;
    }

    public static AnnotationInstance getSingleAnnotation(ClassInfo classInfo, DotName dotName) throws AssertionFailure {
        return JandexHelper.getSingleAnnotation(classInfo.annotations(), dotName);
    }

    public static AnnotationInstance getSingleAnnotation(Map<DotName, List<AnnotationInstance>> map, DotName dotName) throws AssertionFailure {
        List<AnnotationInstance> list = map.get(dotName);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new AssertionFailure("Found more than one instance of the annotation " + list.get(0).name().toString() + ". Expected was one.");
    }

    public static boolean containsSingleAnnotations(Map<DotName, List<AnnotationInstance>> map, DotName dotName) throws AssertionFailure {
        return JandexHelper.getSingleAnnotation(map, dotName) != null;
    }

    public static Index indexForClass(ClassLoaderService classLoaderService, Class<?> ... classArray) {
        Indexer indexer = new Indexer();
        for (Class<?> clazz : classArray) {
            InputStream inputStream = classLoaderService.locateResourceStream(clazz.getName().replace('.', '/') + ".class");
            try {
                indexer.index(inputStream);
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("[");
                int n = 0;
                for (Class<?> clazz2 : classArray) {
                    stringBuilder.append(clazz2.getName());
                    if (n < classArray.length - 1) {
                        stringBuilder.append(",");
                    }
                    ++n;
                }
                stringBuilder.append("]");
                throw new HibernateException("Unable to create annotation index for " + stringBuilder.toString());
            }
        }
        return indexer.complete();
    }

    public static Map<DotName, List<AnnotationInstance>> getMemberAnnotations(ClassInfo classInfo, String string) {
        if (classInfo == null) {
            throw new IllegalArgumentException("classInfo cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        HashMap<DotName, List<AnnotationInstance>> hashMap = new HashMap<DotName, List<AnnotationInstance>>();
        for (List list : classInfo.annotations().values()) {
            for (AnnotationInstance annotationInstance : list) {
                String string2 = null;
                if (annotationInstance.target() instanceof FieldInfo) {
                    string2 = ((FieldInfo)annotationInstance.target()).name();
                } else if (annotationInstance.target() instanceof MethodInfo) {
                    string2 = ((MethodInfo)annotationInstance.target()).name();
                }
                if (string2 == null || !string.equals(string2)) continue;
                JandexHelper.addAnnotationToMap(annotationInstance, hashMap);
            }
        }
        return hashMap;
    }

    private static void addAnnotationToMap(AnnotationInstance annotationInstance, Map<DotName, List<AnnotationInstance>> map) {
        List<Object> list;
        DotName dotName = annotationInstance.name();
        if (map.containsKey(dotName)) {
            list = map.get(dotName);
        } else {
            list = new ArrayList();
            map.put(dotName, list);
        }
        list.add(annotationInstance);
    }

    private static Object getDefaultValue(AnnotationInstance annotationInstance, String string) {
        String string2 = annotationInstance.name().toString();
        String string3 = string2 + '.' + string;
        Object object = DEFAULT_VALUES_BY_ELEMENT.get(string3);
        if (object != null) {
            return object;
        }
        try {
            object = Index.class.getClassLoader().loadClass(string2).getMethod(string, new Class[0]).getDefaultValue();
            DEFAULT_VALUES_BY_ELEMENT.put(string3, object);
            return object == null ? null : object;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new AssertionFailure(String.format("The annotation %s does not define a parameter '%s'", string2, string), exception);
        }
    }

    private static <T> T defaultAnnotationParameter(Object annotationInstanceArray, Class<T> clazz) {
        AnnotationInstance[] annotationInstanceArray2 = annotationInstanceArray;
        if (annotationInstanceArray.getClass().isArray() && annotationInstanceArray.getClass().getComponentType().isAnnotation()) {
            annotationInstanceArray2 = new AnnotationInstance[]{};
        }
        return clazz.cast(annotationInstanceArray2);
    }

    private static <T> T explicitAnnotationParameter(AnnotationValue annotationValue, Class<T> clazz) {
        Object[] objectArray = annotationValue.value();
        if (objectArray instanceof Type) {
            objectArray = ((Type)objectArray).name().toString();
        }
        if (clazz.isArray()) {
            AnnotationValue[] annotationValueArray = (AnnotationValue[])objectArray;
            Class<?> clazz2 = clazz.getComponentType();
            Object[] objectArray2 = (Object[])Array.newInstance(clazz2, annotationValueArray.length);
            for (int i = 0; i < annotationValueArray.length; ++i) {
                objectArray2[i] = clazz2.cast(annotationValueArray[i].value());
            }
            objectArray = objectArray2;
        }
        return clazz.cast(objectArray);
    }
}

