/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.GenerationType;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.internal.util.collections.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConversionHelper {
    private EnumConversionHelper() {
    }

    public static String generationTypeToGeneratorStrategyName(GenerationType generationType, boolean bl) {
        switch (generationType) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return bl ? "enhanced-sequence" : "native";
            }
            case TABLE: {
                return bl ? "enhanced-table" : MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return bl ? "enhanced-sequence" : "seqhilo";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + (Object)((Object)generationType));
    }

    public static CascadeStyle cascadeTypeToCascadeStyle(CascadeType cascadeType) {
        switch (cascadeType) {
            case ALL: {
                return CascadeStyle.ALL;
            }
            case PERSIST: {
                return CascadeStyle.PERSIST;
            }
            case MERGE: {
                return CascadeStyle.MERGE;
            }
            case REMOVE: {
                return CascadeStyle.DELETE;
            }
            case REFRESH: {
                return CascadeStyle.REFRESH;
            }
            case DETACH: {
                return CascadeStyle.EVICT;
            }
        }
        throw new AssertionFailure("Unknown cascade type");
    }

    public static FetchMode annotationFetchModeToHibernateFetchMode(org.hibernate.annotations.FetchMode fetchMode) {
        switch (fetchMode) {
            case JOIN: {
                return FetchMode.JOIN;
            }
            case SELECT: {
                return FetchMode.SELECT;
            }
            case SUBSELECT: {
                return FetchMode.SELECT;
            }
        }
        throw new AssertionFailure("Unknown fetch mode");
    }

    public static Set<CascadeStyle> cascadeTypeToCascadeStyleSet(Set<CascadeType> set) {
        if (CollectionHelper.isEmpty(set)) {
            return Collections.emptySet();
        }
        HashSet<CascadeStyle> hashSet = new HashSet<CascadeStyle>();
        for (CascadeType cascadeType : set) {
            hashSet.add(EnumConversionHelper.cascadeTypeToCascadeStyle(cascadeType));
        }
        return hashSet;
    }
}

