/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AccessType;
import javax.persistence.InheritanceType;
import org.hibernate.AnnotationException;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.EntityHierarchyImpl;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.entity.EntityClass;
import org.hibernate.metamodel.source.annotations.entity.RootEntitySourceImpl;
import org.hibernate.metamodel.source.annotations.entity.SubclassEntitySourceImpl;
import org.hibernate.metamodel.source.binder.EntityHierarchy;
import org.hibernate.metamodel.source.binder.EntitySource;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityHierarchyBuilder {
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());

    public static Set<EntityHierarchy> createEntityHierarchies(AnnotationBindingContext annotationBindingContext) {
        HashSet<EntityHierarchy> hashSet = new HashSet<EntityHierarchy>();
        ArrayList<DotName> arrayList = new ArrayList<DotName>();
        HashMap<DotName, List<ClassInfo>> hashMap = new HashMap<DotName, List<ClassInfo>>();
        Index index = annotationBindingContext.getIndex();
        for (ClassInfo classInfo : index.getKnownClasses()) {
            if (!EntityHierarchyBuilder.isEntityClass(classInfo) || arrayList.contains(classInfo.name())) continue;
            ClassInfo classInfo2 = EntityHierarchyBuilder.findRootEntityClassInfo(index, classInfo);
            ArrayList<ClassInfo> arrayList2 = new ArrayList<ClassInfo>();
            EntityHierarchyBuilder.addMappedSuperclasses(index, classInfo2, arrayList2);
            EntityHierarchyBuilder.processHierarchy(annotationBindingContext, classInfo2, arrayList2, arrayList, hashMap);
            AccessType accessType = EntityHierarchyBuilder.determineDefaultAccessType(arrayList2);
            org.hibernate.metamodel.binding.InheritanceType inheritanceType = EntityHierarchyBuilder.determineInheritanceType(classInfo2, arrayList2);
            EntityClass entityClass = new EntityClass(classInfo2, null, accessType, inheritanceType, annotationBindingContext);
            RootEntitySourceImpl rootEntitySourceImpl = new RootEntitySourceImpl(entityClass);
            EntityHierarchyBuilder.addSubclassEntitySources(annotationBindingContext, hashMap, accessType, inheritanceType, entityClass, rootEntitySourceImpl);
            hashSet.add(new EntityHierarchyImpl(rootEntitySourceImpl, inheritanceType));
        }
        return hashSet;
    }

    private static void addSubclassEntitySources(AnnotationBindingContext annotationBindingContext, Map<DotName, List<ClassInfo>> map, AccessType accessType, org.hibernate.metamodel.binding.InheritanceType inheritanceType, EntityClass entityClass, EntitySource entitySource) {
        List<ClassInfo> list = map.get(DotName.createSimple((String)entitySource.getClassName()));
        if (list == null) {
            return;
        }
        for (ClassInfo classInfo : list) {
            EntityClass entityClass2 = new EntityClass(classInfo, entityClass, accessType, inheritanceType, annotationBindingContext);
            SubclassEntitySourceImpl subclassEntitySourceImpl = new SubclassEntitySourceImpl(entityClass2);
            entitySource.add(subclassEntitySourceImpl);
            EntityHierarchyBuilder.addSubclassEntitySources(annotationBindingContext, map, accessType, inheritanceType, entityClass2, subclassEntitySourceImpl);
        }
    }

    private static ClassInfo findRootEntityClassInfo(Index index, ClassInfo classInfo) {
        ClassInfo classInfo2 = classInfo;
        DotName dotName = classInfo.superName();
        while (!OBJECT.equals((Object)dotName)) {
            ClassInfo classInfo3 = index.getClassByName(dotName);
            if (EntityHierarchyBuilder.isEntityClass(classInfo3)) {
                classInfo2 = classInfo3;
            }
            dotName = classInfo3.superName();
        }
        return classInfo2;
    }

    private static void addMappedSuperclasses(Index index, ClassInfo classInfo, List<ClassInfo> list) {
        DotName dotName = classInfo.superName();
        while (!OBJECT.equals((Object)dotName)) {
            ClassInfo classInfo2 = index.getClassByName(dotName);
            if (EntityHierarchyBuilder.isMappedSuperclass(classInfo2)) {
                list.add(classInfo2);
            }
            dotName = classInfo2.superName();
        }
    }

    private static void processHierarchy(AnnotationBindingContext annotationBindingContext, ClassInfo classInfo, List<ClassInfo> list, List<DotName> list2, Map<DotName, List<ClassInfo>> map) {
        list2.add(classInfo.name());
        list.add(classInfo);
        List list3 = annotationBindingContext.getIndex().getKnownDirectSubclasses(classInfo.name());
        if (list3.isEmpty()) {
            annotationBindingContext.resolveAllTypes(classInfo.name().toString());
        }
        for (ClassInfo classInfo2 : list3) {
            EntityHierarchyBuilder.addSubClassToSubclassMap(classInfo.name(), classInfo2, map);
            EntityHierarchyBuilder.processHierarchy(annotationBindingContext, classInfo2, list, list2, map);
        }
    }

    private static void addSubClassToSubclassMap(DotName dotName, ClassInfo classInfo, Map<DotName, List<ClassInfo>> map) {
        if (map.containsKey(dotName)) {
            map.get(dotName).add(classInfo);
        } else {
            ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
            arrayList.add(classInfo);
            map.put(dotName, arrayList);
        }
    }

    private static boolean isEntityClass(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(classInfo, JPADotNames.ENTITY);
        if (annotationInstance == null) {
            return false;
        }
        AnnotationInstance annotationInstance2 = JandexHelper.getSingleAnnotation(classInfo, JPADotNames.MAPPED_SUPERCLASS);
        String string = classInfo.toString();
        EntityHierarchyBuilder.assertNotEntityAndMappedSuperClass(annotationInstance, annotationInstance2, string);
        AnnotationInstance annotationInstance3 = JandexHelper.getSingleAnnotation(classInfo, JPADotNames.EMBEDDABLE);
        EntityHierarchyBuilder.assertNotEntityAndEmbeddable(annotationInstance, annotationInstance3, string);
        return true;
    }

    private static boolean isMappedSuperclass(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(classInfo, JPADotNames.MAPPED_SUPERCLASS);
        return annotationInstance != null;
    }

    private static void assertNotEntityAndMappedSuperClass(AnnotationInstance annotationInstance, AnnotationInstance annotationInstance2, String string) {
        if (annotationInstance != null && annotationInstance2 != null) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @MappedSuperclass. " + string + " has both annotations.");
        }
    }

    private static void assertNotEntityAndEmbeddable(AnnotationInstance annotationInstance, AnnotationInstance annotationInstance2, String string) {
        if (annotationInstance != null && annotationInstance2 != null) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @Embeddable. " + string + " has both annotations.");
        }
    }

    private static AccessType determineDefaultAccessType(List<ClassInfo> list) {
        AccessType accessType = null;
        AccessType accessType2 = null;
        for (ClassInfo classInfo : list) {
            List list2 = (List)classInfo.annotations().get(JPADotNames.ID);
            List list3 = (List)classInfo.annotations().get(JPADotNames.EMBEDDED_ID);
            if (CollectionHelper.isNotEmpty(list3)) {
                accessType = EntityHierarchyBuilder.determineAccessTypeByIdPlacement(list3);
            }
            if (!CollectionHelper.isNotEmpty(list2)) continue;
            accessType2 = EntityHierarchyBuilder.determineAccessTypeByIdPlacement(list2);
        }
        if (accessType != null) {
            return accessType;
        }
        if (accessType2 != null) {
            return accessType2;
        }
        return EntityHierarchyBuilder.throwIdNotFoundAnnotationException(list);
    }

    private static AccessType determineAccessTypeByIdPlacement(List<AnnotationInstance> list) {
        AccessType accessType = null;
        for (AnnotationInstance annotationInstance : list) {
            AccessType accessType2;
            if (annotationInstance.target() instanceof FieldInfo) {
                accessType2 = AccessType.FIELD;
            } else if (annotationInstance.target() instanceof MethodInfo) {
                accessType2 = AccessType.PROPERTY;
            } else {
                throw new AnnotationException("Invalid placement of @Id annotation");
            }
            if (accessType == null) {
                accessType = accessType2;
                continue;
            }
            if (accessType.equals((Object)accessType2)) continue;
            throw new AnnotationException("Inconsistent placement of @Id annotation within hierarchy ");
        }
        return accessType;
    }

    private static org.hibernate.metamodel.binding.InheritanceType determineInheritanceType(ClassInfo classInfo, List<ClassInfo> list) {
        if (list.size() == 1) {
            return org.hibernate.metamodel.binding.InheritanceType.NO_INHERITANCE;
        }
        org.hibernate.metamodel.binding.InheritanceType inheritanceType = org.hibernate.metamodel.binding.InheritanceType.SINGLE_TABLE;
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(classInfo, JPADotNames.INHERITANCE);
        if (annotationInstance != null) {
            String string = annotationInstance.value("strategy").asEnum();
            InheritanceType inheritanceType2 = Enum.valueOf(InheritanceType.class, string);
            inheritanceType = org.hibernate.metamodel.binding.InheritanceType.get(inheritanceType2);
        }
        for (ClassInfo classInfo2 : list) {
            if (classInfo.equals(classInfo2) || (annotationInstance = JandexHelper.getSingleAnnotation(classInfo2, JPADotNames.INHERITANCE)) == null) continue;
            throw new AnnotationException(String.format("The inheritance type for %s must be specified on the root entity %s", EntityHierarchyBuilder.hierarchyListString(list), classInfo.name().toString()));
        }
        return inheritanceType;
    }

    private static AccessType throwIdNotFoundAnnotationException(List<ClassInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to determine identifier attribute for class hierarchy consisting of the classe(s) ");
        stringBuilder.append(EntityHierarchyBuilder.hierarchyListString(list));
        throw new AnnotationException(stringBuilder.toString());
    }

    private static String hierarchyListString(List<ClassInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = 0;
        for (ClassInfo classInfo : list) {
            stringBuilder.append(classInfo.name().toString());
            if (n < list.size() - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

