/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.internal.jaxb.JaxbRoot;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntityMappings;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.MetadataSourceProcessor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContextImpl;
import org.hibernate.metamodel.source.annotations.EntityHierarchyBuilder;
import org.hibernate.metamodel.source.annotations.global.FetchProfileBinder;
import org.hibernate.metamodel.source.annotations.global.FilterDefBinder;
import org.hibernate.metamodel.source.annotations.global.IdGeneratorBinder;
import org.hibernate.metamodel.source.annotations.global.QueryBinder;
import org.hibernate.metamodel.source.annotations.global.TableBinder;
import org.hibernate.metamodel.source.annotations.global.TypeDefBinder;
import org.hibernate.metamodel.source.annotations.xml.PseudoJpaDotNames;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.binder.Binder;
import org.hibernate.metamodel.source.binder.EntityHierarchy;
import org.hibernate.metamodel.source.internal.MetadataImpl;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMetadataSourceProcessorImpl
implements MetadataSourceProcessor {
    private static final Logger LOG = Logger.getLogger(AnnotationMetadataSourceProcessorImpl.class);
    private final MetadataImplementor metadata;
    private AnnotationBindingContext bindingContext;

    public AnnotationMetadataSourceProcessorImpl(MetadataImpl metadataImpl) {
        this.metadata = metadataImpl;
    }

    @Override
    public void prepare(MetadataSources metadataSources) {
        Indexer indexer = new Indexer();
        for (Class<?> arrayList2 : metadataSources.getAnnotatedClasses()) {
            this.indexClass(indexer, arrayList2.getName().replace('.', '/') + ".class");
        }
        for (String string : metadataSources.getAnnotatedPackages()) {
            this.indexClass(indexer, string.replace('.', '/') + "/package-info.class");
        }
        Iterator<Object> iterator = indexer.complete();
        ArrayList<JaxbRoot<JaxbEntityMappings>> arrayList = new ArrayList<JaxbRoot<JaxbEntityMappings>>();
        for (JaxbRoot jaxbRoot : metadataSources.getJaxbRootList()) {
            if (!(jaxbRoot.getRoot() instanceof JaxbEntityMappings)) continue;
            arrayList.add(jaxbRoot);
        }
        if (!arrayList.isEmpty()) {
            iterator = this.parseAndUpdateIndex((List<JaxbRoot<JaxbEntityMappings>>)arrayList, (Index)iterator);
        }
        if (iterator.getAnnotations(PseudoJpaDotNames.DEFAULT_DELIMITED_IDENTIFIERS) != null) {
            this.metadata.setGloballyQuotedIdentifiers(true);
        }
        this.bindingContext = new AnnotationBindingContextImpl(this.metadata, (Index)iterator);
    }

    @Override
    public void processIndependentMetadata(MetadataSources metadataSources) {
        this.assertBindingContextExists();
        TypeDefBinder.bind(this.bindingContext);
    }

    private void assertBindingContextExists() {
        if (this.bindingContext == null) {
            throw new AssertionFailure("The binding context should exist. Has prepare been called!?");
        }
    }

    @Override
    public void processTypeDependentMetadata(MetadataSources metadataSources) {
        this.assertBindingContextExists();
        IdGeneratorBinder.bind(this.bindingContext);
    }

    @Override
    public void processMappingMetadata(MetadataSources metadataSources, List<String> list) {
        this.assertBindingContextExists();
        Set<EntityHierarchy> set = EntityHierarchyBuilder.createEntityHierarchies(this.bindingContext);
        Binder binder = new Binder(this.bindingContext.getMetadataImplementor(), new ArrayList<String>());
        for (EntityHierarchy entityHierarchy : set) {
            binder.processEntityHierarchy(entityHierarchy);
        }
    }

    @Override
    public void processMappingDependentMetadata(MetadataSources metadataSources) {
        TableBinder.bind(this.bindingContext);
        FetchProfileBinder.bind(this.bindingContext);
        QueryBinder.bind(this.bindingContext);
        FilterDefBinder.bind(this.bindingContext);
    }

    private Index parseAndUpdateIndex(List<JaxbRoot<JaxbEntityMappings>> list, Index index) {
        ArrayList<JaxbEntityMappings> arrayList = new ArrayList<JaxbEntityMappings>(list.size());
        for (JaxbRoot<JaxbEntityMappings> jaxbRoot : list) {
            arrayList.add(jaxbRoot.getRoot());
        }
        return new EntityMappingsMocker(arrayList, index, this.metadata.getServiceRegistry()).mockNewIndex();
    }

    private void indexClass(Indexer indexer, String string) {
        InputStream inputStream = this.metadata.getServiceRegistry().getService(ClassLoaderService.class).locateResourceStream(string);
        try {
            indexer.index(inputStream);
        }
        catch (IOException iOException) {
            throw new HibernateException("Unable to open input stream for class " + string, iOException);
        }
    }
}

